/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.view;

import calculateCodeDifference.view.CalculateCodeParameter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class ProjectSelectionGroup {
    private static final int THIS_SPACING = 10;
    private static final int THIS_MARGIN_WIDTH = 10;
    private static final String LABEL_INITIAL = "no project selected\t\t\t\t\t\t\t\t\t\t";
    private static final String LABEL_START = "Selected project: ";
    private static final String GROUP_TITLE_NEW = "New project";
    private static final String GROUP_TITLE_OLD = "Old project";
    private static final String INTERNAL_RADIOBUTTON_TEXT = "internal project";
    private static final String EXTERNAL_RADIOBUTTON_TEXT = "external project";
    private CalculateCodeParameter.ProjectType type;
    private CalculateCodeParameter param;
    private Group group;
    private Label label;

    ProjectSelectionGroup(final Composite parent, CalculateCodeParameter param, CalculateCodeParameter.ProjectType type) {
        this.type = type;
        this.param = param;
        this.group = new Group(parent, 0);
        if (CalculateCodeParameter.ProjectType.NEW.equals((Object)this.type)) {
            this.group.setText(GROUP_TITLE_NEW);
        } else {
            this.group.setText(GROUP_TITLE_OLD);
        }
        FillLayout thisLayout = new FillLayout(512);
        thisLayout.spacing = 10;
        thisLayout.marginWidth = 10;
        this.group.setLayout((Layout)thisLayout);
        Composite radioButtons = new Composite((Composite)this.group, 0);
        radioButtons.setLayout((Layout)new FillLayout());
        final Button internalRadioButton = new Button(radioButtons, 16);
        internalRadioButton.setText(INTERNAL_RADIOBUTTON_TEXT);
        internalRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (internalRadioButton.getSelection()) {
                    Shell shell = parent.getShell();
                    ProjectSelectionGroup.this.openInternalProjectDialog(internalRadioButton, shell);
                }
            }
        });
        if (CalculateCodeParameter.ProjectType.OLD.equals((Object)type)) {
            final Button externalRadioButton = new Button(radioButtons, 16);
            externalRadioButton.setText(EXTERNAL_RADIOBUTTON_TEXT);
            externalRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (externalRadioButton.getSelection()) {
                        Shell shell = parent.getShell();
                        ProjectSelectionGroup.this.openExternalProjectDialog(externalRadioButton, shell);
                    }
                }
            });
        }
        this.label = new Label((Composite)this.group, 0);
        this.label.setText(LABEL_INITIAL);
    }

    private void openInternalProjectDialog(Button internalRadioButton, Shell shell) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            this.label.setText(LABEL_START + resource.getProject().getName());
            this.param.getProject(this.type).set(resource.getProject());
            this.param.resetAdditionalMethods();
            return;
        }
        this.param.getProject(this.type).reset();
        internalRadioButton.setSelection(false);
        this.label.setText(LABEL_INITIAL);
    }

    private void openExternalProjectDialog(Button externalRadioButton, Shell shell) {
        String selectedDir;
        DirectoryDialog dirDialog = new DirectoryDialog(shell);
        dirDialog.setText("Select your project directory");
        String path = this.param.getProject(this.type).getExternalPath();
        if (path != null) {
            dirDialog.setFilterPath(path);
        }
        if ((selectedDir = dirDialog.open()) != null) {
            this.label.setText(LABEL_START + selectedDir);
            this.param.getProject(this.type).set(selectedDir);
            this.param.resetAdditionalMethods();
            return;
        }
        this.param.getProject(this.type).reset();
        externalRadioButton.setSelection(false);
        this.label.setText(LABEL_INITIAL);
    }
}

