/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.test.jig;

import calculateCodeDifference.jig.JavaInterclassGraph;
import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.jig.graph.node.IMethodNode;
import calculateCodeDifference.jig.graph.node.INode;
import calculateCodeDifference.test.TestHelper;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStatementJIG {
    private static TestHelper tester;
    private static JavaInterclassGraph jig;

    @BeforeClass
    public static void setUp() throws Exception {
        tester = new TestHelper();
        tester.setUpNewProject("StatementJIG");
        tester.preNewCreateJIG();
        jig = tester.getNewJIG();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        jig = null;
        tester.tearDown();
    }

    @Test
    public void countFoundMethodsNew() {
        Assert.assertEquals((long)jig.getFoundMethods().length, (long)10L);
    }

    @Test
    public void checkSetUp() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.setUp()V|Ljava/lang/Exception;");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.setUp()V|Ljava/lang/Exception;");
        List<IEdge> edges = methodNode.getAllEdges();
        Assert.assertEquals((long)edges.size(), (long)1L);
        IEdge edge = edges.get(0);
        Assert.assertEquals((Object)edge.getLabel(), (Object)"");
        INode node = edge.getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"normal exit");
    }

    @Test
    public void checkFor() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.test_for()V");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.test_for()V");
        List<IEdge> edges = methodNode.getAllEdges();
        Assert.assertEquals((long)edges.size(), (long)1L);
        IEdge edge = edges.get(0);
        Assert.assertEquals((Object)edge.getLabel(), (Object)"");
        INode node = edge.getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"label_i:");
        node = node.getAllEdges().get(0).getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"[int i=0]");
        node = node.getAllEdges().get(0).getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"i < 5");
        edge = node.getAllEdges().get(0);
        if (!edge.getLabel().contains("true")) {
            edge = node.getAllEdges().get(1);
        }
        Assert.assertEquals((Object)edge.getLabel(), (Object)" true");
        node = edge.getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"label_j:");
        node = node.getAllEdges().get(0).getTo();
        node = node.getAllEdges().get(0).getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"j < 5");
        edge = node.getAllEdges().get(0);
        if (!edge.getLabel().contains("true")) {
            edge = node.getAllEdges().get(1);
        }
        Assert.assertEquals((Object)edge.getLabel(), (Object)" true");
        node = edge.getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"System.out.println(\"test_for i=\" + i + \" j=\"+ j);");
        node = node.getAllEdges().get(0).getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"println");
        edge = node.getAllEdges().get(0);
        if (!edge.getLabel().equals("")) {
            edge = node.getAllEdges().get(1);
        }
        Assert.assertEquals((Object)edge.getLabel(), (Object)"");
        INode ifNode = edge.getTo();
        Assert.assertEquals((Object)ifNode.getLabel(), (Object)"2 < i");
        edge = ifNode.getAllEdges().get(0);
        if (!edge.getLabel().contains("true")) {
            edge = ifNode.getAllEdges().get(1);
        }
        Assert.assertEquals((Object)edge.getLabel(), (Object)" true");
        node = edge.getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"continue label_i;");
        node = node.getAllEdges().get(0).getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"[i++]");
        edge = ifNode.getAllEdges().get(0);
        if (!edge.getLabel().contains("false")) {
            edge = ifNode.getAllEdges().get(1);
        }
        if (!(edge = (ifNode = edge.getTo()).getAllEdges().get(0)).getLabel().contains("true")) {
            edge = ifNode.getAllEdges().get(1);
        }
        node = edge.getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"break label_j;");
        node = node.getAllEdges().get(0).getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"[i++]");
        edge = ifNode.getAllEdges().get(0);
        if (!edge.getLabel().contains("false")) {
            edge = ifNode.getAllEdges().get(1);
        }
        node = edge.getTo();
        Assert.assertEquals((Object)node.getLabel(), (Object)"[j++]");
    }

    @Test
    public void checkWhile() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.test_while()V");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.test_while()V");
    }

    @Test
    public void checkDoWhile() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.test_doWhile()V");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.test_doWhile()V");
    }

    @Test
    public void checkAssert() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.test_assert()V");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.test_assert()V");
    }

    @Test
    public void checkSwitch() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.test_switch()V");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.test_switch()V");
    }

    @Test
    public void checkSynchronized() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.test_synchronized()V");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.test_synchronized()V");
    }

    @Test
    public void checkTryCatch() {
        List<IMethodNode> methodNodes = jig.getMethod("LTestCasesCFG;.test_tryCatch()V");
        Assert.assertEquals((long)methodNodes.size(), (long)1L);
        IMethodNode methodNode = methodNodes.get(0);
        Assert.assertEquals((Object)methodNode.getLabel(), (Object)"LTestCasesCFG;.test_tryCatch()V");
    }
}

