/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.test.compare;

import calculateCodeDifference.compareJIG.Comparator;
import calculateCodeDifference.helper.exception.InternalFailureException;
import calculateCodeDifference.jig.JavaInterclassGraph;
import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCCDdeleteInternalOverridesMethod {
    private static TestHelper tester;
    private static JavaInterclassGraph oldJIG;
    private static JavaInterclassGraph newJIG;
    private static Comparator comparator;

    @BeforeClass
    public static void setUp() throws Exception {
        tester = new TestHelper();
        tester.setUpNewProject("calculateCodeDifferenceRev124ohneSaveLastNode");
        tester.setUpOldProject("calculateCodeDifferenceRev124");
        tester.preCompare();
        oldJIG = tester.getOldJIG();
        newJIG = tester.getNewJIG();
        comparator = tester.getComparator();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        oldJIG = null;
        newJIG = null;
        comparator = null;
        tester.tearDown();
    }

    @Test
    public void countFoundMethodsNew() {
        Assert.assertEquals((long)newJIG.getFoundMethods().length, (long)414L);
    }

    @Test
    public void countFoundMethodsOld() {
        Assert.assertEquals((long)oldJIG.getFoundMethods().length, (long)415L);
    }

    @Test
    public void noBigChanges() {
        Assert.assertTrue((boolean)comparator.getBigChanges().isEmpty());
    }

    @Test
    public void noDangerousEdges() {
        try {
            Assert.assertEquals((long)comparator.getDangerousEdges().size(), (long)6L);
        }
        catch (InternalFailureException internalFailureException) {
            Assert.fail((String)"get dangerous edges failed");
        }
    }

    @Test
    public void checkEdges() {
        int found = 0;
        try {
            for (IEdge x : comparator.getDangerousEdges()) {
                if (!x.getFrom().getLabel().equals("saveLastNode") || !x.getLabel().equals("LcalculateCodeDifference/jig/graph/node/TempNode;") || !x.getTo().getLabel().equals("LcalculateCodeDifference/jig/graph/node/INode;.saveLastNode(LcalculateCodeDifference/jig/graph/edge/IEdge;)V")) continue;
                ++found;
            }
            Assert.assertEquals((long)found, (long)6L);
        }
        catch (InternalFailureException internalFailureException) {
            Assert.fail((String)"get dangerous edges failed");
        }
    }
}

