/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig.graph.node;

import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.jig.graph.edge.NormalEdge;
import calculateCodeDifference.jig.graph.node.ANode;
import calculateCodeDifference.jig.graph.node.INode;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;

public class ConditionNode
extends ANode {
    private NormalEdge trueEdge;
    private NormalEdge falseEdge;
    private BranchType type = BranchType.BOTH;
    private ASTNode astNode;

    public ConditionNode(ASTNode astNode, String condition) {
        super(condition);
        this.astNode = astNode;
    }

    @Override
    public ASTNode getASTNode() {
        return this.astNode;
    }

    public void setBranch(BranchType type) {
        this.type = type;
    }

    @Override
    public void setDestinationNode(INode node, String label) {
        if (this == node) {
            return;
        }
        if (this.type != BranchType.FALSE) {
            if (this.trueEdge != null) {
                this.trueEdge.getTo().setDestinationNode(node, label);
            } else {
                this.trueEdge = new NormalEdge(this, node, String.valueOf(label) + " true");
                node.saveLastNode(this.trueEdge);
            }
        }
        if (this.type != BranchType.TRUE) {
            if (this.falseEdge != null) {
                this.falseEdge.getTo().setDestinationNode(node, label);
            } else {
                this.falseEdge = new NormalEdge(this, node, String.valueOf(label) + " false");
                node.saveLastNode(this.falseEdge);
            }
        }
    }

    @Override
    public List<IEdge> getAllEdges() {
        List<IEdge> l = super.getAllEdges();
        if (this.falseEdge != null) {
            l.add(this.falseEdge);
        }
        if (this.trueEdge != null) {
            l.add(this.trueEdge);
        }
        return l;
    }

    @Override
    public String toString() {
        String result = String.valueOf(super.toString()) + "TRUE->";
        result = this.trueEdge != null ? String.valueOf(result) + this.trueEdge.getTo().getID() : String.valueOf(result) + "null";
        result = String.valueOf(result) + " FALSE->";
        result = this.falseEdge != null ? String.valueOf(result) + this.falseEdge.getTo().getID() : String.valueOf(result) + "null";
        return result;
    }

    public static enum BranchType {
        TRUE,
        FALSE,
        BOTH;

    }
}

