/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig.graph.node;

import calculateCodeDifference.jig.graph.edge.CallEdge;
import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.jig.graph.edge.PathEdge;
import calculateCodeDifference.jig.graph.node.INode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class ANode
implements INode {
    private static int nextID = 1;
    private static List<INode> list = new LinkedList<INode>();
    private int id;
    private String label;
    private PathEdge pathEdge;
    private List<CallEdge> callEdges;

    ANode(String label) {
        this.label = label.replaceAll("\\n", "");
        this.id = nextID++;
        list.add(this);
        this.pathEdge = null;
        this.callEdges = new ArrayList<CallEdge>();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setDestinationNode(INode node, String label) {
    }

    public static void resetID() {
        nextID = 1;
        list.clear();
    }

    public static Iterator<INode> getNodeIterator() {
        return list.iterator();
    }

    @Override
    public void addPathDestinationNode(INode destinationNode, String label) {
        this.pathEdge = new PathEdge(this, destinationNode, label);
        destinationNode.saveLastNode(this.pathEdge);
    }

    @Override
    public void addCallDestinationNode(INode destinationNode, String label) {
        for (IEdge iEdge : this.callEdges) {
            if (!iEdge.getLabel().equals(label) || !iEdge.getTo().equals(destinationNode)) continue;
            return;
        }
        CallEdge callEdge = new CallEdge(this, destinationNode, label);
        this.callEdges.add(callEdge);
        destinationNode.saveLastNode(callEdge);
    }

    public PathEdge getPathEdge() {
        return this.pathEdge;
    }

    @Override
    public List<IEdge> getAllEdges() {
        ArrayList<IEdge> l = new ArrayList<IEdge>();
        if (this.pathEdge != null) {
            l.add(this.pathEdge);
        }
        if (!this.callEdges.isEmpty()) {
            l.addAll(this.callEdges);
        }
        return l;
    }

    @Override
    public void saveLastNode(IEdge edge) {
    }

    public String toString() {
        StringBuffer callEdgesString = new StringBuffer();
        callEdgesString.append("callEdge: ");
        for (CallEdge x : this.callEdges) {
            callEdgesString.append(String.valueOf(x.toStringOnlyDestID()) + " ");
        }
        String result = "(" + this.id + ")\t" + this.getLabel() + " ";
        if (this.pathEdge != null) {
            result = String.valueOf(result) + "(" + this.pathEdge.toString() + ") ";
        }
        if (!this.callEdges.isEmpty()) {
            result = String.valueOf(result) + "(" + callEdgesString.toString() + ") ";
        }
        return result;
    }
}

