/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig;

import calculateCodeDifference.helper.CCDHashMap;
import calculateCodeDifference.helper.CCDHashMapList;
import calculateCodeDifference.jig.CallEdgeModel;
import calculateCodeDifference.jig.OtherEntry;
import calculateCodeDifference.jig.graph.node.IClassNode;
import calculateCodeDifference.jig.graph.node.IMethodNode;
import calculateCodeDifference.jig.graph.node.INode;
import calculateCodeDifference.jig.graph.node.MethodNode;
import calculateCodeDifference.jig.graph.node.StaticNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Initializer;

class LinkManager {
    private CCDHashMap<String, IClassNode> classes = new CCDHashMap();
    private CCDHashMapList<String, MethodNode> declMethodsInClass = new CCDHashMapList();
    private List<MethodNode> foundMethods = new LinkedList<MethodNode>();
    private List<IMethodNode> foundConstructors = new LinkedList<IMethodNode>();
    private CCDHashMapList<String, CallEdgeModel> methodSourceToNode = new CCDHashMapList();
    private CCDHashMap<String, IMethodBinding> externalBindings = new CCDHashMap();
    private CCDHashMapList<String, OtherEntry> otherConstructorDeclarations = new CCDHashMapList();
    private CCDHashMapList<String, StaticNode> staticDeclarations = new CCDHashMapList();
    private CCDHashMap<IBinding, String> variableDeclaration = new CCDHashMap();
    private CCDHashMapList<String, INode> newInstanceStatements = new CCDHashMapList();
    private List<String> bindingsToFind = new LinkedList<String>();

    LinkManager() {
        this.bindingsToFind.add("Ljava/util/Iterator;.next()TE;");
        this.bindingsToFind.add("Ljava/util/Iterator;.hasNext()Z");
        this.bindingsToFind.add("Ljava/lang/Iterable;.iterator()Ljava/util/Iterator<TT;>;");
    }

    public CCDHashMap<String, IClassNode> getClasses() {
        return this.classes;
    }

    public void putClass(String classKey, IClassNode value) {
        this.classes.put(classKey, value);
    }

    public String getGloballyQualifiedClassName(String classKey) {
        IClassNode classNode = (IClassNode)this.classes.get(classKey);
        if (classNode == null) {
            return classKey;
        }
        return classNode.getGloballyQualifiedClassName();
    }

    public List<MethodNode> getDeclMethodsInClass(String key) {
        return this.declMethodsInClass.get(key);
    }

    public void addDeclMethodsInClass(String key, MethodNode value) {
        this.declMethodsInClass.addOnce(key, value);
    }

    public List<MethodNode> getFoundMethods() {
        return this.foundMethods;
    }

    public List<IMethodNode> getFoundConstructors() {
        return this.foundConstructors;
    }

    public List<CallEdgeModel> getMethodSourceToNode(String key) {
        return this.methodSourceToNode.get(key);
    }

    public void addMethodSourceToNode(String key, String sourceClass, IMethodNode methodNode) {
        this.methodSourceToNode.addOnce(key, new CallEdgeModel(sourceClass, methodNode));
    }

    public Iterator<String> getSpecialBindingsToFind() {
        return this.bindingsToFind.iterator();
    }

    public void addSpecialBinding(IMethodBinding binding) {
        this.externalBindings.put(binding.getKey(), binding);
    }

    public IMethodBinding getSpecialBindings(String key) {
        return (IMethodBinding)this.externalBindings.get(key);
    }

    public List<OtherEntry> getOtherConstructorDeclarations(String key) {
        return this.otherConstructorDeclarations.get(key);
    }

    public void addFieldDeclaration(String key, FieldDeclaration value) {
        this.otherConstructorDeclarations.add(key, new OtherEntry(value));
    }

    public void addInitializer(String key, Initializer value) {
        this.otherConstructorDeclarations.add(key, new OtherEntry(value));
    }

    public List<StaticNode> getStaticDeclarations(String key) {
        return this.staticDeclarations.get(key);
    }

    public void addStaticDeclaration(String key, StaticNode value) {
        this.staticDeclarations.add(key, value);
    }

    public CCDHashMap<IBinding, String> getVariableDeclaration() {
        return this.variableDeclaration;
    }

    public void addNewInstanceStatement(String classKey, INode newInstanceStatement) {
        this.newInstanceStatements.addOnce(classKey, newInstanceStatement);
    }

    public List<INode> getNewInstanceStatements(String classKey) {
        return this.newInstanceStatements.get(classKey);
    }

    public CCDHashMapList<String, INode> getNewInstanceStatements() {
        return this.newInstanceStatements;
    }
}

