/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig;

import calculateCodeDifference.ast.CCDASTRequestor;
import calculateCodeDifference.helper.CCDHashMap;
import calculateCodeDifference.helper.CCDHashMapList;
import calculateCodeDifference.jig.CCDAST;
import calculateCodeDifference.jig.CallEdgeModel;
import calculateCodeDifference.jig.LinkManager;
import calculateCodeDifference.jig.MethodFlowGraphCreatorVisitor;
import calculateCodeDifference.jig.MethodPair;
import calculateCodeDifference.jig.OtherEntry;
import calculateCodeDifference.jig.StructuralVisitor;
import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.jig.graph.node.ANode;
import calculateCodeDifference.jig.graph.node.ExternalClassNode;
import calculateCodeDifference.jig.graph.node.ExternalMethodNode;
import calculateCodeDifference.jig.graph.node.FakeStaticNode;
import calculateCodeDifference.jig.graph.node.IClassNode;
import calculateCodeDifference.jig.graph.node.IMethodNode;
import calculateCodeDifference.jig.graph.node.INode;
import calculateCodeDifference.jig.graph.node.IStaticNode;
import calculateCodeDifference.jig.graph.node.ImpliedMethodNode;
import calculateCodeDifference.jig.graph.node.MethodNode;
import calculateCodeDifference.jig.graph.node.StaticNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class JavaInterclassGraph {
    private LinkManager manager;
    private CCDASTRequestor requestor;
    private CCDHashMap<String, IClassNode> classes;
    private CCDHashMap<String, List<IMethodBinding>> externalClassMethods;
    private CCDHashMapList<String, MethodNode> internalClassMethods;
    private ExternalClassNode ecn;
    private List<IMethodNode> mainMethods;
    private List<IStaticNode> staticInitializers;
    private MethodPair[] foundMethods;

    public JavaInterclassGraph(CCDASTRequestor requestor) {
        ANode.resetID();
        this.manager = new LinkManager();
        this.externalClassMethods = new CCDHashMap();
        this.internalClassMethods = new CCDHashMapList();
        this.ecn = new ExternalClassNode("ECN");
        this.mainMethods = new LinkedList<IMethodNode>();
        this.staticInitializers = new LinkedList<IStaticNode>();
        this.requestor = requestor;
        this.classes = this.manager.getClasses();
    }

    public CCDHashMap<String, IClassNode> getAllClasses() {
        return this.classes;
    }

    public final void calculate() {
        this.calculateInternalClasses();
        this.createImpliedUnDeclaredConstructors();
        this.calculateJIG();
        this.calculateCFGs();
    }

    private void calculateInternalClasses() {
        for (CompilationUnit compUnit : this.requestor.getCompilationUnits()) {
            StructuralVisitor visitor = new StructuralVisitor(this.manager);
            compUnit.accept((ASTVisitor)visitor);
        }
    }

    private void createImpliedUnDeclaredConstructors() {
        Iterator iterator = this.classes.iterator();
        while (((CCDHashMap.QueueIterator)iterator).hasNext()) {
            IClassNode currentClassNode = (IClassNode)((CCDHashMap.QueueIterator)iterator).next().getValue();
            ITypeBinding currentBinding = currentClassNode.getTypeBinding();
            if (currentBinding.isInterface() || currentBinding.isAnnotation()) continue;
            List<MethodNode> currentMethods = this.getMethodNodesOf(currentClassNode);
            boolean hasConstructor = false;
            for (MethodNode x : currentMethods) {
                if (!((MethodDeclaration)x.getASTNode()).isConstructor()) continue;
                hasConstructor = true;
                break;
            }
            if (hasConstructor) continue;
            IMethodBinding constructor = null;
            IMethodBinding[] iMethodBindingArray = currentClassNode.getTypeBinding().getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding x = iMethodBindingArray[n2];
                if (x.isConstructor()) {
                    constructor = x;
                    break;
                }
                ++n2;
            }
            if (constructor == null) {
                throw new AssertionError((Object)"unhandled case: no constructor binding found");
            }
            ASTNode astNode = currentClassNode.getASTNode();
            List<OtherEntry> init = this.manager.getOtherConstructorDeclarations(CCDAST.getKey(currentBinding));
            if (!init.isEmpty()) {
                astNode = init.get(0).getASTNode();
            }
            ImpliedMethodNode m = new ImpliedMethodNode(astNode, CCDAST.getKey(constructor), constructor);
            this.manager.getFoundConstructors().add(m);
            this.manager.addMethodSourceToNode(CCDAST.getKey(constructor), CCDAST.getKey(constructor.getMethodDeclaration().getDeclaringClass()), m);
        }
    }

    private void calculateJIG() {
        CCDHashMap<String, String> globalQualifiedNames = new CCDHashMap<String, String>();
        Iterator iterator = this.classes.iterator();
        while (((CCDHashMap.QueueIterator)iterator).hasNext()) {
            Object elem = ((CCDHashMap.QueueIterator)iterator).next();
            IClassNode currentClassNode = (IClassNode)elem.getValue();
            boolean check = true;
            for (ITypeBinding binding : currentClassNode.getUsedClasses()) {
                boolean bl = check = check && (!this.classes.containsKey(CCDAST.getKey(binding)) || globalQualifiedNames.containsKey(CCDAST.getKey(binding)));
            }
            if (check) {
                this.buildGlobalQualifiedName(globalQualifiedNames, currentClassNode);
                this.workOnSuperClasses(currentClassNode);
                continue;
            }
            ((CCDHashMap.QueueIterator)iterator).enqueue(elem);
        }
    }

    private void workOnSuperClasses(IClassNode currentClassNode) {
        List<MethodNode> currentMethods = this.getMethodNodesOf(currentClassNode);
        ITypeBinding currentClassBinding = currentClassNode.getTypeBinding();
        String currentClassNodeKey = CCDAST.getKey(currentClassBinding);
        for (MethodNode x : currentMethods) {
            this.internalClassMethods.add(currentClassNodeKey, x);
        }
        for (ITypeBinding binding : currentClassNode.getUsedClasses()) {
            MethodNode overridesMethodNode;
            IMethodBinding superMethodBinding;
            IClassNode superClass = (IClassNode)this.classes.get(CCDAST.getKey(binding));
            if (!this.externalClassMethods.containsKey(CCDAST.getKey(binding))) {
                this.calculateExternalMethods(binding);
            }
            for (IMethodBinding superMethodBinding2 : (List)this.externalClassMethods.get(CCDAST.getKey(binding))) {
                Iterator<String> it = this.manager.getSpecialBindingsToFind();
                while (it.hasNext()) {
                    String s = it.next();
                    if (!s.equals(superMethodBinding2.getMethodDeclaration().getKey())) continue;
                    it.remove();
                    this.manager.addSpecialBinding(superMethodBinding2.getMethodDeclaration());
                }
                MethodNode overridesMethodNode2 = this.getOverridesMethodNode(superMethodBinding2, currentMethods);
                if (overridesMethodNode2 == null) continue;
                if (!currentClassNode.isExternalClassNodeLink()) {
                    this.connectToExternalCodeNode(currentClassNode);
                    this.connectToExternalCodeNodeRecursivly(overridesMethodNode2, superClass);
                }
                if (!((MethodDeclaration)overridesMethodNode2.getASTNode()).isConstructor()) {
                    this.manager.addMethodSourceToNode(CCDAST.getKey(superMethodBinding2), overridesMethodNode2.getSourceClassKey(), overridesMethodNode2);
                }
                currentClassNode.addCallDestinationNode(overridesMethodNode2, CCDAST.getKey(overridesMethodNode2.getMethodBinding()));
            }
            if (superClass == null) continue;
            if (superClass.isExternalClassNodeLink() && !currentClassNode.isExternalClassNodeLink()) {
                this.connectToExternalCodeNode(currentClassNode);
            }
            for (IEdge x : superClass.getAllEdges()) {
                if (!(x.getTo() instanceof MethodNode)) continue;
                MethodNode m = (MethodNode)x.getTo();
                superMethodBinding = m.getMethodBinding();
                overridesMethodNode = this.getOverridesMethodNode(superMethodBinding, currentMethods);
                if (overridesMethodNode != null) {
                    if (((MethodDeclaration)overridesMethodNode.getASTNode()).isConstructor()) continue;
                    this.manager.addMethodSourceToNode(CCDAST.getKey(superMethodBinding), overridesMethodNode.getSourceClassKey(), overridesMethodNode);
                    continue;
                }
                currentClassNode.addCallDestinationNode(m, x.getLabel());
            }
            List<MethodNode> superClassMethods = this.internalClassMethods.get(CCDAST.getKey(superClass.getTypeBinding()));
            for (MethodNode m : superClassMethods) {
                superMethodBinding = m.getMethodBinding();
                overridesMethodNode = this.getOverridesMethodNode(superMethodBinding, currentMethods);
                if (!superMethodBinding.isConstructor()) {
                    if (overridesMethodNode != null) {
                        this.manager.addMethodSourceToNode(CCDAST.getKey(superMethodBinding), overridesMethodNode.getSourceClassKey(), overridesMethodNode);
                    } else {
                        this.manager.addMethodSourceToNode(CCDAST.getKey(superMethodBinding), CCDAST.getKey(currentClassBinding), m);
                    }
                }
                this.internalClassMethods.add(currentClassNodeKey, m);
            }
        }
    }

    private void connectToExternalCodeNode(IClassNode currentClassNode) {
        String currentClassSource = CCDAST.getKey(currentClassNode.getTypeBinding());
        ExternalMethodNode m = new ExternalMethodNode(currentClassSource);
        currentClassNode.addCallDestinationNode(m, "*");
        currentClassNode.setExternalClassNodeLink();
        this.getECN().addCallDestinationNode(currentClassNode, currentClassSource);
    }

    private void connectToExternalCodeNodeRecursivly(MethodNode overridesMethodNode, IClassNode currentClassNode) {
        if (currentClassNode == null) {
            return;
        }
        LinkedList<MethodNode> overridesMethodList = new LinkedList<MethodNode>();
        overridesMethodList.add(overridesMethodNode);
        block0: for (ITypeBinding binding : currentClassNode.getUsedClasses()) {
            IClassNode superClass = (IClassNode)this.classes.get(CCDAST.getKey(binding));
            if (superClass != null && superClass.isExternalClassNodeLink()) continue;
            for (IMethodBinding superMethodBinding : (List)this.externalClassMethods.get(CCDAST.getKey(binding))) {
                MethodNode result = this.getOverridesMethodNode(superMethodBinding, overridesMethodList);
                if (result == null) continue;
                if (currentClassNode.isExternalClassNodeLink()) continue block0;
                this.connectToExternalCodeNode(currentClassNode);
                this.connectToExternalCodeNodeRecursivly(overridesMethodNode, superClass);
                continue block0;
            }
        }
    }

    private List<MethodNode> getMethodNodesOf(IClassNode currentClassNode) {
        ITypeBinding binding = currentClassNode.getTypeBinding();
        return this.manager.getDeclMethodsInClass(CCDAST.getKey(binding));
    }

    private MethodNode getOverridesMethodNode(IMethodBinding superMethodBinding, List<MethodNode> currentMethods) {
        for (MethodNode currentMethodNode : currentMethods) {
            IMethodBinding currentMethodBinding = currentMethodNode.getMethodBinding();
            if (superMethodBinding.isConstructor() || superMethodBinding.isDefaultConstructor() || !currentMethodBinding.overrides(superMethodBinding)) continue;
            return currentMethodNode;
        }
        return null;
    }

    private void buildGlobalQualifiedName(CCDHashMap<String, String> globalQualifiedNames, IClassNode currentClassNode) {
        StringBuffer nameBuffer = new StringBuffer();
        String currentClassSource = CCDAST.getKey(currentClassNode.getTypeBinding());
        for (ITypeBinding binding : currentClassNode.getUsedClasses()) {
            if (globalQualifiedNames.containsKey(CCDAST.getKey(binding))) {
                nameBuffer.append(String.valueOf((String)globalQualifiedNames.get(CCDAST.getKey(binding))) + ":");
                continue;
            }
            nameBuffer.append(String.valueOf(CCDAST.getKey(binding)) + ":");
        }
        nameBuffer.append(currentClassSource);
        String name = nameBuffer.toString();
        globalQualifiedNames.put(currentClassSource, name);
        currentClassNode.setGloballyQualifiedClassName(name);
    }

    private void calculateExternalMethods(ITypeBinding binding) {
        ITypeBinding x;
        LinkedList<ITypeBinding> list = new LinkedList<ITypeBinding>();
        ITypeBinding superClass = binding.getSuperclass();
        if (superClass != null) {
            if (!this.externalClassMethods.containsKey(CCDAST.getKey(superClass))) {
                this.calculateExternalMethods(superClass);
            }
            list.addAll((Collection)this.externalClassMethods.get(CCDAST.getKey(superClass)));
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            x = iTypeBindingArray[n2];
            if (!this.externalClassMethods.containsKey(CCDAST.getKey(x))) {
                this.calculateExternalMethods(x);
            }
            list.addAll((Collection)this.externalClassMethods.get(CCDAST.getKey(x)));
            ++n2;
        }
        if (!this.classes.containsKey(CCDAST.getKey(binding))) {
            iTypeBindingArray = binding.getDeclaredMethods();
            n = iTypeBindingArray.length;
            n2 = 0;
            while (n2 < n) {
                x = iTypeBindingArray[n2];
                list.add(x);
                ++n2;
            }
        }
        this.externalClassMethods.put(CCDAST.getKey(binding), list);
    }

    private void calculateCFGs() {
        for (IMethodNode iMethodNode : this.manager.getFoundConstructors()) {
            MethodFlowGraphCreatorVisitor.createConstructor(this, iMethodNode, this.manager);
        }
        for (MethodNode methodNode : this.manager.getFoundMethods()) {
            MethodFlowGraphCreatorVisitor.create(methodNode, this.manager);
            if (!CCDAST.getKey(methodNode.getMethodBinding()).endsWith(".main([Ljava/lang/String;)V")) continue;
            this.mainMethods.add(methodNode);
        }
        for (Map.Entry entry : this.classes) {
            List<StaticNode> classStaticDeclarations = this.manager.getStaticDeclarations((String)entry.getKey());
            if (!classStaticDeclarations.isEmpty()) {
                this.staticInitializers.add(classStaticDeclarations.get(0));
                MethodFlowGraphCreatorVisitor.createStaticDeclaration(classStaticDeclarations, this.manager);
                continue;
            }
            this.staticInitializers.add(new FakeStaticNode(((IClassNode)entry.getValue()).getASTNode(), "static", ((IClassNode)entry.getValue()).getTypeBinding()));
        }
    }

    public IMethodBinding getSuperConstructorMethodBinding(IMethodNode constructor) {
        IMethodBinding constructorBinding = constructor.getMethodBinding();
        ITypeBinding superClass = constructorBinding.getMethodDeclaration().getDeclaringClass().getSuperclass();
        while (superClass != null) {
            IMethodBinding[] iMethodBindingArray = superClass.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding x = iMethodBindingArray[n2];
                if (constructorBinding.overrides(x) || x.isConstructor() && x.getTypeArguments().length == 0) {
                    return x;
                }
                ++n2;
            }
            superClass = superClass.getSuperclass();
        }
        throw new AssertionError((Object)"found no super constructor");
    }

    public ExternalClassNode getECN() {
        return this.ecn;
    }

    public List<IMethodNode> getMainMethods() {
        return this.mainMethods;
    }

    public List<IStaticNode> getStaticInitializers() {
        return this.staticInitializers;
    }

    public List<IMethodNode> getMethod(String methodKey) {
        List<CallEdgeModel> list = this.manager.getMethodSourceToNode(methodKey);
        LinkedList<IMethodNode> methods = new LinkedList<IMethodNode>();
        for (CallEdgeModel x : list) {
            methods.add(x.getMethodNode());
        }
        return methods;
    }

    public MethodPair[] getFoundMethods() {
        if (this.foundMethods != null) {
            return this.foundMethods;
        }
        List<MethodNode> methods = this.manager.getFoundMethods();
        this.foundMethods = new MethodPair[methods.size()];
        int i = 0;
        for (MethodNode x : methods) {
            this.foundMethods[i] = new MethodPair(x);
            ++i;
        }
        return this.foundMethods;
    }

    public static void clean() {
        ANode.resetID();
        CCDAST.resetKeys();
    }

    public List<INode> getNewInstanceStatements(String classKey) {
        return this.manager.getNewInstanceStatements(classKey);
    }
}

