/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig;

import calculateCodeDifference.helper.CCDHashMap;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public final class CCDAST {
    private static CCDHashMap<IBinding, String> anonymBindings = new CCDHashMap();
    private static CCDHashMap<BodyDeclaration, Integer> anonymClasses = new CCDHashMap();

    private CCDAST() {
    }

    public static void putKey(AnonymousClassDeclaration declaration) {
        BodyDeclaration parentBodyDeclaration = CCDAST.findParentBodyDeclaration((ASTNode)declaration);
        IBinding parentBinding = CCDAST.getBinding(parentBodyDeclaration);
        Integer parentCount = (Integer)anonymClasses.get(parentBodyDeclaration);
        if (parentCount == null) {
            parentCount = 1;
        }
        anonymBindings.put((IBinding)declaration.resolveBinding(), String.valueOf(CCDAST.getKey(parentBinding)) + "$" + parentCount);
        anonymClasses.put(parentBodyDeclaration, parentCount + 1);
    }

    public static void putKey(AbstractTypeDeclaration declaration) {
        BodyDeclaration parentBodyDeclaration = CCDAST.findParentBodyDeclaration((ASTNode)declaration);
        IBinding parentBinding = CCDAST.getBinding(parentBodyDeclaration);
        Integer parentCount = (Integer)anonymClasses.get(parentBodyDeclaration);
        if (parentCount == null) {
            parentCount = 1;
        }
        anonymBindings.put((IBinding)declaration.resolveBinding(), String.valueOf(CCDAST.getKey(parentBinding)) + "$" + parentCount + "$" + declaration.getName());
        anonymClasses.put(parentBodyDeclaration, parentCount + 1);
    }

    private static BodyDeclaration findParentBodyDeclaration(ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent != null) {
            if (parent instanceof AbstractTypeDeclaration || parent instanceof MethodDeclaration) {
                return (BodyDeclaration)parent;
            }
            parent = parent.getParent();
        }
        throw new AssertionError((Object)"unhandled case");
    }

    private static IBinding getBinding(BodyDeclaration node) {
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration found = (AbstractTypeDeclaration)node;
            return found.resolveBinding();
        }
        if (node instanceof MethodDeclaration) {
            MethodDeclaration found = (MethodDeclaration)node;
            return found.resolveBinding();
        }
        throw new AssertionError((Object)"unhandled case");
    }

    private static String getKey(IBinding binding) {
        if (binding instanceof ITypeBinding) {
            return CCDAST.getKey((ITypeBinding)binding);
        }
        if (binding instanceof IMethodBinding) {
            return CCDAST.getKey((IMethodBinding)binding);
        }
        throw new AssertionError((Object)"unhandled case");
    }

    public static String getKey(ITypeBinding binding) {
        if ((binding = binding.getErasure()).isAnonymous() || binding.isLocal()) {
            String result = (String)anonymBindings.get(binding);
            if (result == null) {
                throw new AssertionError((Object)"unhandled case");
            }
            return result;
        }
        return binding.getKey();
    }

    public static String getKey(IMethodBinding binding) {
        IMethodBinding declBinding = binding.getMethodDeclaration();
        ITypeBinding typeBinding = declBinding.getDeclaringClass();
        if (typeBinding.isAnonymous() || typeBinding.isLocal()) {
            String result = (String)anonymBindings.get(declBinding);
            if (result == null) {
                String classKey = (String)anonymBindings.get(declBinding.getDeclaringClass());
                String oldKey = declBinding.getKey();
                result = String.valueOf(classKey) + oldKey.substring(oldKey.indexOf(46));
                anonymBindings.put((IBinding)declBinding, result);
            }
            return result;
        }
        return declBinding.getKey();
    }

    public static void resetKeys() {
        anonymBindings.clear();
        anonymClasses.clear();
    }

    public static void sort(List<ITypeBinding> list) {
        int i = 0;
        while (i < list.size()) {
            int min = i;
            int j = i;
            while (j < list.size()) {
                if (CCDAST.getKey(list.get(j)).compareTo(CCDAST.getKey(list.get(min))) < 0) {
                    min = j;
                }
                ++j;
            }
            ITypeBinding temp = list.get(min);
            list.set(min, list.get(i));
            list.set(i, temp);
            ++i;
        }
    }
}

