/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.compareJIG;

import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.jig.graph.node.INode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

class TraversalAlogrithm {
    private List<IEdge> dangerousEdges = new LinkedList<IEdge>();
    private HashMap<INode, Boolean> visitedNode = new HashMap();
    private HashMap<IEdge, Boolean> visitedEdge = new HashMap();

    public void compare(INode startOldNode, INode startNewNode) {
        Stack<NodePair> stack = new Stack<NodePair>();
        stack.push(new NodePair(startOldNode, startNewNode));
        while (!stack.isEmpty()) {
            NodePair current = (NodePair)stack.pop();
            INode newNode = current.newNode;
            INode oldNode = current.oldNode;
            if (this.visitedNode.containsKey(newNode)) continue;
            this.visitedNode.put(newNode, true);
            for (IEdge oldEdge : oldNode.getAllEdges()) {
                IEdge newEdge = this.match(newNode, oldEdge);
                if (newEdge == null) continue;
                INode nextOldNode = oldEdge.getTo();
                INode nextNewNode = newEdge.getTo();
                if (!this.nodeEquivalent(nextNewNode, nextOldNode)) {
                    this.dangerousEdges.add(newEdge);
                    continue;
                }
                if (this.visitedNode.containsKey(nextNewNode)) continue;
                stack.push(new NodePair(nextOldNode, nextNewNode));
            }
            for (IEdge newEdge : newNode.getAllEdges()) {
                if (this.visitedEdge.containsKey(newEdge)) continue;
                this.dangerousEdges.add(newEdge);
            }
        }
    }

    private boolean nodeEquivalent(INode node1, INode node2) {
        return node1.getLabel().equals(node2.getLabel());
    }

    private IEdge match(INode newNode, IEdge oldEdge) {
        IEdge found = null;
        IEdge starEdge = null;
        for (IEdge newEdge : newNode.getAllEdges()) {
            if (newEdge == null) {
                throw new AssertionError((Object)"unhandled case");
            }
            if (newEdge.getLabel().equals("*")) {
                starEdge = newEdge;
            }
            if (!newEdge.getLabel().equals(oldEdge.getLabel())) continue;
            found = newEdge;
            break;
        }
        if (found == null) {
            return starEdge;
        }
        this.visitedEdge.put(found, true);
        return found;
    }

    public List<IEdge> getDangerousEdges() {
        return this.dangerousEdges;
    }

    private final class NodePair {
        private INode newNode;
        private INode oldNode;

        private NodePair(INode oldNode, INode newNode) {
            this.newNode = newNode;
            this.oldNode = oldNode;
        }
    }
}

