/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.compareJIG;

import calculateCodeDifference.helper.CCDHashMapList;
import calculateCodeDifference.helper.exception.InternalFailureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class ModifyJavaFiles {
    private static final String JAVADOC = "@modified";
    private CCDHashMapList<CompilationUnit, BodyDeclaration> mapBodyDeclaration = new CCDHashMapList();
    private CCDHashMapList<CompilationUnit, Block> mapBlock = new CCDHashMapList();
    private boolean disableBlocks = false;

    public void disableBlocks() {
        this.disableBlocks = true;
    }

    public void addNode(ASTNode node) {
        Block state;
        CompilationUnit compUnit = (CompilationUnit)node.getRoot();
        BodyDeclaration bodyDecl = this.findBodyDeclaration(node);
        if (bodyDecl != null) {
            this.mapBodyDeclaration.addOnce(compUnit, bodyDecl);
        }
        if ((state = this.findBlock(node)) != null) {
            this.mapBlock.addOnce(compUnit, state);
        }
    }

    private BodyDeclaration findBodyDeclaration(ASTNode node) {
        while (node.getParent() != null) {
            if (node instanceof BodyDeclaration) {
                return (BodyDeclaration)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private Block findBlock(ASTNode node) {
        while (node.getParent() != null) {
            if (node instanceof Block) {
                return (Block)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public void modifyAll() throws InternalFailureException {
        String modifiedString = "@modified " + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date());
        for (Map.Entry entry : this.mapBodyDeclaration) {
            CompilationUnit cu = (CompilationUnit)entry.getKey();
            AST ast = cu.getAST();
            cu.recordModifications();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            this.addModifiedInJavadoc(modifiedString, (List)entry.getValue(), ast, rewriter);
            if (!this.disableBlocks) {
                this.addModified(modifiedString, this.mapBlock.get(cu), rewriter);
            }
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = null;
            if (cu.getJavaElement() == null) {
                throw new AssertionError((Object)"unsupported operation: modified project has to be internal");
            }
            path = cu.getJavaElement().getPath();
            try {
                try {
                    bufferManager.connect(path, LocationKind.IFILE, null);
                    ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                    IDocument document = textFileBuffer.getDocument();
                    TextEdit textEdit = rewriter.rewriteAST();
                    textEdit.apply(document);
                    textFileBuffer.commit(null, false);
                }
                catch (CoreException | BadLocationException | MalformedTreeException e) {
                    throw new InternalFailureException((Exception)e);
                }
            }
            finally {
                try {
                    bufferManager.disconnect(path, LocationKind.IFILE, null);
                }
                catch (CoreException e) {
                    throw new InternalFailureException((Exception)((Object)e));
                }
            }
        }
        this.mapBlock.clear();
        this.mapBodyDeclaration.clear();
    }

    private void addModified(String modifiedString, List<Block> list, ASTRewrite rewriter) {
        for (Block block : list) {
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
            Statement placeHolder = (Statement)rewriter.createStringPlaceholder("// " + modifiedString, 20);
            listRewrite.insertFirst((ASTNode)placeHolder, null);
        }
    }

    private void addModifiedInJavadoc(String modifiedString, List<BodyDeclaration> list, AST ast, ASTRewrite rewriter) {
        for (BodyDeclaration decl : list) {
            if (decl.getJavadoc() == null) {
                ChildPropertyDescriptor descriptor = decl.getJavadocProperty();
                Javadoc jc = (Javadoc)rewriter.get((ASTNode)decl, (StructuralPropertyDescriptor)descriptor);
                jc = ast.newJavadoc();
                TagElement tag = ast.newTagElement();
                TextElement te = ast.newTextElement();
                tag.fragments().add(te);
                te.setText(modifiedString);
                jc.tags().add(tag);
                rewriter.set((ASTNode)decl, (StructuralPropertyDescriptor)descriptor, (Object)jc, null);
                continue;
            }
            Javadoc jc = decl.getJavadoc();
            TagElement toReplace = null;
            for (TagElement tag : jc.tags()) {
                if (!JAVADOC.equals(tag.getTagName())) continue;
                toReplace = tag;
            }
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)jc, Javadoc.TAGS_PROPERTY);
            TagElement tag = (TagElement)rewriter.createStringPlaceholder(modifiedString, 65);
            if (toReplace != null) {
                listRewrite.remove((ASTNode)toReplace, null);
            }
            listRewrite.insertLast((ASTNode)tag, null);
        }
    }
}

