/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.test.compare;

import calculateCodeDifference.compareJIG.Comparator;
import calculateCodeDifference.helper.exception.InternalFailureException;
import calculateCodeDifference.jig.JavaInterclassGraph;
import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCCDrev121rev124 {
    private static TestHelper tester;
    private static JavaInterclassGraph oldJIG;
    private static JavaInterclassGraph newJIG;
    private static Comparator comparator;

    @BeforeClass
    public static void setUp() throws Exception {
        tester = new TestHelper();
        tester.setUpNewProject("calculateCodeDifferenceRev124");
        tester.setUpOldProject("calculateCodeDifferenceRev121");
        tester.preCompare();
        oldJIG = tester.getOldJIG();
        newJIG = tester.getNewJIG();
        comparator = tester.getComparator();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        oldJIG = null;
        newJIG = null;
        comparator = null;
        tester.tearDown();
    }

    @Test
    public void countFoundMethodsNew() {
        Assert.assertEquals((long)newJIG.getFoundMethods().length, (long)415L);
    }

    @Test
    public void countFoundMethodsOld() {
        Assert.assertEquals((long)oldJIG.getFoundMethods().length, (long)412L);
    }

    @Test
    public void noBigChanges() {
        Assert.assertTrue((boolean)comparator.getBigChanges().isEmpty());
    }

    @Test
    public void noDangerousEdges() {
        try {
            Assert.assertEquals((long)comparator.getDangerousEdges().size(), (long)4L);
        }
        catch (InternalFailureException internalFailureException) {
            Assert.fail((String)"get dangerous edges failed");
        }
    }

    @Test
    public void edge1() {
        boolean found = false;
        try {
            for (IEdge x : comparator.getDangerousEdges()) {
                if (!x.getFrom().getLabel().equals("Ljava/lang/Object;:LcalculateCodeDifference/jig/graph/node/INode;:LcalculateCodeDifference/jig/graph/node/ANode;:LcalculateCodeDifference/jig/graph/node/ANodeOneEdge<TT;>;:LcalculateCodeDifference/jig/graph/node/Node;[node, \"internal_iterator = \" + node.getExpression().toString() + \".iterator()\"]") || !x.getLabel().equals("") || !x.getTo().getLabel().equals("IMethodBinding initBinding=this.manager.getSpecialBindings(\"Ljava/lang/Iterable;.iterator()Ljava/util/Iterator<TT;>;\");")) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        catch (InternalFailureException internalFailureException) {
            Assert.fail((String)"get dangerous edges failed");
        }
    }

    @Test
    public void edge2() {
        boolean found = false;
        try {
            for (IEdge x : comparator.getDangerousEdges()) {
                if (!x.getFrom().getLabel().equals("LcalculateCodeDifference/jig/CCDAST;.getKey(Lorg/eclipse/jdt/core/dom/IMethodBinding;)Ljava/lang/String;") || !x.getLabel().equals("") || !x.getTo().getLabel().equals("IMethodBinding declBinding=binding.getMethodDeclaration();")) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        catch (InternalFailureException internalFailureException) {
            Assert.fail((String)"get dangerous edges failed");
        }
    }

    @Test
    public void edge3() {
        boolean found = false;
        try {
            for (IEdge x : comparator.getDangerousEdges()) {
                if (!x.getFrom().getLabel().equals("IMethodBinding superMethodBinding = internal_iterator.next()") || !x.getLabel().equals("") || !x.getTo().getLabel().equals("Iterator<String> it=this.manager.getSpecialBindingsToFind();")) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        catch (InternalFailureException internalFailureException) {
            Assert.fail((String)"get dangerous edges failed");
        }
    }

    @Test
    public void edge4() {
        boolean found = false;
        try {
            for (IEdge x : comparator.getDangerousEdges()) {
                if (!x.getFrom().getLabel().equals("Ljava/lang/Object;:Ljava/lang/Iterable<TT;>;:LcalculateCodeDifference/helper/CCDHashMapList<TK;TV;>;[]") || !x.getLabel().equals("") || !x.getTo().getLabel().equals("externalBindings=new CCDHashMap<String,IMethodBinding>()")) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        catch (InternalFailureException internalFailureException) {
            Assert.fail((String)"get dangerous edges failed");
        }
    }
}

