/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.test;

import calculateCodeDifference.ast.CCDASTRequestor;
import calculateCodeDifference.ast.ProjectLoader;
import calculateCodeDifference.compareJIG.Comparator;
import calculateCodeDifference.helper.exception.CodeDifferenceException;
import calculateCodeDifference.jig.JavaInterclassGraph;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;

public class TestHelper {
    private static final String ABSOLUTE_PATH = "D:\\Dropbox\\Coding\\Bachelorarbeit\\pluginWorkspace\\calculateCodeDifference\\testProjects\\";
    private JavaInterclassGraph oldJIG;
    private JavaInterclassGraph newJIG;
    private Comparator comparator;
    private ProjectLoader oldProject = new ProjectLoader();
    private ProjectLoader newProject = new ProjectLoader();

    private void waitForJobs() {
        while (!Job.getJobManager().isIdle()) {
            this.delay(1000L);
        }
    }

    private void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setUpNewProject(String projectName) {
        this.newProject.set(ABSOLUTE_PATH + projectName);
    }

    public void setUpOldProject(String projectName) {
        this.oldProject.set(ABSOLUTE_PATH + projectName);
    }

    public void preNewCreateJIG() {
        this.waitForJobs();
        if (this.newProject.isSelected()) {
            try {
                CCDASTRequestor newRequestor = this.newProject.loadProject(null);
                this.newJIG = new JavaInterclassGraph(newRequestor);
                this.newJIG.calculate();
            }
            catch (CodeDifferenceException e) {
                e.printStackTrace();
                Assert.fail((String)"Unexpeceted initialization error while loading projects");
            }
        }
        this.waitForJobs();
    }

    public void preCompare() {
        this.waitForJobs();
        if (this.oldProject.isSelected() && this.newProject.isSelected()) {
            try {
                CCDASTRequestor oldRequestor = this.oldProject.loadProject(null);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Unexpeceted initialization error while sleep");
                }
                CCDASTRequestor newRequestor = this.newProject.loadProject(null);
                this.oldJIG = new JavaInterclassGraph(oldRequestor);
                this.oldJIG.calculate();
                this.newJIG = new JavaInterclassGraph(newRequestor);
                this.newJIG.calculate();
            }
            catch (CodeDifferenceException e) {
                e.printStackTrace();
                Assert.fail((String)"Unexpeceted initialization error while loading projects");
            }
            try {
                this.comparator = new Comparator(this.oldJIG, this.newJIG);
                this.comparator.compare();
            }
            catch (CodeDifferenceException codeDifferenceException) {
                Assert.fail((String)"Unexpeceted initialization error while compareing projects");
            }
        }
        this.waitForJobs();
    }

    public void tearDown() {
        this.newProject.deleteRequestor();
        this.oldProject.deleteRequestor();
        this.newJIG = null;
        this.oldJIG = null;
        JavaInterclassGraph.clean();
        this.comparator = null;
    }

    public JavaInterclassGraph getNewJIG() {
        return this.newJIG;
    }

    public JavaInterclassGraph getOldJIG() {
        return this.oldJIG;
    }

    public Comparator getComparator() {
        return this.comparator;
    }
}

