/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig.graph.node;

import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.jig.graph.edge.NormalEdge;
import calculateCodeDifference.jig.graph.node.ANode;
import calculateCodeDifference.jig.graph.node.INode;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;

abstract class ANodeOneEdge<T extends ASTNode>
extends ANode {
    private T astnode;
    private NormalEdge edge;
    private boolean isDestNodeLocked;

    ANodeOneEdge(T astnode, String label) {
        super(label);
        this.astnode = astnode;
        this.isDestNodeLocked = false;
    }

    public T getASTNode() {
        return this.astnode;
    }

    NormalEdge getEdge() {
        return this.edge;
    }

    void setEdge(NormalEdge edge) {
        this.edge = edge;
    }

    @Override
    public void setDestinationNode(INode node, String label) {
        if (!this.isDestNodeLocked) {
            if (this == node) {
                return;
            }
            if (this.edge != null) {
                this.edge.getTo().setDestinationNode(node, label);
            } else {
                this.edge = new NormalEdge(this, node, label);
                node.saveLastNode(this.edge);
            }
            if (this.getPathEdge() != null) {
                this.getPathEdge().getTo().setDestinationNode(node, label);
            }
        }
    }

    public void lockDestinationNode(boolean activate) {
        this.isDestNodeLocked = activate;
    }

    @Override
    public List<IEdge> getAllEdges() {
        List<IEdge> l = super.getAllEdges();
        l.add(this.edge);
        return l;
    }

    @Override
    public String toString() {
        String result = String.valueOf(super.toString()) + "NEXT->";
        result = this.edge != null ? String.valueOf(result) + this.edge.getTo().getID() : String.valueOf(result) + "null";
        return result;
    }
}

