/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig;

import calculateCodeDifference.jig.CCDAST;
import calculateCodeDifference.jig.LinkManager;
import calculateCodeDifference.jig.graph.node.AnonymousClassNode;
import calculateCodeDifference.jig.graph.node.ClassNode;
import calculateCodeDifference.jig.graph.node.MethodNode;
import calculateCodeDifference.jig.graph.node.StaticNode;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

class StructuralVisitor
extends ASTVisitor {
    private LinkManager manager;

    public StructuralVisitor(LinkManager manager) {
        this.manager = manager;
    }

    private void visit(AbstractTypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding.isLocal()) {
            CCDAST.putKey(node);
        }
        ClassNode classNode = new ClassNode(node, CCDAST.getKey(binding));
        this.manager.putClass(CCDAST.getKey(binding), classNode);
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.visit((AbstractTypeDeclaration)node);
        return super.visit(node);
    }

    public boolean visit(EnumDeclaration node) {
        this.visit((AbstractTypeDeclaration)node);
        return super.visit(node);
    }

    public boolean visit(TypeDeclaration node) {
        this.visit((AbstractTypeDeclaration)node);
        return super.visit(node);
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return super.visit(node);
    }

    public boolean visit(EnumConstantDeclaration node) {
        ITypeBinding classBinding = this.getParentBinding((ASTNode)node);
        this.manager.addStaticDeclaration(CCDAST.getKey(this.getParentBinding((ASTNode)node)), new StaticNode(node, classBinding));
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        boolean isStatic = false;
        List listMod = node.modifiers();
        for (IExtendedModifier x : listMod) {
            if (!x.toString().equals("static")) continue;
            isStatic = true;
            break;
        }
        ITypeBinding classBinding = this.getParentBinding((ASTNode)node);
        if (isStatic) {
            this.manager.addStaticDeclaration(CCDAST.getKey(classBinding), new StaticNode(node, classBinding));
        } else {
            this.manager.addFieldDeclaration(CCDAST.getKey(this.getParentBinding((ASTNode)node)), node);
        }
        List list = node.fragments();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IVariableBinding binding = ((VariableDeclarationFragment)iterator.next()).resolveBinding();
            String source = "Source: " + CCDAST.getKey(binding.getDeclaringClass()) + "." + binding.getName() + " Type: " + CCDAST.getKey(binding.getType());
            this.manager.getVariableDeclaration().put((IBinding)binding, source);
        }
        return super.visit(node);
    }

    public boolean visit(Initializer node) {
        ITypeBinding classBinding = this.getParentBinding((ASTNode)node);
        boolean isStatic = false;
        List listMod = node.modifiers();
        for (IExtendedModifier x : listMod) {
            if (!x.toString().equals("static")) continue;
            isStatic = true;
            break;
        }
        if (isStatic) {
            this.manager.addStaticDeclaration(CCDAST.getKey(classBinding), new StaticNode(node, classBinding));
        } else {
            this.manager.addInitializer(CCDAST.getKey(classBinding), node);
        }
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        String key = CCDAST.getKey(node.resolveBinding());
        ITypeBinding sourceClassBinding = node.resolveBinding().getMethodDeclaration().getDeclaringClass();
        MethodNode methodNode = new MethodNode(node, key);
        this.manager.addDeclMethodsInClass(CCDAST.getKey(sourceClassBinding), methodNode);
        this.manager.addMethodSourceToNode(key, methodNode.getSourceClassKey(), methodNode);
        if (node.isConstructor()) {
            this.manager.getFoundConstructors().add(methodNode);
        } else {
            this.manager.getFoundMethods().add(methodNode);
        }
        return super.visit(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        CCDAST.putKey(node);
        String key = CCDAST.getKey(node.resolveBinding());
        AnonymousClassNode classNode = new AnonymousClassNode(node, key);
        this.manager.putClass(key, classNode);
        return super.visit(node);
    }

    private ITypeBinding getParentBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)parent).resolveBinding();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            return ((AnonymousClassDeclaration)parent).resolveBinding();
        }
        throw new AssertionError((Object)"unhandled parent class type");
    }
}

