/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.jig;

import calculateCodeDifference.helper.CCDHashMap;
import calculateCodeDifference.jig.CCDAST;
import calculateCodeDifference.jig.CallEdgeModel;
import calculateCodeDifference.jig.JavaInterclassGraph;
import calculateCodeDifference.jig.LinkManager;
import calculateCodeDifference.jig.OtherEntry;
import calculateCodeDifference.jig.graph.node.ConditionNode;
import calculateCodeDifference.jig.graph.node.EndNode;
import calculateCodeDifference.jig.graph.node.ExternalMethodNode;
import calculateCodeDifference.jig.graph.node.IMethodNode;
import calculateCodeDifference.jig.graph.node.INode;
import calculateCodeDifference.jig.graph.node.MethodNode;
import calculateCodeDifference.jig.graph.node.Node;
import calculateCodeDifference.jig.graph.node.StaticNode;
import calculateCodeDifference.jig.graph.node.TempNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

class MethodFlowGraphCreatorVisitor
extends ASTVisitor {
    private INode lastNode;
    private INode returnNode;
    private INode catchNode = null;
    private SimpleName lastLabel = null;
    private List<Label> labledLoopSwitch = new ArrayList<Label>();
    private List<Label> labledStatement = new ArrayList<Label>();
    private List<TempNode> toDelete = new Stack<TempNode>();
    private Stack<Object> save = new Stack();
    private LinkManager manager;
    private CCDHashMap<IBinding, String> variableDeclaration;

    private MethodFlowGraphCreatorVisitor(INode lastNode, INode returnNode, LinkManager manager) {
        this.lastNode = lastNode;
        this.returnNode = returnNode;
        this.manager = manager;
        this.variableDeclaration = manager.getVariableDeclaration();
    }

    public static void create(MethodNode starter, LinkManager manager) {
        EndNode returnNode = new EndNode("normal");
        if (starter.getBody() != null) {
            MethodFlowGraphCreatorVisitor visitor = new MethodFlowGraphCreatorVisitor(starter, returnNode, manager);
            starter.getBody().accept((ASTVisitor)visitor);
            visitor.lastNode.setDestinationNode(returnNode, "");
            for (TempNode x : visitor.toDelete) {
                x.deleteNode();
            }
        } else {
            starter.setDestinationNode(returnNode, "");
        }
    }

    private static void createFinally(ASTNode finallyBody, TempNode finallyNode, INode returnNode, INode catchNode, List<Label> labledNodes, List<TempNode> toDelete, LinkManager manager) {
        if (finallyBody != null) {
            MethodFlowGraphCreatorVisitor visitor = new MethodFlowGraphCreatorVisitor(finallyNode, returnNode, manager);
            visitor.catchNode = catchNode;
            visitor.labledLoopSwitch = labledNodes;
            visitor.toDelete = toDelete;
            finallyBody.accept((ASTVisitor)visitor);
            visitor.lastNode.setDestinationNode(returnNode, "");
        } else {
            finallyNode.setDestinationNode(returnNode, "");
        }
    }

    public static void createConstructor(JavaInterclassGraph jig, IMethodNode constructor, LinkManager manager) {
        MethodFlowGraphCreatorVisitor visitor;
        Block block;
        ITypeBinding classBinding = constructor.getMethodBinding().getMethodDeclaration().getDeclaringClass();
        INode lastNode = constructor;
        INode catchNode = null;
        EndNode returnNode = new EndNode("normal");
        List<TempNode> toDelete = new Stack<TempNode>();
        boolean hasSuperInvocation = false;
        boolean hasThisInvoaction = false;
        boolean createManualSuper = false;
        if (constructor.getBody() != null && constructor.getBody() instanceof Block && !(block = (Block)constructor.getBody()).statements().isEmpty()) {
            ASTNode first = (ASTNode)block.statements().get(0);
            if (first instanceof SuperConstructorInvocation) {
                hasSuperInvocation = true;
                Object visitor2 = new MethodFlowGraphCreatorVisitor(lastNode, returnNode, manager);
                ((MethodFlowGraphCreatorVisitor)((Object)visitor2)).toDelete = toDelete;
                first.accept(visitor2);
                catchNode = ((MethodFlowGraphCreatorVisitor)((Object)visitor2)).catchNode;
                lastNode = ((MethodFlowGraphCreatorVisitor)((Object)visitor2)).lastNode;
                toDelete = ((MethodFlowGraphCreatorVisitor)((Object)visitor2)).toDelete;
            } else if (first instanceof ConstructorInvocation) {
                hasThisInvoaction = true;
            } else if (!classBinding.isEnum()) {
                createManualSuper = true;
            }
        }
        if (constructor.getBody() == null || createManualSuper) {
            Node node = new Node(constructor.getASTNode(), "super();");
            lastNode.setDestinationNode(node, "");
            lastNode = node;
            IMethodBinding binding = jig.getSuperConstructorMethodBinding(constructor);
            MethodFlowGraphCreatorVisitor.connectMethodCallEdges(lastNode, constructor.getASTNode(), binding, manager);
        }
        if (!hasThisInvoaction) {
            List<OtherEntry> otherEntry = manager.getOtherConstructorDeclarations(CCDAST.getKey(classBinding));
            for (OtherEntry x : otherEntry) {
                ASTNode node = x.getASTNode();
                visitor = new MethodFlowGraphCreatorVisitor(lastNode, returnNode, manager);
                visitor.catchNode = catchNode;
                visitor.toDelete = toDelete;
                node.accept((ASTVisitor)visitor);
                catchNode = visitor.catchNode;
                lastNode = visitor.lastNode;
                toDelete = visitor.toDelete;
            }
        }
        if (constructor.getBody() != null && constructor.getBody() instanceof Block && !(block = (Block)constructor.getBody()).statements().isEmpty()) {
            List list = block.statements();
            for (ASTNode x : list) {
                if (hasSuperInvocation) {
                    hasSuperInvocation = false;
                    continue;
                }
                visitor = new MethodFlowGraphCreatorVisitor(lastNode, returnNode, manager);
                visitor.catchNode = catchNode;
                visitor.toDelete = toDelete;
                x.accept((ASTVisitor)visitor);
                catchNode = visitor.catchNode;
                lastNode = visitor.lastNode;
                toDelete = visitor.toDelete;
            }
        }
        lastNode.setDestinationNode(returnNode, "");
        for (TempNode x : toDelete) {
            x.deleteNode();
        }
    }

    public static void createStaticDeclaration(List<StaticNode> staticDeclarationList, LinkManager manager) {
        if (staticDeclarationList.isEmpty()) {
            throw new AssertionError((Object)"unhandled case: empty initializerList");
        }
        INode lastNode = null;
        INode catchNode = null;
        EndNode returnNode = new EndNode("normal");
        List<TempNode> toDelete = new Stack<TempNode>();
        for (StaticNode staticNode : staticDeclarationList) {
            if (lastNode != null) {
                lastNode.setDestinationNode(staticNode, "");
            }
            lastNode = staticNode;
            ASTNode node = staticNode.getASTNode();
            MethodFlowGraphCreatorVisitor visitor = new MethodFlowGraphCreatorVisitor(lastNode, returnNode, manager);
            visitor.catchNode = catchNode;
            visitor.toDelete = toDelete;
            node.accept((ASTVisitor)visitor);
            catchNode = visitor.catchNode;
            lastNode = visitor.lastNode;
            toDelete = visitor.toDelete;
        }
        lastNode.setDestinationNode(returnNode, "");
        for (TempNode tempNode : toDelete) {
            tempNode.deleteNode();
        }
    }

    public void preVisit(ASTNode node) {
        WhileStatement whileNode;
        SwitchStatement switchNode;
        EnhancedForStatement forNode;
        DoStatement doNode;
        ASTNode parent = node.getParent();
        if (parent instanceof IfStatement) {
            IfStatement ifNode = (IfStatement)parent;
            if (node.equals((Object)ifNode.getThenStatement())) {
                this.preThenVisit(ifNode);
            } else if (node.equals((Object)ifNode.getElseStatement())) {
                this.preElseVisit(ifNode);
            }
        }
        if (parent instanceof DoStatement && node.equals((Object)(doNode = (DoStatement)parent).getExpression())) {
            this.preExpressionVisit(doNode);
        }
        if (parent instanceof EnhancedForStatement && node.equals((Object)(forNode = (EnhancedForStatement)parent).getBody())) {
            this.preBodyVisit(forNode);
        }
        if (parent instanceof ForStatement) {
            forNode = (ForStatement)parent;
            if (forNode.initializers().size() > 0 && node.equals(forNode.initializers().get(0))) {
                this.preInitializersVisit((ForStatement)forNode);
            } else if (node.equals((Object)forNode.getExpression())) {
                this.preExpressionVisit((ForStatement)forNode);
            } else if (forNode.updaters().size() > 0 && node.equals(forNode.updaters().get(0))) {
                this.preUpdatersVisit((ForStatement)forNode);
            } else if (node.equals((Object)forNode.getBody())) {
                this.preBodyVisit((ForStatement)forNode);
            }
        }
        if (parent instanceof SwitchStatement && ((switchNode = (SwitchStatement)parent).statements().size() == 0 || node.equals(switchNode.statements().get(0)))) {
            this.preBodyVisit(switchNode);
        }
        if (parent instanceof WhileStatement && node.equals((Object)(whileNode = (WhileStatement)parent).getBody())) {
            this.preBodyVisit(whileNode);
        }
        if (parent instanceof TryStatement) {
            TryStatement tryNode = (TryStatement)parent;
            if (node.equals((Object)tryNode.getBody())) {
                this.preBodyVisit(tryNode);
            } else if (node.equals((Object)tryNode.getFinally())) {
                this.preFinallyVisit(tryNode);
            }
        }
    }

    public void postVisit(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forNode = (ForStatement)parent;
            List initializers = forNode.initializers();
            if (node.equals((Object)forNode.getExpression())) {
                this.postExpressionVisit(forNode);
            } else if (forNode.updaters().size() > 0 && node.equals(forNode.updaters().get(0))) {
                this.postUpdatersVisit(forNode);
            } else if (initializers.size() > 0 && node.equals(initializers.get(initializers.size() - 1))) {
                this.postInitializerVisit(forNode);
            }
        }
        if (parent instanceof TryStatement) {
            TryStatement tryNode = (TryStatement)parent;
            List catchClauses = tryNode.catchClauses();
            if (node.equals((Object)tryNode.getBody())) {
                this.postBodyVisit(tryNode);
            } else if (catchClauses.size() > 0 && node.equals(catchClauses.get(catchClauses.size() - 1))) {
                this.postCatchVisit(tryNode);
            } else if (node.equals((Object)tryNode.getFinally())) {
                this.postFinallyVisit(tryNode);
            }
        }
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        return false;
    }

    public boolean visit(EnumConstantDeclaration node) {
        return super.visit(node);
    }

    public void endVisit(EnumConstantDeclaration node) {
        this.createAndConnectNewNode((ASTNode)node, node.getName() + node.arguments().toString(), "");
        IMethodBinding binding = node.resolveConstructorBinding();
        List<CallEdgeModel> possibleMethods = this.manager.getMethodSourceToNode(CCDAST.getKey(binding));
        if (possibleMethods.isEmpty()) {
            throw new AssertionError((Object)"unhandled case");
        }
        for (CallEdgeModel m : possibleMethods) {
            this.lastNode.addCallDestinationNode(m.getMethodNode(), m.getLabel());
        }
        super.endVisit(node);
    }

    public boolean visit(TypeDeclaration node) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(AssertStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        return super.visit(node);
    }

    public void endVisit(AssertStatement node) {
    }

    public boolean visit(Block node) {
        return super.visit(node);
    }

    public void endVisit(Block node) {
    }

    public boolean visit(BreakStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        INode breakDest = this.searchLabeledNode(node.getLabel(), DestType.BREAK);
        this.lastNode.setDestinationNode(breakDest, "");
        return super.visit(node);
    }

    public void endVisit(BreakStatement node) {
    }

    public boolean visit(ConstructorInvocation node) {
        return super.visit(node);
    }

    public void endVisit(ConstructorInvocation node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        IMethodBinding binding = node.resolveConstructorBinding();
        MethodFlowGraphCreatorVisitor.connectMethodCallEdges(this.lastNode, (ASTNode)node, binding, this.manager);
    }

    public boolean visit(ContinueStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        INode continueDest = this.searchLabeledNode(node.getLabel(), DestType.CONTINUE);
        this.lastNode.setDestinationNode(continueDest, "");
        return super.visit(node);
    }

    public void endVisit(ContinueStatement node) {
    }

    public boolean visit(DoStatement node) {
        Label labelBreak = this.createNewTempNodeWithLabel((ASTNode)node, "break " + this.lastLabel, DestType.BREAK);
        Label labelContinue = this.createNewTempNodeWithLabel((ASTNode)node, "continue " + this.lastLabel, DestType.CONTINUE);
        this.lastLabel = null;
        TempNode tempState = new TempNode((ASTNode)node, "do");
        this.lastNode.setDestinationNode(tempState, "");
        this.lastNode = tempState;
        this.save.push(tempState);
        this.save.push(labelBreak);
        this.save.push(labelContinue);
        return super.visit(node);
    }

    private void preExpressionVisit(DoStatement node) {
        TempNode doHelper = new TempNode((ASTNode)node, "do expr start");
        this.connectAndSetLastNode(doHelper, "");
        this.save.push(doHelper);
    }

    public void endVisit(DoStatement node) {
        TempNode doHelper = (TempNode)this.save.pop();
        Label labelContinue = (Label)this.save.pop();
        Label labelBreak = (Label)this.save.pop();
        TempNode tempState = (TempNode)this.save.pop();
        ConditionNode condState = new ConditionNode((ASTNode)node, node.getExpression().toString());
        this.connectAndSetLastNode(condState, "");
        condState.setBranch(ConditionNode.BranchType.TRUE);
        condState.setDestinationNode(tempState, "");
        condState.setBranch(ConditionNode.BranchType.FALSE);
        tempState.deleteNode();
        labelBreak.node.lockDestinationNode(false);
        this.connectAndSetLastNode(labelBreak.node, "");
        labelContinue.node.lockDestinationNode(false);
        labelContinue.node.setDestinationNode(doHelper, "");
        this.deleteLabelNode(labelBreak);
        this.deleteLabelNode(labelContinue);
    }

    public boolean visit(EmptyStatement node) {
        return super.visit(node);
    }

    public void endVisit(EmptyStatement node) {
    }

    public boolean visit(EnhancedForStatement node) {
        return super.visit(node);
    }

    private void preBodyVisit(EnhancedForStatement node) {
        Label labelBreak = this.createNewTempNodeWithLabel((ASTNode)node, "break " + this.lastLabel, DestType.BREAK);
        Label labelContinue = this.createNewTempNodeWithLabel((ASTNode)node, "continue " + this.lastLabel, DestType.CONTINUE);
        this.lastLabel = null;
        Node initNode = new Node((ASTNode)node, "internal_iterator = " + node.getExpression().toString() + ".iterator()");
        IMethodBinding initBinding = this.manager.getSpecialBindings("Ljava/lang/Iterable;.iterator()Ljava/util/Iterator<TT;>;");
        if (initBinding != null) {
            MethodFlowGraphCreatorVisitor.connectMethodCallEdges(initNode, (ASTNode)node, initBinding, this.manager);
        }
        this.connectAndSetLastNode(initNode, "");
        ConditionNode condState = new ConditionNode((ASTNode)node, "internal_iterator.hasNext()");
        this.connectAndSetLastNode(condState, "");
        condState.setBranch(ConditionNode.BranchType.TRUE);
        IMethodBinding hasNextBinding = this.manager.getSpecialBindings("Ljava/util/Iterator;.hasNext()Z");
        if (hasNextBinding != null) {
            MethodFlowGraphCreatorVisitor.connectMethodCallEdges(condState, (ASTNode)node, hasNextBinding, this.manager);
        }
        this.createAndConnectNewNode((ASTNode)node, String.valueOf(node.getParameter().toString()) + " = internal_iterator.next()", "");
        IMethodBinding nextBinding = this.manager.getSpecialBindings("Ljava/util/Iterator;.next()TE;");
        if (nextBinding != null) {
            MethodFlowGraphCreatorVisitor.connectMethodCallEdges(this.lastNode, (ASTNode)node, nextBinding, this.manager);
        }
        this.save.push(condState);
        this.save.push(labelBreak);
        this.save.push(labelContinue);
    }

    public void endVisit(EnhancedForStatement node) {
        Label labelContinue = (Label)this.save.pop();
        Label labelBreak = (Label)this.save.pop();
        ConditionNode condState = (ConditionNode)this.save.pop();
        this.connectAndSetLastNode(condState, "");
        condState.setBranch(ConditionNode.BranchType.FALSE);
        labelBreak.node.lockDestinationNode(false);
        this.connectAndSetLastNode(labelBreak.node, "");
        labelContinue.node.lockDestinationNode(false);
        labelContinue.node.setDestinationNode(condState, "");
        this.deleteLabelNode(labelBreak);
        this.deleteLabelNode(labelContinue);
    }

    public boolean visit(ExpressionStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        return super.visit(node);
    }

    public void endVisit(ExpressionStatement node) {
    }

    public boolean visit(ForStatement node) {
        ForHelper helper = new ForHelper();
        helper.forHelperExpr = new TempNode((ASTNode)node, "for expr start");
        helper.forHelperUpd = new TempNode((ASTNode)node, "for upd start");
        helper.lastNodeExpr = this.lastNode;
        this.save.push(helper);
        return super.visit(node);
    }

    private void preInitializersVisit(ForStatement forNode) {
        ForHelper helper = (ForHelper)this.save.pop();
        Node initNode = new Node((ASTNode)forNode, forNode.initializers().toString());
        this.connectAndSetLastNode(initNode, "");
        this.save.push(helper);
    }

    private void postInitializerVisit(ForStatement node) {
        ForHelper helper = (ForHelper)this.save.pop();
        helper.lastNodeExpr = this.lastNode;
        this.save.push(helper);
    }

    private void preExpressionVisit(ForStatement node) {
        ForHelper helper = (ForHelper)this.save.pop();
        this.connectAndSetLastNode(helper.forHelperExpr, "");
        this.save.push(helper);
    }

    private void postExpressionVisit(ForStatement node) {
        ForHelper helper = (ForHelper)this.save.pop();
        helper.lastNodeExpr = this.lastNode;
        this.save.push(helper);
    }

    private void preUpdatersVisit(ForStatement node) {
        ForHelper helper = (ForHelper)this.save.pop();
        this.lastNode = helper.forHelperUpd;
        Node updNode = new Node((ASTNode)node, node.updaters().toString());
        this.connectAndSetLastNode(updNode, "");
        this.save.push(helper);
    }

    private void postUpdatersVisit(ForStatement node) {
        ForHelper helper = (ForHelper)this.save.pop();
        this.connectAndSetLastNode(helper.forHelperExpr, "");
        this.save.push(helper);
    }

    private void preBodyVisit(ForStatement node) {
        String condStateLabel;
        ForHelper helper = (ForHelper)this.save.pop();
        if (node.getExpression() == null) {
            this.lastNode = helper.lastNodeExpr;
            this.connectAndSetLastNode(helper.forHelperExpr, "");
            helper.lastNodeExpr = helper.forHelperExpr;
            condStateLabel = "";
        } else {
            condStateLabel = node.getExpression().toString();
        }
        if (node.updaters().size() == 0) {
            this.lastNode = helper.forHelperUpd;
            this.connectAndSetLastNode(helper.forHelperExpr, "");
        }
        helper.labelBreak = this.createNewTempNodeWithLabel((ASTNode)node, "break " + this.lastLabel, DestType.BREAK);
        helper.labelContinue = this.createNewTempNodeWithLabel((ASTNode)node, "continue " + this.lastLabel, DestType.CONTINUE);
        this.lastLabel = null;
        this.lastNode = helper.lastNodeExpr;
        helper.condState = new ConditionNode((ASTNode)node, condStateLabel);
        this.connectAndSetLastNode(helper.condState, "");
        helper.condState.setBranch(ConditionNode.BranchType.TRUE);
        this.save.push(helper);
    }

    public void endVisit(ForStatement node) {
        ForHelper helper = (ForHelper)this.save.pop();
        this.connectAndSetLastNode(helper.forHelperUpd, "");
        helper.condState.setBranch(ConditionNode.BranchType.FALSE);
        helper.labelBreak.node.lockDestinationNode(false);
        this.connectAndSetLastNode(helper.labelBreak.node, "");
        helper.labelContinue.node.lockDestinationNode(false);
        helper.labelContinue.node.setDestinationNode(helper.forHelperUpd, "");
        this.deleteLabelNode(helper.labelBreak);
        this.deleteLabelNode(helper.labelContinue);
        this.toDelete.add(helper.forHelperUpd);
        this.toDelete.add(helper.forHelperExpr);
    }

    public boolean visit(IfStatement node) {
        return super.visit(node);
    }

    private void preThenVisit(IfStatement node) {
        ConditionNode condNode = new ConditionNode((ASTNode)node, node.getExpression().toString());
        this.connectAndSetLastNode(condNode, "");
        condNode.setBranch(ConditionNode.BranchType.TRUE);
        this.save.push(condNode);
    }

    private void preElseVisit(IfStatement node) {
        ConditionNode condNode = (ConditionNode)this.save.peek();
        this.lastNode = condNode;
        condNode.setBranch(ConditionNode.BranchType.FALSE);
    }

    public void endVisit(IfStatement node) {
        ConditionNode condNode = (ConditionNode)this.save.pop();
        this.lastNode = condNode;
        condNode.setBranch(ConditionNode.BranchType.BOTH);
    }

    public boolean visit(LabeledStatement node) {
        this.createAndConnectNewNode((ASTNode)node, String.valueOf(node.getLabel().getIdentifier()) + ":", "");
        this.lastLabel = node.getLabel();
        Label labelBreak = this.createNewTempNodeWithStatementLabel((ASTNode)node, "statement label");
        if (!(node.getBody() instanceof DoStatement || node.getBody() instanceof ForStatement || node.getBody() instanceof EnhancedForStatement || node.getBody() instanceof WhileStatement || node.getBody() instanceof SwitchStatement)) {
            this.lastLabel = null;
        }
        this.save.push(labelBreak);
        return super.visit(node);
    }

    public void endVisit(LabeledStatement node) {
        Label labelBreak = (Label)this.save.pop();
        labelBreak.node.lockDestinationNode(false);
        this.connectAndSetLastNode(labelBreak.node, "");
        this.deleteLabelNode(labelBreak);
    }

    public boolean visit(ReturnStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        return super.visit(node);
    }

    public void endVisit(ReturnStatement node) {
        this.lastNode.setDestinationNode(this.returnNode, "");
    }

    public boolean visit(SuperConstructorInvocation node) {
        return super.visit(node);
    }

    public void endVisit(SuperConstructorInvocation node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        IMethodBinding binding = node.resolveConstructorBinding();
        MethodFlowGraphCreatorVisitor.connectMethodCallEdges(this.lastNode, (ASTNode)node, binding, this.manager);
        String classKey = CCDAST.getKey(binding.getMethodDeclaration().getDeclaringClass());
        this.manager.addNewInstanceStatement(classKey, this.lastNode);
    }

    public boolean visit(SwitchCase node) {
        if (this.save.peek() == node.getParent()) {
            this.save.pop();
            ConditionNode lastCase = new ConditionNode((ASTNode)node, node.toString());
            this.connectAndSetLastNode(lastCase, "");
            lastCase.setBranch(ConditionNode.BranchType.TRUE);
            this.save.push(lastCase);
        } else {
            ConditionNode lastCase = (ConditionNode)this.save.pop();
            SwitchStatement parent = (SwitchStatement)node.getParent();
            TempNode nodeCase = new TempNode((ASTNode)node, "case");
            this.toDelete.add(nodeCase);
            this.connectAndSetLastNode(nodeCase, "");
            ConditionNode newCase = new ConditionNode((ASTNode)node, node.toString());
            lastCase.setBranch(ConditionNode.BranchType.FALSE);
            lastCase.setDestinationNode(newCase, "");
            lastCase.setBranch(ConditionNode.BranchType.BOTH);
            if (this.isLastCase(parent, node) && node.isDefault()) {
                newCase.setBranch(ConditionNode.BranchType.BOTH);
            } else {
                newCase.setBranch(ConditionNode.BranchType.TRUE);
            }
            newCase.setDestinationNode(nodeCase, "");
            this.save.push(newCase);
        }
        return super.visit(node);
    }

    private boolean isLastCase(SwitchStatement parent, SwitchCase lastCase) {
        List statements = parent.statements();
        int i = statements.size() - 1;
        while (i >= 0) {
            Statement statement = (Statement)statements.get(i);
            if (statement == lastCase) {
                return true;
            }
            if (statement instanceof SwitchCase) {
                return false;
            }
            --i;
        }
        return false;
    }

    public void endVisit(SwitchCase node) {
    }

    public boolean visit(SwitchStatement node) {
        return super.visit(node);
    }

    private void preBodyVisit(SwitchStatement node) {
        Label labelBreak = this.createNewTempNodeWithLabel((ASTNode)node, "break " + this.lastLabel, DestType.BREAK);
        this.lastLabel = null;
        this.createAndConnectNewNode((ASTNode)node, node.getExpression().toString(), "");
        this.save.push(labelBreak);
        this.save.push(node);
    }

    public void endVisit(SwitchStatement node) {
        ConditionNode lastCase = null;
        Label labelBreak = null;
        if (node == this.save.peek()) {
            this.save.pop();
            labelBreak = (Label)this.save.pop();
        } else {
            lastCase = (ConditionNode)this.save.pop();
            labelBreak = (Label)this.save.pop();
            if (!((SwitchCase)lastCase.getASTNode()).isDefault()) {
                lastCase.setBranch(ConditionNode.BranchType.FALSE);
                lastCase.setDestinationNode(labelBreak.node, "");
            }
            lastCase.setBranch(ConditionNode.BranchType.BOTH);
        }
        labelBreak.node.lockDestinationNode(false);
        this.connectAndSetLastNode(labelBreak.node, "");
        this.deleteLabelNode(labelBreak);
    }

    public boolean visit(SynchronizedStatement node) {
        return super.visit(node);
    }

    public void endVisit(SynchronizedStatement node) {
    }

    public boolean visit(ThrowStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        return super.visit(node);
    }

    public void endVisit(ThrowStatement node) {
        this.lastNode.setDestinationNode(this.getCatchNode(), "");
    }

    public boolean visit(TryStatement node) {
        TryHelper h = new TryHelper();
        h.normalFinallyNode = new TempNode((ASTNode)node.getFinally(), "normal finally");
        h.normalFinallyNode.lockDestinationNode(true);
        h.exceptionFinallyNode = new TempNode((ASTNode)node.getFinally(), "exceptional finally");
        h.exceptionFinallyNode.lockDestinationNode(true);
        h.returnFinallyNode = new TempNode((ASTNode)node.getFinally(), "return finally");
        h.returnFinallyNode.lockDestinationNode(true);
        h.tempCatchNode = new TempNode(null, "temp catch node");
        h.tempCatchNode.lockDestinationNode(true);
        this.toDelete.add(h.tempCatchNode);
        h.tryNode = new TempNode((ASTNode)node.getBody(), "try");
        this.connectAndSetLastNode(h.tryNode, "");
        h.currentCatchNode = this.catchNode;
        h.newCatchNode = null;
        h.lastCatchNode = null;
        this.save.push(h);
        return super.visit(node);
    }

    private void preBodyVisit(TryStatement node) {
        TryHelper h = (TryHelper)this.save.pop();
        h.currentEndNode = this.returnNode;
        this.catchNode = h.tempCatchNode;
        if (node.getFinally() != null) {
            this.returnNode = h.returnFinallyNode;
        }
        this.save.push(h);
    }

    private void postBodyVisit(TryStatement node) {
        TryHelper h = (TryHelper)this.save.pop();
        this.connectAndSetLastNode(h.normalFinallyNode, "");
        this.catchNode = h.exceptionFinallyNode;
        this.returnNode = h.returnFinallyNode;
        this.save.push(h);
    }

    public boolean visit(CatchClause node) {
        TryHelper h = (TryHelper)this.save.pop();
        h.catchNode = new TempNode((ASTNode)node, "catch: " + node.getException().getType());
        if (h.lastCatchNode != null) {
            h.lastCatchNode.addPathDestinationNode(this.catchNode, "exception");
        }
        if (h.newCatchNode == null) {
            h.newCatchNode = h.catchNode;
        }
        this.lastNode = h.catchNode;
        this.save.push(h);
        return super.visit(node);
    }

    public void endVisit(CatchClause node) {
        TryHelper h = (TryHelper)this.save.pop();
        this.lastNode.setDestinationNode(h.normalFinallyNode, "");
        h.lastCatchNode = h.catchNode;
        this.save.push(h);
        super.endVisit(node);
    }

    private void postCatchVisit(TryStatement node) {
        TryHelper h = (TryHelper)this.save.pop();
        if (h.newCatchNode != null) {
            h.lastCatchNode.addPathDestinationNode(h.exceptionFinallyNode, "exception");
            this.catchNode = h.newCatchNode;
        } else {
            this.catchNode = h.exceptionFinallyNode;
        }
        h.tempCatchNode.lockDestinationNode(false);
        h.tempCatchNode.setDestinationNode(this.catchNode, "");
        h.tryNode.addPathDestinationNode(this.catchNode, "exception");
        this.save.push(h);
    }

    private void preFinallyVisit(TryStatement node) {
        if (this.save.empty()) {
            return;
        }
        if (node.catchClauses().isEmpty()) {
            this.postCatchVisit(node);
        }
        TryHelper h = (TryHelper)this.save.pop();
        this.catchNode = h.currentCatchNode;
        this.returnNode = h.currentEndNode;
        this.lastNode = h.normalFinallyNode;
        h.normalFinallyNode.lockDestinationNode(false);
        this.save.push(h);
    }

    private void postFinallyVisit(TryStatement node) {
    }

    public void endVisit(TryStatement node) {
        if (node.getFinally() == null && node.catchClauses().isEmpty()) {
            this.postCatchVisit(node);
        }
        TryHelper h = (TryHelper)this.save.pop();
        if (node.getFinally() == null) {
            this.catchNode = h.currentCatchNode;
            this.returnNode = h.currentEndNode;
            this.lastNode = h.normalFinallyNode;
            h.normalFinallyNode.lockDestinationNode(false);
        }
        if (h.exceptionFinallyNode.hasIncomingEdges()) {
            h.exceptionFinallyNode.lockDestinationNode(false);
            MethodFlowGraphCreatorVisitor.createFinally((ASTNode)node.getFinally(), h.exceptionFinallyNode, this.getCatchNode(), this.getCatchNode(), this.labledLoopSwitch, this.toDelete, this.manager);
        } else {
            h.exceptionFinallyNode.deleteNode();
        }
        if (h.returnFinallyNode.hasIncomingEdges()) {
            h.returnFinallyNode.lockDestinationNode(false);
            MethodFlowGraphCreatorVisitor.createFinally((ASTNode)node.getFinally(), h.returnFinallyNode, this.returnNode, this.getCatchNode(), this.labledLoopSwitch, this.toDelete, this.manager);
        } else {
            h.returnFinallyNode.deleteNode();
        }
    }

    public boolean visit(TypeDeclarationStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        return super.visit(node);
    }

    public void endVisit(TypeDeclarationStatement node) {
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        return super.visit(node);
    }

    public void endVisit(VariableDeclarationStatement node) {
    }

    public boolean visit(WhileStatement node) {
        TempNode whileHelperExpr = new TempNode((ASTNode)node, "while expr start");
        this.connectAndSetLastNode(whileHelperExpr, "");
        this.save.push(whileHelperExpr);
        return super.visit(node);
    }

    private void preBodyVisit(WhileStatement node) {
        Label labelBreak = this.createNewTempNodeWithLabel((ASTNode)node, "break " + this.lastLabel, DestType.BREAK);
        Label labelContinue = this.createNewTempNodeWithLabel((ASTNode)node, "continue " + this.lastLabel, DestType.CONTINUE);
        this.lastLabel = null;
        ConditionNode condState = new ConditionNode((ASTNode)node, node.getExpression().toString());
        this.connectAndSetLastNode(condState, "");
        condState.setBranch(ConditionNode.BranchType.TRUE);
        this.save.push(labelBreak);
        this.save.push(labelContinue);
        this.save.push(condState);
    }

    public void endVisit(WhileStatement node) {
        ConditionNode condState = (ConditionNode)this.save.pop();
        Label labelContinue = (Label)this.save.pop();
        Label labelBreak = (Label)this.save.pop();
        TempNode whileHelperExpr = (TempNode)this.save.pop();
        this.connectAndSetLastNode(whileHelperExpr, "");
        condState.setBranch(ConditionNode.BranchType.FALSE);
        labelBreak.node.lockDestinationNode(false);
        this.connectAndSetLastNode(labelBreak.node, "");
        labelContinue.node.lockDestinationNode(false);
        labelContinue.node.setDestinationNode(whileHelperExpr, "");
        this.deleteLabelNode(labelBreak);
        this.deleteLabelNode(labelContinue);
        this.toDelete.add(whileHelperExpr);
    }

    public boolean visit(MarkerAnnotation node) {
        return super.visit(node);
    }

    public void endVisit(MarkerAnnotation node) {
    }

    public boolean visit(NormalAnnotation node) {
        return super.visit(node);
    }

    public void endVisit(NormalAnnotation node) {
    }

    public boolean visit(SingleMemberAnnotation node) {
        return super.visit(node);
    }

    public void endVisit(SingleMemberAnnotation node) {
    }

    public boolean visit(ArrayAccess node) {
        return super.visit(node);
    }

    public void endVisit(ArrayAccess node) {
    }

    public boolean visit(ArrayCreation node) {
        return super.visit(node);
    }

    public void endVisit(ArrayCreation node) {
    }

    public boolean visit(ArrayInitializer node) {
        return super.visit(node);
    }

    public void endVisit(ArrayInitializer node) {
    }

    public boolean visit(Assignment node) {
        return super.visit(node);
    }

    public void endVisit(Assignment node) {
    }

    public boolean visit(BooleanLiteral node) {
        return super.visit(node);
    }

    public void endVisit(BooleanLiteral node) {
    }

    public boolean visit(CastExpression node) {
        return super.visit(node);
    }

    public void endVisit(CastExpression node) {
    }

    public boolean visit(CharacterLiteral node) {
        return super.visit(node);
    }

    public void endVisit(CharacterLiteral node) {
    }

    public boolean visit(ClassInstanceCreation node) {
        return super.visit(node);
    }

    public void endVisit(ClassInstanceCreation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        String classKey = CCDAST.getKey(binding.getMethodDeclaration().getDeclaringClass());
        String globallyQualifiedClassName = this.manager.getGloballyQualifiedClassName(classKey);
        String label = "";
        if (node.getExpression() != null) {
            label = String.valueOf(label) + node.getExpression();
        }
        label = String.valueOf(label) + globallyQualifiedClassName + node.arguments().toString();
        this.createAndConnectNewNode((ASTNode)node, label, "");
        MethodFlowGraphCreatorVisitor.connectMethodCallEdges(this.lastNode, (ASTNode)node, binding, this.manager);
        this.manager.addNewInstanceStatement(classKey, this.lastNode);
    }

    public boolean visit(ConditionalExpression node) {
        return super.visit(node);
    }

    public void endVisit(ConditionalExpression node) {
    }

    public boolean visit(FieldAccess node) {
        return super.visit(node);
    }

    public void endVisit(FieldAccess node) {
    }

    public boolean visit(InfixExpression node) {
        return super.visit(node);
    }

    public void endVisit(InfixExpression node) {
    }

    public boolean visit(InstanceofExpression node) {
        return super.visit(node);
    }

    public void endVisit(InstanceofExpression node) {
    }

    public boolean visit(MethodInvocation node) {
        return super.visit(node);
    }

    public void endVisit(MethodInvocation node) {
        this.createAndConnectNewNode((ASTNode)node, node.getName().getIdentifier(), "");
        IMethodBinding binding = node.resolveMethodBinding();
        MethodFlowGraphCreatorVisitor.connectMethodCallEdges(this.lastNode, (ASTNode)node, binding, this.manager);
    }

    public boolean visit(QualifiedName node) {
        return super.visit(node);
    }

    public void endVisit(QualifiedName node) {
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (!(node.getParent() instanceof VariableDeclarationFragment && node.getParent().getParent() instanceof FieldDeclaration || !this.variableDeclaration.containsKey(binding))) {
            String sourceDecl = (String)this.variableDeclaration.get(binding);
            this.createAndConnectNewNode((ASTNode)node, sourceDecl, "");
        }
        return super.visit(node);
    }

    public void endVisit(SimpleName node) {
    }

    public boolean visit(NullLiteral node) {
        return super.visit(node);
    }

    public void endVisit(NullLiteral node) {
    }

    public boolean visit(NumberLiteral node) {
        return super.visit(node);
    }

    public void endVisit(NumberLiteral node) {
    }

    public boolean visit(ParenthesizedExpression node) {
        return super.visit(node);
    }

    public void endVisit(ParenthesizedExpression node) {
    }

    public boolean visit(PostfixExpression node) {
        return super.visit(node);
    }

    public void endVisit(PostfixExpression node) {
    }

    public boolean visit(PrefixExpression node) {
        return super.visit(node);
    }

    public void endVisit(PrefixExpression node) {
    }

    public boolean visit(StringLiteral node) {
        return super.visit(node);
    }

    public void endVisit(StringLiteral node) {
    }

    public boolean visit(SuperFieldAccess node) {
        return super.visit(node);
    }

    public void endVisit(SuperFieldAccess node) {
    }

    public boolean visit(SuperMethodInvocation node) {
        return super.visit(node);
    }

    public void endVisit(SuperMethodInvocation node) {
    }

    public boolean visit(ThisExpression node) {
        return super.visit(node);
    }

    public void endVisit(ThisExpression node) {
    }

    public boolean visit(TypeLiteral node) {
        return super.visit(node);
    }

    public void endVisit(TypeLiteral node) {
    }

    public boolean visit(VariableDeclarationExpression node) {
        return super.visit(node);
    }

    public void endVisit(VariableDeclarationExpression node) {
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (node.getParent() instanceof FieldDeclaration && node.getInitializer() != null) {
            this.createAndConnectNewNode((ASTNode)node, node.toString(), "");
        }
        return super.visit(node);
    }

    public void endVisit(VariableDeclarationFragment node) {
        super.endVisit(node);
    }

    private INode getCatchNode() {
        if (this.catchNode == null) {
            this.catchNode = new EndNode("exceptional");
        }
        return this.catchNode;
    }

    private INode searchLabeledNode(SimpleName label, DestType type) {
        String identifier = label != null ? label.getIdentifier() : "";
        int i = this.labledLoopSwitch.size() - 1;
        while (i >= 0) {
            Label x = this.labledLoopSwitch.get(i);
            if (x.type == type && (identifier.equals("") || x.label.equals(identifier))) {
                return x.node;
            }
            --i;
        }
        for (Label x : this.labledStatement) {
            if (x.type != type || !identifier.equals("") && !x.label.equals(identifier)) continue;
            return x.node;
        }
        throw new AssertionError((Object)("nothing to break or continue (Label: " + label.getIdentifier() + ") - should be a compiler error"));
    }

    private void createAndConnectNewNode(ASTNode astNode, String label, String edgeLabel) {
        Node newNode = new Node(astNode, label);
        this.connectAndSetLastNode(newNode, edgeLabel);
    }

    private void connectAndSetLastNode(INode node, String edgeLabel) {
        this.lastNode.setDestinationNode(node, edgeLabel);
        this.lastNode = node;
    }

    private Label createNewTempNodeWithLabel(ASTNode astNode, String label, DestType type) {
        TempNode tempNode = new TempNode(astNode, label);
        tempNode.lockDestinationNode(true);
        Label label1 = new Label(tempNode, this.lastLabel, type);
        this.labledLoopSwitch.add(label1);
        return label1;
    }

    private Label createNewTempNodeWithStatementLabel(ASTNode astNode, String label) {
        TempNode tempNode = new TempNode(astNode, label);
        tempNode.lockDestinationNode(true);
        Label label1 = new Label(tempNode, this.lastLabel, DestType.BREAK);
        this.labledStatement.add(label1);
        return label1;
    }

    private void deleteLabelNode(Label label) {
        boolean check = this.labledLoopSwitch.contains(label) || this.labledStatement.contains(label);
        this.labledLoopSwitch.remove(label);
        this.labledStatement.remove(label);
        if (check) {
            this.toDelete.add(label.node);
        }
    }

    private static void connectMethodCallEdges(INode lastNode, ASTNode astNode, IMethodBinding binding, LinkManager manager) {
        String bindingKey = CCDAST.getKey(binding);
        List<CallEdgeModel> possibleMethods = manager.getMethodSourceToNode(bindingKey);
        if (possibleMethods.isEmpty()) {
            String sourceClass = CCDAST.getKey(binding.getMethodDeclaration().getDeclaringClass());
            ExternalMethodNode m = new ExternalMethodNode(bindingKey, binding);
            m.addPathDestinationNode(new EndNode("normal"), "");
            manager.addMethodSourceToNode(bindingKey, sourceClass, m);
            possibleMethods = manager.getMethodSourceToNode(bindingKey);
        }
        for (CallEdgeModel m : possibleMethods) {
            lastNode.addCallDestinationNode(m.getMethodNode(), m.getLabel());
        }
    }

    private static enum DestType {
        BREAK,
        CONTINUE;

    }

    private class ForHelper {
        private TempNode forHelperExpr;
        private TempNode forHelperUpd;
        private INode lastNodeExpr;
        private Label labelContinue;
        private Label labelBreak;
        private ConditionNode condState;

        private ForHelper() {
        }
    }

    private final class Label {
        private TempNode node;
        private String label;
        private DestType type;

        private Label(TempNode node, SimpleName label, DestType type) {
            this.label = label != null ? label.getIdentifier() : "";
            this.node = node;
            this.type = type;
        }
    }

    private class TryHelper {
        private INode currentCatchNode;
        private INode currentEndNode;
        private TempNode lastCatchNode;
        private TempNode newCatchNode;
        private TempNode catchNode;
        private TempNode tempCatchNode;
        private TempNode normalFinallyNode;
        private TempNode exceptionFinallyNode;
        private TempNode returnFinallyNode;
        private INode tryNode;

        private TryHelper() {
        }
    }
}

