/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.compareJIG;

import calculateCodeDifference.compareJIG.ModifyJavaFiles;
import calculateCodeDifference.compareJIG.TraversalAlogrithm;
import calculateCodeDifference.helper.CCDHashMap;
import calculateCodeDifference.helper.exception.InternalFailureException;
import calculateCodeDifference.jig.CCDAST;
import calculateCodeDifference.jig.JavaInterclassGraph;
import calculateCodeDifference.jig.MethodPair;
import calculateCodeDifference.jig.graph.edge.IEdge;
import calculateCodeDifference.jig.graph.node.ExternalClassNode;
import calculateCodeDifference.jig.graph.node.ExternalMethodNode;
import calculateCodeDifference.jig.graph.node.IClassNode;
import calculateCodeDifference.jig.graph.node.IMethodNode;
import calculateCodeDifference.jig.graph.node.INode;
import calculateCodeDifference.jig.graph.node.IStaticNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Comparator {
    private JavaInterclassGraph oldJIG;
    private JavaInterclassGraph newJIG;
    private List<MethodPair> additionalMethods;
    private boolean disableMain = false;
    private boolean disableStaticInitializer = false;
    private boolean disableECN = false;
    private boolean disableMarkBlocks = false;
    private List<String> bigChanges = new LinkedList<String>();
    private TraversalAlogrithm traversalAlgorithm = new TraversalAlogrithm();
    private ModifyJavaFiles modifier = new ModifyJavaFiles();
    private boolean hasRun = false;

    public Comparator(JavaInterclassGraph oldJIG, JavaInterclassGraph newJIG) {
        this.oldJIG = oldJIG;
        this.newJIG = newJIG;
    }

    public void setAdditionalMethods(List<MethodPair> additionalMethods) {
        this.additionalMethods = additionalMethods;
    }

    public void disableMainMethods() {
        this.disableMain = true;
    }

    public void disableECN() {
        this.disableECN = true;
    }

    public void disableStaticInitializer() {
        this.disableStaticInitializer = true;
    }

    public void disableMarkBlocks() {
        this.disableMarkBlocks = true;
    }

    public List<String> getBigChanges() {
        return this.bigChanges;
    }

    private void addBigChange(String change) {
        this.bigChanges.add(change);
    }

    public List<IEdge> getDangerousEdges() throws InternalFailureException {
        if (this.hasRun) {
            return this.traversalAlgorithm.getDangerousEdges();
        }
        throw new InternalFailureException(new IllegalAccessException());
    }

    public void compareAndModify() throws InternalFailureException {
        this.compare();
        if (this.disableMarkBlocks) {
            this.modifier.disableBlocks();
        }
        this.modifier.modifyAll();
    }

    public void compare() throws InternalFailureException {
        if (this.hasRun) {
            throw new InternalFailureException(new IllegalAccessException());
        }
        if (!this.disableECN) {
            this.traversalAlgorithm.compare(this.oldJIG.getECN(), this.newJIG.getECN());
        }
        this.compareAdditionalMethods();
        if (!this.disableMain) {
            this.compareMainMethods();
        }
        if (!this.disableStaticInitializer) {
            this.compareStaticIntializers();
        }
        System.out.println("Dangerous Edges:");
        for (IEdge x : this.traversalAlgorithm.getDangerousEdges()) {
            if (x.getFrom() instanceof IClassNode && x.getTo() instanceof ExternalMethodNode) {
                ExternalMethodNode node = (ExternalMethodNode)x.getTo();
                if (node.isDefaultNode()) {
                    List<INode> newInstances = this.newJIG.getNewInstanceStatements(node.getSourceClassKey());
                    for (INode newInstance : newInstances) {
                        this.modifier.addNode(newInstance.getASTNode());
                    }
                } else {
                    this.modifier.addNode(x.getFrom().getASTNode());
                }
            } else if (x.getFrom() instanceof ExternalClassNode || x.getFrom() instanceof IClassNode) {
                this.modifier.addNode(x.getTo().getASTNode());
            } else {
                this.modifier.addNode(x.getFrom().getASTNode());
            }
            System.out.println(x);
            System.out.println("\t" + x.getFrom().getClass());
            System.out.println("\t" + x.getFrom());
            System.out.println("\t" + x.getTo().getClass());
            System.out.println("\t" + x.getTo());
        }
        this.hasRun = true;
    }

    private void compareAdditionalMethods() {
        if (this.additionalMethods == null) {
            return;
        }
        for (MethodPair x : this.additionalMethods) {
            CCDHashMap<String, IMethodNode> oldAddMethodHashMap = new CCDHashMap<String, IMethodNode>();
            for (IMethodNode iMethodNode : this.oldJIG.getMethod(x.getMethodKey())) {
                oldAddMethodHashMap.put(CCDAST.getKey(iMethodNode.getMethodBinding()), iMethodNode);
            }
            for (IMethodNode iMethodNode : this.newJIG.getMethod(x.getMethodKey())) {
                IMethodNode o = (IMethodNode)oldAddMethodHashMap.get(CCDAST.getKey(iMethodNode.getMethodBinding()));
                if (o != null) {
                    oldAddMethodHashMap.remove(CCDAST.getKey(o.getMethodBinding()));
                    this.traversalAlgorithm.compare(o, iMethodNode);
                    continue;
                }
                this.modifier.addNode(iMethodNode.getASTNode());
                this.addBigChange("new additional method in class " + iMethodNode.getSourceClassKey());
            }
            for (Map.Entry entry : oldAddMethodHashMap) {
                this.addBigChange("old additional method in class " + ((IMethodNode)entry.getValue()).getSourceClassKey());
            }
        }
    }

    private void compareMainMethods() {
        CCDHashMap<String, IMethodNode> oldMainMethodHashMap = new CCDHashMap<String, IMethodNode>();
        for (IMethodNode iMethodNode : this.oldJIG.getMainMethods()) {
            oldMainMethodHashMap.put(CCDAST.getKey(iMethodNode.getMethodBinding()), iMethodNode);
        }
        for (IMethodNode iMethodNode : this.newJIG.getMainMethods()) {
            IMethodNode o = (IMethodNode)oldMainMethodHashMap.get(CCDAST.getKey(iMethodNode.getMethodBinding()));
            if (o != null) {
                oldMainMethodHashMap.remove(CCDAST.getKey(o.getMethodBinding()));
                this.traversalAlgorithm.compare(o, iMethodNode);
                continue;
            }
            this.modifier.addNode(iMethodNode.getASTNode());
            this.addBigChange("new main method in class " + iMethodNode.getSourceClassKey());
        }
        for (Map.Entry entry : oldMainMethodHashMap) {
            this.addBigChange("old main method in class " + ((IMethodNode)entry.getValue()).getSourceClassKey());
        }
    }

    private void compareStaticIntializers() {
        CCDHashMap<String, IStaticNode> oldStaticInitHashMap = new CCDHashMap<String, IStaticNode>();
        for (IStaticNode iStaticNode : this.oldJIG.getStaticInitializers()) {
            oldStaticInitHashMap.put(CCDAST.getKey(iStaticNode.getTypeBindingOfParentClass()), iStaticNode);
        }
        for (IStaticNode iStaticNode : this.newJIG.getStaticInitializers()) {
            IStaticNode o = (IStaticNode)oldStaticInitHashMap.get(CCDAST.getKey(iStaticNode.getTypeBindingOfParentClass()));
            if (o != null) {
                oldStaticInitHashMap.remove(CCDAST.getKey(o.getTypeBindingOfParentClass()));
                this.traversalAlgorithm.compare(o, iStaticNode);
                continue;
            }
            this.addBigChange("new class " + CCDAST.getKey(iStaticNode.getTypeBindingOfParentClass()));
            this.modifier.addNode(iStaticNode.getASTNode());
        }
        for (Map.Entry entry : oldStaticInitHashMap) {
            this.addBigChange("old class " + CCDAST.getKey(((IStaticNode)entry.getValue()).getTypeBindingOfParentClass()));
        }
    }
}

