/*
 * Decompiled with CFR 0.152.
 */
package calculateCodeDifference.ast;

import calculateCodeDifference.ast.CCDASTRequestor;
import calculateCodeDifference.helper.exception.InternalFailureException;
import calculateCodeDifference.helper.exception.NoProjectSelectedException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;

public class ProjectLoader {
    private static final String JDT_NATURE = "org.eclipse.jdt.core.javanature";
    private IProject internalProject;
    private String externalPath;
    private CCDASTRequestor requestor;

    public String getExternalPath() {
        return this.externalPath;
    }

    public void set(String externalPath) {
        this.internalProject = null;
        this.externalPath = externalPath;
        this.deleteRequestor();
    }

    public void set(IProject internalProject) {
        this.internalProject = internalProject;
        this.externalPath = null;
        this.deleteRequestor();
    }

    public void deleteRequestor() {
        this.requestor = null;
    }

    public void reset() {
        this.externalPath = null;
        this.internalProject = null;
        this.deleteRequestor();
    }

    public boolean isSelected() {
        return this.externalPath != null || this.internalProject != null;
    }

    public CCDASTRequestor loadProject(IProgressMonitor monitor) throws NoProjectSelectedException, InternalFailureException {
        if (this.requestor != null) {
            return this.requestor;
        }
        try {
            if (this.internalProject != null) {
                this.createJavaInterclassGraph(monitor);
                return this.requestor;
            }
            if (this.externalPath != null) {
                this.loadExternalProjectToWorkspace();
                this.createJavaInterclassGraph(monitor);
                this.deleteInternalProject();
                return this.requestor;
            }
        }
        catch (Throwable e) {
            this.requestor = null;
            throw e;
        }
        throw new NoProjectSelectedException();
    }

    private void loadExternalProjectToWorkspace() throws InternalFailureException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            Path projectDotProjectFile = new Path(String.valueOf(this.externalPath) + "/.project");
            IProjectDescription projectDescription = workspace.loadProjectDescription((IPath)projectDotProjectFile);
            String projectName = projectDescription.getName();
            projectDescription.setName(String.valueOf(projectName) + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()));
            this.internalProject = workspace.getRoot().getProject(projectDescription.getName());
            this.internalProject.create(projectDescription, null);
            this.internalProject.open(null);
        }
        catch (CoreException e) {
            throw new InternalFailureException((Exception)((Object)e));
        }
    }

    private void deleteInternalProject() throws InternalFailureException {
        try {
            this.internalProject.delete(false, false, null);
            this.internalProject = null;
        }
        catch (CoreException e) {
            throw new InternalFailureException((Exception)((Object)e));
        }
    }

    private void createJavaInterclassGraph(IProgressMonitor monitor) throws NoProjectSelectedException, InternalFailureException {
        IJavaProject project = JavaCore.create((IProject)this.internalProject);
        try {
            if (project.getProject().isNatureEnabled(JDT_NATURE)) {
                this.createJIG(project, monitor);
                return;
            }
        }
        catch (CoreException e) {
            throw new InternalFailureException((Exception)((Object)e));
        }
        throw new NoProjectSelectedException();
    }

    private void createJIG(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IPackageFragment[] packages;
        LinkedList<ICompilationUnit> units = new LinkedList<ICompilationUnit>();
        IPackageFragment[] iPackageFragmentArray = packages = javaProject.getPackageFragments();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment mypackage = iPackageFragmentArray[n2];
            if (mypackage.getKind() == 1) {
                ICompilationUnit[] iCompilationUnitArray = mypackage.getCompilationUnits();
                int n3 = iCompilationUnitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit unit = iCompilationUnitArray[n4];
                    units.add(unit);
                    ++n4;
                }
            }
            ++n2;
        }
        this.requestor = new CCDASTRequestor();
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setProject(javaProject);
        parser.createASTs(units.toArray(new ICompilationUnit[units.size()]), new String[0], (ASTRequestor)this.requestor, monitor);
    }
}

