package com.example.XMLtoHTMLbuilder.view;

import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/**
 * Outputs the messages on the console.
 * 
 * Only one instance of OutputHandler can exist => Singleton.
 * 
 * @author Konstantin Grupp
 * 
 */
public final class OutputHandler {
	private static OutputHandler handler;
	public static final String CONSOLE_NAME = "com.example.XMLtoHTMLbuilder";
	private MessageConsole myConsole;

	static {
		handler = new OutputHandler();
	}

	private OutputHandler() {
		this.myConsole = findConsole(CONSOLE_NAME);
	}

	public static OutputHandler getInstance() {
		return handler;
	}

	
	public void println(String str) {
		this.myConsole.newMessageStream().println(str);
	}

	public MessageConsole findConsole(String name) {
		ConsolePlugin plugin = ConsolePlugin.getDefault();
		IConsoleManager conMan = plugin.getConsoleManager();
		IConsole[] existing = conMan.getConsoles();
		for (int i = 0; i < existing.length; i++) {
			if (name.equals(existing[i].getName())) {
				return (MessageConsole) existing[i];
			}
		}
		// If no console found, create a new one
		MessageConsole myConsole = new MessageConsole(name, null);
		conMan.addConsoles(new IConsole[] { myConsole });
		return myConsole;
	}
	
	public MessageConsoleStream getMCSMessageConsoleStream() {
		return this.myConsole.newMessageStream();
	}

}
