package com.example.XMLtoHTMLbuilder.commands.propertyTester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

import com.example.XMLtoHTMLbuilder.commands.ProjectUsability;

/**
 * 
 * 
 * @author Konstantin Grupp
 *
 */
public class TestBuilderEnabled extends PropertyTester {

	private static final String IS_ENABLED = "isEnabled";

	@Override
	public boolean test(Object receiver, String property, Object[] args,
			Object expectedValue) {
		if (IS_ENABLED.equals(property)) {
			IProject project = (IProject) Platform.getAdapterManager()
					.getAdapter(receiver, IProject.class);
			if (project != null) {
				return ProjectUsability.hasBuilder(project);
			}
		}
		return false;
	}

}
