package com.example.XMLtoHTMLbuilder.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

import com.example.XMLtoHTMLbuilder.MyBuilder;

/**
 * Has usability some functions
 * 
 * @author Konstantin Grupp
 *
 */
public abstract class ProjectUsability {
	
	public static final IProject getProject(ExecutionEvent event) {
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			Object element = ((IStructuredSelection) selection).getFirstElement();
			return (IProject) Platform.getAdapterManager().getAdapter(element, IProject.class);
		}
		return null;
	}
	
	public static final boolean hasBuilder(IProject project) {
		try {
			for (ICommand buildSpec : project.getDescription().getBuildSpec()) {
				if (MyBuilder.BUILDER_ID.equals(buildSpec.getBuilderName())) {
					return true;
				}
			}
		} catch (CoreException e) {
			
		}
		return false;
	}

}
