package com.example.XMLtoHTMLbuilder.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

import com.example.XMLtoHTMLbuilder.MyBuilder;
import com.example.XMLtoHTMLbuilder.view.OutputHandler;

public class AddBuilder extends AbstractHandler implements IHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IProject project = ProjectUsability.getProject(event);
		
		if (project != null) {
			try {
				if (ProjectUsability.hasBuilder(project)) {
					// already enabled
					return null;
				}
				// add builder to project properties
				IProjectDescription description = project.getDescription();
				ICommand buildCommand = description.newCommand();
				buildCommand.setBuilderName(MyBuilder.BUILDER_ID);
				
				OutputHandler.getInstance().println("New Builder added: "+buildCommand.getBuilderName());
				
				List<ICommand> commands = new ArrayList<ICommand>();
				commands.addAll(Arrays.asList(description.getBuildSpec()));
				commands.add(buildCommand);
				
				description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
				project.setDescription(description, null);
			} catch (CoreException e) {
				// could not read/write project description
				e.printStackTrace();
			}
		}
		return null;
	}

}
