package com.example.XMLtoHTMLbuilder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.example.XMLtoHTMLbuilder.view.OutputHandler;

public class XSLTransformer {
	
	// https://docs.oracle.com/javase/tutorial/jaxp/xslt/transformingXML.html
	public static InputStream transform(InputStream sourceXML, InputStream stylesheetXSL, IProgressMonitor monitor) {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		StreamSource stylesource = new StreamSource(stylesheetXSL);
		ByteArrayOutputStream resultOS = new ByteArrayOutputStream();
		StreamResult result = new StreamResult(resultOS);
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(sourceXML);
			DOMSource source = new DOMSource(document);
			
			TransformerFactory tFactory = TransformerFactory.newInstance();
			Transformer transformer = tFactory.newTransformer(stylesource);
			
			transformer.transform(source, result);
		} catch (TransformerException | SAXException | ParserConfigurationException | IOException e) {
			OutputHandler.getInstance().println(e.getMessage());
			return new ByteArrayInputStream("compile exception".getBytes());
		} finally {
			monitor.done();
		}
		return new ByteArrayInputStream(resultOS.toByteArray());
	}
	
}
