package com.example.XMLtoHTMLbuilder;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class XMLtoHTMLResourceVisitor implements IResourceDeltaVisitor, IResourceVisitor {
	
	private IProgressMonitor subMonitor;
	private IProject project;
	private boolean needRebuild = false;
	private ArrayList<IFile> files = new ArrayList<IFile>();
	private ArrayList<IResource> toDelete = new ArrayList<IResource>();

	public XMLtoHTMLResourceVisitor(IProject project, IProgressMonitor monitor) throws CoreException {
		this.project = project;
		this.subMonitor = SubMonitor.convert(monitor, 1);
	}

	@Override
	/**
	 * Visitor fr inkrementelles konvertieren der Dateien
	 */
	public boolean visit(IResourceDelta delta) throws CoreException {
		switch (delta.getKind()) {
		case IResourceDelta.REMOVED:
			IResource resource = delta.getResource();
			this.toDelete.add(delta.getResource());
			if (resource.getType() != IResource.FOLDER) {
				return false;
			} else { // Falls es eine Datei ist
				return true;
			}
		case IResourceDelta.ADDED: 
		case IResourceDelta.CHANGED: return visitHelper(delta.getResource(), true); 
		}
		return false;
	}

	@Override
	/**
	 * Visitor fr vollstndiges konvertieren
	 */
	public boolean visit(IResource resource) throws CoreException {
		return this.visitHelper(resource, false);
	}
	
	private boolean visitHelper(IResource resource, boolean isIncremental) {
		// Abbruch des Users behandeln
		if (subMonitor.isCanceled()) {
			throw new OperationCanceledException();
		}
		
		if (resource.getType() != IResource.FILE) {
			return true;
		} else {
			IFile sourceIFile = project.getFile(resource.getProjectRelativePath());  
			if (isIncremental && sourceIFile.getName().equals(MyBuilder.STYLESHEET_FILE)) {
				this.needRebuild = true;
				this.files.clear();
				return false;
			} else if (sourceIFile.getFileExtension().equals("xml")) {
				files.add(sourceIFile);
			}
		}
		return true;
	}
	
	public boolean needsRebuild() {
		return this.needRebuild;
	}
	
	public Collection<IFile> getResult() {
		return this.files;
	}
	
}
