package com.example.XMLtoHTMLbuilder;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

import com.example.XMLtoHTMLbuilder.view.OutputHandler;

public class MyBuilder extends IncrementalProjectBuilder {

	public static final String BUILDER_ID = "com.example.XMLtoHTMLbuilder.myBuilder";
	
	private static final String COMPILED_FOLDER = "compiled";
	
	public static final String STYLESHEET_FILE = "main.xsl";

	static int counter = 0;
	
	@Override
	// http://help.eclipse.org/luna/index.jsp?topic=%2Forg.eclipse.platform.doc.isv%2Fguide%2FresAdv_builders.htm
	protected IProject[] build(int kind, Map<String,String> args, IProgressMonitor monitor)
			throws CoreException {
		OutputHandler.getInstance().println("BUILD STARTS with buildmode "+kindToString(kind));
		IProject project = this.getProject();
		if (kind == IncrementalProjectBuilder.FULL_BUILD) {
			fullBuild(monitor);
		} else {
			IResourceDelta delta = getDelta(project);
			if (delta == null) {
				fullBuild(monitor);
			} else {
				incrementalBuild(delta, monitor);
			}
		}
		
		OutputHandler.getInstance().println("BUILD ENDS");
		return null;
	}

	private void fullBuild(IProgressMonitor monitor)
			throws CoreException {
		try {
			monitor.setTaskName("Caclulate work for full build");
			SubMonitor subMonitor = SubMonitor.convert(monitor, 100);
			IProject project = this.getProject();
			
			// Alte Kompilierungen lschen
			project.getFolder(COMPILED_FOLDER).delete(false, subMonitor.newChild(10));
			
			XMLtoHTMLResourceVisitor visitor = new XMLtoHTMLResourceVisitor(project,subMonitor.newChild(5));
			project.accept(visitor);
			
			compileFoundFiles(visitor.getResult(), subMonitor.newChild(85));
		} finally {
			monitor.done();
		}
	}

	private void incrementalBuild(IResourceDelta delta,
			IProgressMonitor monitor) throws CoreException {
		SubMonitor subMonitor = SubMonitor.convert(monitor, 100);
		XMLtoHTMLResourceVisitor visitor = new XMLtoHTMLResourceVisitor(getProject(),subMonitor.newChild(5));
		delta.accept(visitor);
		
		if (visitor.needsRebuild()) {
			fullBuild(subMonitor.newChild(95));
			//this.forgetLastBuiltState();
			//this.needRebuild(); // Destroys monitor
		} else {
			compileFoundFiles(visitor.getResult(), subMonitor.newChild(95));
		}
	}
	
	private void compileFoundFiles(Collection<IFile> fileToChange, IProgressMonitor monitor) throws CoreException {
		try {
			monitor.setTaskName("Compile files");
			SubMonitor subMonitor = SubMonitor.convert(monitor, fileToChange.size()*2+1);
			IProject project = this.getProject();
			IPath destination = this.getDestination(subMonitor.newChild(1));
			IFile styleXSLT = project.getFile(STYLESHEET_FILE);
			
			for (IFile sourceXML : fileToChange) {
				// Abbruch des Users behandeln
				if (monitor.isCanceled()) {
					throw new OperationCanceledException();
				}
				
				subMonitor.subTask("compile file "+sourceXML.getName());
				OutputHandler.getInstance().println(sourceXML.getFullPath().toString());
				
				IFile result = project.getFile(destination.append("/"+sourceXML.getName()+".html"));
				InputStream output = XSLTransformer.transform(sourceXML.getContents(), styleXSLT.getContents(), subMonitor.newChild(1));
				if (result.exists()) {
					result.setContents(output, false, true, subMonitor.newChild(1));
				} else {
					result.create(output, false, subMonitor.newChild(1));
				}
			}
		} finally {
			monitor.done();
		}
	}
	
	private IPath getDestination(IProgressMonitor monitor) throws CoreException {
		IProject project = this.getProject();
		IFolder compiled = project.getFolder(COMPILED_FOLDER);
		if (!compiled.exists()) {
			compiled.create(false, true, monitor);
		} else {
			monitor.done();
		}
		return compiled.getProjectRelativePath();
	}
	
	public File convertToFile(IResource resource) {
		return resource.getLocation().toFile();
	}
	
	/*
	 * For testing purposes
	 */
	private String kindToString(int kind) {
		switch (kind) {
		case FULL_BUILD: return "FULL BUILD";
		case INCREMENTAL_BUILD: return "INCREMENTAL_BUILD";
		case AUTO_BUILD: return "AUTO_BUILD";
		case CLEAN_BUILD: return "CLEAN_BUILD";
		}
		return "INVALID_BUILD_KIND";
	}

}