<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  version="1.0">
  <xsl:output method="html"/>
       
  <xsl:template match="/MODULE">     
    <html><body>          
       <h1>Inhaltsangabe</h1>         
       <ol>     
       		<xsl:apply-templates select="SEMINAR|VORLESUNG" mode="IA" />
       </ol>  
       <h1>Seminare und Vorlesungen</h1> 
       <xsl:apply-templates select="SEMINAR|VORLESUNG" mode="def"/>
    </body></html>                
  </xsl:template>
   
  <xsl:template match="SEMINAR|VORLESUNG" mode="IA">
	<li><xsl:element name="a">
      <xsl:attribute name="href">#<xsl:value-of select="ID"/></xsl:attribute>
      <xsl:value-of select="TITEL"/>
    </xsl:element></li> 
  </xsl:template>
  
  <xsl:template match="SEMINAR|VORLESUNG" mode="def">
  	<div>
  		<xsl:apply-templates select="ID" mode="def"/>
  		<xsl:apply-templates select="TITEL" mode="def"/>
  		<xsl:apply-templates select="BESCHREIBUNG|THEMEN|LINK"/>
  	</div>
  </xsl:template>
  
  <xsl:template match="THEMEN">
  	<h3>Themen</h3>
    <ol>
      <xsl:apply-templates select="THEMA" />
    </ol>  
    <xsl:apply-templates select="LINK"/> 
  </xsl:template>
  <xsl:template match="THEMA">
  	<li><xsl:apply-templates /></li>
  </xsl:template>
  
  <xsl:template match="TITEL" mode="IA">     
    <li><xsl:apply-templates/></li>
  </xsl:template>                    
  
  <xsl:template match="ID" mode="IA">     
    <li><xsl:apply-templates/></li>
  </xsl:template>                 

  <xsl:template match="SEMINAR/TITEL" mode="def">     
    <h2 align="center">Seminar: <xsl:apply-templates/> </h2>
  </xsl:template>
  <xsl:template match="VORLESUNG/TITEL" mode="def">     
    <h2 align="center">Vorlesung: <xsl:apply-templates/> </h2>
  </xsl:template>
   
  <xsl:template match="ID" mode="def">     
    <xsl:element name="span">
      <xsl:attribute name="id">
        <xsl:apply-templates/>
      </xsl:attribute>
    </xsl:element> 
  </xsl:template>   
  
  <xsl:template match="BESCHREIBUNG">
    <h3>Beschreibung</h3>     
    <p><xsl:apply-templates/> </p>
    
  </xsl:template>

  <xsl:template match="LINK">
    <xsl:if test="@url">
    <xsl:element name="a">
      <xsl:attribute name="href">
        <xsl:value-of select="@url"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element> 
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>