<!DOCTYPE html>
<html>
	<head>
		<title>
			Inoks Baukastensystem - Setup
		</title>
		<link rel="STYLESHEET" type="text/css" href="data/css/print.css" media="print">
		<meta name="author" content="Konstantin Grupp">
		<meta content="text/html; charset=UTF-8" http-equiv="Content-Type">
	</head>
	<body>
<?php

/**
 * 
 * eigener Errorhandler um jegliche Warnungen zu deaktivieren
 */
function handleError($errno, $errstr, $errfile, $errline, array $errcontext)
{
    // Wenn Fehler unterdrückt werden sollen, abbrechen
    if (0 === error_reporting()) {
        return false;
    }

    throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
}
set_error_handler('handleError');

// Hier wird die Installation gestartet

if (!isset($_POST['ROOTPATH'])) {
	echo "<div>Willkommen im Setup von Inoks Baukastensystem. ".
		"Geben sie hier ihren Rootpfad an. (der Pfad in dem der files Ordner von IBKS liegt)<br>" .
		"<form action=\"INSTALL_IBKS.php\" method=\"post\">" .
		"<input type=\"text\" name=\"ROOTPATH\">" .
		"<input type=\"submit\" value=\"Setup starten!\">" .
		"</form>";
} else {
	define('ROOTPATH', $_POST['ROOTPATH']);
	if (!is_file(ROOTPATH.'files/SETUP_IBKS')) {
		echo "<p>Die Datei SETUP_IBKS im Ordner files existiert nicht! " .
			"Erstellen sie eine leere Datei mit dem Namen um das Setup auszuführen.</p>";
	} else {
		include_once ROOTPATH.'files/lib/inc_globalvars.php';
	
		//		Ausgabefunktionen
		include_once LIB.'inc_functions.php';
		//		Datenbank-Anbindung
		include_once CLASSES.'class_MySQL.php';
		$mysql = new MySQL();
		//		Setup
		include_once CLASSES.'class_setup.php';
		
		///////////////////////////////////////////////////////////////////////////////////////////////////////
		// Setup ausführen
		
		Setup::setupAll();
		
		unset($mysql);
	}
}

?>
	</body>
</html>