<?php

/**
 * 
 * Die Steuerung des BBCodes
 * @param Array $params formID und textareaID müssen gesetzt sein!
 * @param Smarty $smarty
 */
function smarty_function_bbcodes($params, &$smarty) {
	global $BBC, $cache, $tpl;
	
	if (!isset($params['formID'], $params['textareaID'])) die('Template-BBC Error!'); 
	$formID = $params['formID'];
	$textareaID = $params['textareaID'];
	
	if (!$cache->isCached('bbcodes', 'helper/bbcodes.tpl', ABK.'|'.$formID.'_'.$textareaID, -1)) {
		
		if ((isset($params['additional_tags'])) && 
			($params['additional_tags'] == 'true')) $additional_tags = true;
		else $additional_tags = false;
	
		if (!isset($params['colspan'])) $colspan = 1;
		else $colspan = $params['colspan'];
	
		$tpl->assign('BBC_FORMID', $formID);
		$tpl->assign('BBC_TEXTAREAID', $textareaID);
		$tpl->assign('BBC_ADDITIONAL_TAGS_SHOW', $additional_tags);
		$tpl->assign('BBC_COLSPAN', $colspan);
		$BBC->assignSmiley();
		//$cache->noCache('bbcodes', 'helper/bbcodes.tpl');
	}
	$cache->display('bbcodes');
}

?>