-- --------------------------------------------------------
-- --------------------------------------------------------
-- SQL-Settings
-- --------------------------------------------------------
-- --------------------------------------------------------

SET time_zone = "+00:00";
-- SET charset = UTF8;
-- SET engine = InnoDB;

--
-- Datenbank: `ibks`
--

-- --------------------------------------------------------
-- --------------------------------------------------------
-- General
-- --------------------------------------------------------
-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_settings`
--

CREATE TABLE IF NOT EXISTS `general_settings` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abk` varchar(15) NOT NULL,
  `FounderID` int(10) UNSIGNED NOT NULL,
  `responsiblePerson` varchar(127) NOT NULL,
  `title` varchar(127) NOT NULL DEFAULT 'Noch nicht festgelegt',
  `keywords` varchar(4097) NOT NULL DEFAULT '',
  `shortcut_icon` varchar(127) NOT NULL DEFAULT 'img_std_favicon.ico',
  `pic_header` varchar(127) NOT NULL DEFAULT 'img_std_header.png',
  `design_type` varchar(15) NOT NULL DEFAULT 'blue',
  `absender` varchar(255) NOT NULL DEFAULT 'noreply@web714.dashosting.de',
  `std_page0` varchar(15) NOT NULL DEFAULT 'impressum',
  `std_page1` varchar(15) NOT NULL DEFAULT 'impressum',
  `KalenderBoardID` int(11) NOT NULL DEFAULT '0',
  `GaestebuchLockForUndeclared` tinyint(1) NOT NULL DEFAULT '0',
  `ActivateRegistration` tinyint(4) NOT NULL DEFAULT '0',
  `RegistrationKey` varchar(32) NOT NULL DEFAULT 'secretRegKey_lskdfjlknsdnvls',
  `showAll` tinyint(1) NOT NULL DEFAULT '1',
  `Beschreibung` varchar(4097) NOT NULL DEFAULT 'Beschreibung noch nicht festgelegt',
  PRIMARY KEY (`abk`),
  UNIQUE KEY (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_designs`
--

CREATE TABLE IF NOT EXISTS `general_designs` (
  `type` varchar(15) NOT NULL,
  `color1` varchar(15) NOT NULL,
  `color1_aufgehellt` varchar(15) NOT NULL,
  `color1_link` varchar(15) NOT NULL,
  `color2` varchar(15) NOT NULL,
  `color2_link` varchar(15) NOT NULL,
  `color_nav1_normal` varchar(15) NOT NULL,
  `color_nav1_hover` varchar(15) NOT NULL,
  `pic_background` varchar(127) NOT NULL,
  `pic_news` varchar(127) NOT NULL,
  PRIMARY KEY (`type`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_navigation`
--

CREATE TABLE IF NOT EXISTS `general_navigation` (
  `ID` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abk` varchar(15) NOT NULL,
  `declared` tinyint(1) NOT NULL,
  `showInNav` tinyint(1) NOT NULL DEFAULT '1',
  `section` varchar(15) NOT NULL,
  `orderID` int(11) NOT NULL DEFAULT '0',
  `name` varchar(127) NOT NULL,
  `title` varchar(511) NOT NULL,
  `filename` varchar(127) NOT NULL,
  PRIMARY KEY (`ID`)
);

--
-- Tabellenstruktur für Tabelle `general_navigation_filenames`
--

CREATE TABLE IF NOT EXISTS `general_navigation_filenames` (
  `ID` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abk` varchar(15) NOT NULL,
  `filename` varchar(127) NOT NULL,
  `section` varchar(15) NOT NULL,
  PRIMARY KEY (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_links`
--

CREATE TABLE IF NOT EXISTS `general_links` (
  `ID` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abk` varchar(15) NOT NULL,
  `link` varchar(511) NOT NULL,
  PRIMARY KEY (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_news`
--

CREATE TABLE IF NOT EXISTS `general_news` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abk` varchar(15) NOT NULL,
  `Time` int(11) NOT NULL DEFAULT '0',
  `titel` varchar(127) NOT NULL,
  `inhalt` text NOT NULL,
  PRIMARY KEY `ID` (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_specialpages`
--

CREATE TABLE IF NOT EXISTS `general_specialpages` (
  `abk` varchar(15) NOT NULL,
  `section` varchar(15) NOT NULL,
  `Titel` varchar(127) NOT NULL,
  `Time` int(11) NOT NULL DEFAULT '0',
  `Inhalt` text NOT NULL,
  PRIMARY KEY (`abk`, `section`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_unvalid_accounts`
--

CREATE TABLE IF NOT EXISTS `general_unvalid_accounts` (
  `ID` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abk` varchar(15) NOT NULL,
  `Nick` varchar(30) NOT NULL,
  `PW` varchar(32) NOT NULL,
  `Mail` varchar(50) NOT NULL,
  `VerificationKey` varchar(127) NOT NULL,
  PRIMARY KEY (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_users`
--
-- abk + UserID ergibt eindeutige ID
-- LinkID verkn�pft Accounts in verschiedenen Instanzen

CREATE TABLE IF NOT EXISTS `general_users` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Nick` varchar(30) NOT NULL,
  `PW` varchar(32) NOT NULL,
  `EMail` varchar(50) NOT NULL,
  `currentSession` varchar(63) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY (`Nick`)
);

CREATE TABLE IF NOT EXISTS `general_users_pages` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abk` varchar(15) NOT NULL,
  PRIMARY KEY (`ID`, `abk`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `general_message`
--

CREATE TABLE IF NOT EXISTS `general_message` (
  `ID` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `lang` varchar(3) NOT NULL,
  `message_type` SET('error', 'success', 'info') NOT NULL,
  `type` varchar(100) NOT NULL,
  `message` varchar(511) NOT NULL,
  PRIMARY KEY (`lang`, `message_type`, `type`),
  UNIQUE KEY (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `forum_smiley`
--

CREATE TABLE IF NOT EXISTS `forum_smiley` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Alias` varchar(20) NOT NULL,
  `Bildlink` varchar(20) NOT NULL,
  `Anzeigen` tinyint(4) NOT NULL,
  PRIMARY KEY (`ID`)
);



-- --------------------------------------------------------
-- --------------------------------------------------------
-- Grunddefinitionen
-- --------------------------------------------------------
-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `admin_rights`
--

CREATE TABLE IF NOT EXISTS `admin_rights` (
  `ID` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `AdminID` int(11) NOT NULL,
  `abk` varchar(15) NOT NULL,
  PRIMARY KEY (`ID`)
);

-- --------------------------------------------------------
-- --------------------------------------------------------
-- Tabellen für Seiten
-- --------------------------------------------------------
-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `dummy_account`
--

CREATE TABLE IF NOT EXISTS `dummy_account` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Letzter_Login` int(11) NOT NULL DEFAULT '0',
  `Aktivitaet` int(11) NOT NULL DEFAULT '0',
  `ICQ` varchar(9) NOT NULL DEFAULT '0',
  `Skype` varchar(30) NOT NULL DEFAULT '',
  `EMail` varchar(50) NOT NULL,
  `EMail_show` tinyint(1) NOT NULL DEFAULT '1',
  `Benachrichtigung` tinyint(1) NOT NULL DEFAULT '1',
  `Geburtstag` int(11) NOT NULL DEFAULT '0',
  `ForumPostCounter` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE (`Nick`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `dummy_forum_board`
--

CREATE TABLE IF NOT EXISTS `dummy_forum_board` (
  `BoardID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Name` varchar(127) NOT NULL DEFAULT 'Neues Forum',
  `OrderID` int(11) NOT NULL DEFAULT '0',
  `Description` varchar(255) NOT NULL DEFAULT '',
  `Posts` int(11) NOT NULL DEFAULT '0',
  `Threads` int(11) NOT NULL DEFAULT '0',
  `LastPostID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`BoardID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `dummy_forum_thread`
--

CREATE TABLE IF NOT EXISTS `dummy_forum_thread` (
  `ThreadID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `BoardID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `Thema` varchar(100) NOT NULL DEFAULT 'Neues Thema',
  `Autor` varchar(20) NOT NULL DEFAULT '',
  `AutorID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `LastPostID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `Posts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ThreadID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `dummy_forum_post`
--

CREATE TABLE IF NOT EXISTS `dummy_forum_post` (
  `PostID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ThreadID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `Autor` varchar(20) NOT NULL DEFAULT '',
  `AutorID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `Time` int(11) NOT NULL DEFAULT '0',
  `Inhalt` text NOT NULL,
  PRIMARY KEY (`PostID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `dummy_kalender_termine`
--

CREATE TABLE IF NOT EXISTS `dummy_kalender_termine` (
  `TerminID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Datum` int(11) NOT NULL DEFAULT '0',
  `Timestamp` int(11) NOT NULL DEFAULT '0',
  `AutorID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `Autor` varchar(30) NOT NULL,
  `Titel` varchar(70) NOT NULL,
  `Beschreibung` text NOT NULL,
  `Status` int(2) NOT NULL DEFAULT '0',
  `ThreadID` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`TerminID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `dummy_gaestebuch`
--

CREATE TABLE IF NOT EXISTS `dummy_gaestebuch` (
  `PostID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Autor` varchar(20) NOT NULL,
  `AutorID` int(11) NOT NULL,
  `Time` int(11) NOT NULL DEFAULT '0',
  `Inhalt` text NOT NULL,
  PRIMARY KEY (`PostID`)
);

-- --------------------------------------------------------
-- --------------------------------------------------------
-- Melina (only)
-- --------------------------------------------------------
-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `melina_account_special`
--

CREATE TABLE IF NOT EXISTS `melina_account_special` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Geschlecht` varchar(10) NOT NULL,
  `Kissed` tinyint(4) NOT NULL DEFAULT '0',
  `KissTime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
);

INSERT INTO `melina_account_special` (`ID`, `Geschlecht`, `Kissed`, `KissTime`) VALUES
(1, 'weiblich', 1, 1325585417),
(2, 'maennlich', 0, 1325585138);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `melina_fruehstueck`
--

CREATE TABLE IF NOT EXISTS `melina_fruehstueck` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Timestamp` int(11) NOT NULL DEFAULT '0',
  `Autor` varchar(10) NOT NULL,
  `BeiWem` varchar(10) NOT NULL,
  `Kommentar` varchar(50) NOT NULL,
  `Gegessen` tinyint(4) NOT NULL,
  `Verified` tinyint(4) NOT NULL,
  PRIMARY KEY (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `melina_ideen`
--

CREATE TABLE IF NOT EXISTS `melina_ideen` (
  `ID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Autor` varchar(30) NOT NULL,
  `Eintragsdatum` int(11) NOT NULL DEFAULT '0',
  `Type` varchar(10) NOT NULL,
  `Idee` varchar(50) NOT NULL,
  `Beschreibung` text NOT NULL,
  `Voting` int(11) NOT NULL DEFAULT '0',
  `Umgesetzt` tinyint(1) NOT NULL DEFAULT '0',
  `Timestamp` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `melina_magliste`
--

CREATE TABLE IF NOT EXISTS `melina_magliste` (
  `ID` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Time` int(11) NOT NULL DEFAULT '0',
  `Inhalt` text NOT NULL,
  PRIMARY KEY (`ID`)
);