<?php 

// System
//	Gesetzt über Setup werden ROOT und PUBLICPATH
define('FILES', ROOTPATH.'files/');

//	Konfiguration laden
include_once(ROOTPATH.'files/config.php');

//	Background
define('INC', FILES.'inc/');
define('DATA', FILES.'data/');
define('PAGES', INC.'pages/');
define('LIB', FILES.'lib/');
define('CLASSES', LIB.'class/');
define('TEMPLATES', FILES.'templates/');
define('DUMMYID', 0);

//	Tools
define('TOOLS', WWW.'tools/');

// Refresh-Time
define('REF_ERROR', (DEV ? 100000 : 5));
define('REF_SUCCESS', (DEV ? 100000 : 1));

// Beschränkungen (Account)
define('STRING_REGEX', '/[^\wäöüÄÖÜß\d\-_,!.:; ]*/');
define('KEYWORDS_REGEX', '/[^\wäöüÄÖÜß\d_, \-]+/');
define('EMAIL_REGEX', '/^[A-Z0-9+_.-]+@[A-Z0-9.-]+$/i');
define('NICK_REGEX', '/[^\wäöüÄÖÜß\d\-_ ]+/');
define('NICK_MAX_LENGTH', 30);
define('NICK_MIN_LENGTH', 3);
define('ICQ_MAX_LENGTH', 9);
define('EMAIL_MAX_LENGTH', 50);
define('SKYPE_MAX_LENGTH', 30);
define('PW_MIN_LENGTH', 6);
define('PW_MAX_LENGTH', 30);
define('PICS_MAX_SIZE', 5242880); // 5 MB
define('PICS_MIN_SIZE', 1);
define('FILES_MAX_SIZE', 10485760); // 10 MB
define('FILES_MIN_SIZE', 1);

// Beschränkungen (allgemein)
define('MAXNEWPAGES', 3);
define('ABK_REGEX_RAW', '[A-Za-z0-9_-]{3,15}');
define('ABK_REGEX', '/^'.ABK_REGEX_RAW.'$/');
define('FILE_REGEX', '/^[A-Za-z0-9_ ()-]+\.[A-Za-z]{2,4}$/');
define('DESIGN_REGEX', '/^[A-Za-z0-9_-]{3,15}$/');
define('COLOR_REGEX', '/^#[A-Fa-f0-9]{3,6}$/');
define('SECTION_MAX_LENGTH', 12);
define('SECTION_MIN_LENGTH', 2);
define('SECTION_REGEX', '/[^\wäöüÄÖÜß\d\-_]+/');
define('ADMIN_TITLE_MAX_LENGTH', 100);
define('ADMIN_TITLE_MIN_LENGTH', 3);
define('MAXUSER', 1000);

// Allgemein
define('TIME', time());
define('YEAR_MIN', 1940);
define('CURRENT_YEAR', date('Y', TIME));
define('CURRENT_MONTH', date('n', TIME));
define('CURRENT_HOUR', date('G', TIME));
define('CURRENT_MINUTES', date('i', TIME));
define('CURRENT_SECONDS', date('s', TIME));
define('MIN', 60);
define('HOUR', 3600);
define('DAY', 86400); // 24*60*60
define('FIVEDAYS', 432000); // DAY * 5

// Zeitbeschränkungen
define('PIC_LOAD_TIME', HOUR);
define('BLOCK_TIME_STD_MIN', 5);
define('BLOCK_TIME_STD_MAX', 7200); // 2*HOUR
define('BLOCK_TIME_LOGIN_MIN', 0);

?>