<?php

/*  Häufig benötigte Funktionen zur Ausgabe

- FatalError($reason)
- refresh($link, $refreshsec, $text)
- secondsToMidnight()
- onlyAdmin()
- pvar($var)

*/

/**
 * 
 * Grundsätzliche Fehlermeldungen
 * @param String $reason
 */
function FatalError($reason) {
	switch ($reason) {
		case 'missingDefaultConfig': $temp = 'Die Grundkonfiguration f&uuml;r diese Seite fehlt noch.'; break;
		case 'unvalidDefaultNav': $temp = 'Ihr Standardmen&uuml;punkt existiert nicht.'; break;
		case 'onlyAdmin': $temp = 'Funktion nur vom Adminpanel verwendbar.'; break;
		case 'missingErrorPicture': $temp = 'Das Fehlerbild fehlt auch. ;-)'; break;
		case 'missingTypeFile': $temp = 'Der gew&auml;hlte Typ existiert nicht.'; break;
		case 'paramError': $temp = 'Fehlende oder ungültige Parameter.'; break;
		case 'setupInvalid': $temp = 'Erstelle eine leere Datei ROOTPATH/files/SETUP_IBKS.php um das Setup auszuf&uuml;hren.'; break;
		default: $temp = 'Fehlermeldung nicht spezifiziert. ('.$reason.')';
	}
	die($temp);
}

/**
 * 
 * Gibt Meldungen aus und überschreibt direkt das Display
 * @param String $link
 * @param Integer $refreshsec
 * @param String $text
 */
function refresh($link, $refreshsec = 0, $text = '') {
	global $tpl, $cache, $message;
	/*if (!is_numeric($refreshsec)) {
		$link = $refreshsec;
		$refreshsec = 0;
	}*/
	if ($text == '') {
		if (Message::noError()) {
			$text = $message->success();
			if ($refreshsec == 0) $refreshsec = REF_SUCCESS;
		}
		else {
			$text = $message->error();
			if ($refreshsec == 0) $refreshsec = REF_ERROR;
		}
	}
	$tpl->assign('REDIRECT_TEXT', $text);
	$tpl->assign('REDIRECT_REFRESHSEC', $refreshsec);
	$tpl->assign('REDIRECT_LINK', $link);
	$cache->noCache('content', 'redirect.tpl');
}

/**
 * 
 * Berechnet die Sekunden bis Mitternacht 
 * (Hauptsächlich für Caching verwendet)
 */
function secondsToMidnight() {
	return DAY - CURRENT_HOUR*HOUR - CURRENT_MINUTES*MIN - CURRENT_SECONDS;
}

/**
 * 
 * überprüft ob die Funktion/Klasse von der Admin-Seite aus aufgerufen wurde
 */
function onlyAdmin() {
	if ((!defined('ABK') || ABK != 'admin') && 
		(substr($_SERVER['REQUEST_URI'],0,17) != '/INSTALL_IBKS.php')) 
		die(FatalError('onlyAdmin'));
}

/**
 * 
 * Gibt eine Variable aus
 * @param $var
 */
function pvar($var) {
	$print = "Pvar";
	echo "<table bgcolor=black cellspacing=1 cellpadding=0 width=80%><tr><td><table bgcolor=\"#999999\" width=100% cellspacing = 3><tr><td>";
	if (is_object($var)) {
		$var = get_object_vars($var);
	}
	if (is_array($var)) {
		echo "<li><b><span style=\"color:white\">$print:</span></b><br><ol type=1>";
		foreach ($var as $key => $value) {
			if (is_array($value)) {
				pvar($value,$key,1);
			}
			else {
				echo "<li><i><span style=\"color:white\">$key:</span></i><span style=\"color:green\">$value</span><br>";
			}
		}
		echo "</ol>";
	}
	else {
		echo "<b><span style=\"color:white\">$print: $var</span></b><br>";
	}
	echo "</td></tr></table></td></tr></table>";
}

?>