<?php

/**
 * 
 * Verwaltet einen User
 * @author Konstantin Grupp
 *
 */
class User {
	/**
	 * 
	 * Speichert ob das User-Objekt gültig ist
	 * @var Boolean
	 */
	private $is_valid;
	/**
	 * 
	 * Speichert die ID des Users
	 * @var Integer
	 */
	private $ID;
	/**
	 * 
	 * Speichert den Nick des Users
	 * @var String (Nick)
	 */
	private $Nick;
	/**
	 * 
	 */
	private static $idToNick = array();
	
	/**
	 * 
	 * Der Konstruktor für ein Objekt
	 * @param Integer $ID
	 * @param String $Nick
	 */
	public function __construct($ID = null, $Nick = null, $session = null, $alreadyProved = false) {
		$this->ID = addslashes($ID);
		$this->Nick = addslashes($Nick);
		if (!$alreadyProved) {
			if ($ID !== null) { $this->checkID($session); $this->Nick = null; }
			elseif ($Nick !== null) $this->checkNick($session);
		} else {
			$this->is_valid = true;
		}
	}
	/**
	 * 
	 * Überprüfen ob ein Benutzer existiert (und ob seine Session gültig ist)
	 */
	private function checkID($session) {
		if ($session !== null) {
			$session = addslashes(md5($session*($this->ID%7)));
			$sql = " AND currentSession = '".$session."' ";
		} else $sql = '';
		$temp = (is_numeric($this->ID) && ($this->ID > 0) && 
			MySQL::single("SELECT COUNT(*) FROM general_users WHERE ID = '".$this->ID."' AND ID != '".DUMMYID."' ".$sql));
		if (!$temp) { $this->ID = null; $this->is_valid = 0; }
		else $this->is_valid = true;
	}
	
	/**
	 * 
	 * Überprüft ob ein Nick schon verwendet wird
	 */
	private function checkNick($session) {
		$temp = (!preg_match(NICK_REGEX, $this->Nick) &&
			MySQL::single("SELECT COUNT(*) FROM general_users WHERE Nick = '".$this->Nick."' AND ID != '".DUMMYID."'"));
		if (!$temp) { $this->Nick = null; $this->is_valid = 0; }
		else $this->is_valid = true;	
	}
	
	/**
	 * 
	 * Key-Bedingung für WHERE
	 */
	private function condition() {
		return (($this->Nick != null) ? "u.Nick = '".$this->Nick."'" : "u.ID = '".$this->ID."'");
	}
	
	/**
	 * 
	 * Gibt zurück ob ein User-Objekt gültig ist, bzw. der Nick bereits verwendet wird
	 * @param Boolean $unvalidated
	 */
	public function validate() {
		return $this->is_valid;
	}
	
	/**
	 * 
	 */
	public function validateALL($nick) {
		return ($this->is_valid || MySQL::single("SELECT COUNT(*) FROM general_unvalid_accounts WHERE Nick = '".$nick."'"));
	}
	
	/**
	 * 
	 * Autor/User bestimmen
	 */
	public function getNick() {
		if (isset(User::$idToNick[$this->ID])) 
			return User::$idToNick[$this->ID]; 
		elseif (!$this->is_valid) 
			return '';
		elseif ($this->Nick == null) {
			$this->Nick = MySQL::single("SELECT Nick FROM general_users WHERE ID = '".$this->ID."'");
			User::$idToNick[$this->ID] = $this->Nick;
		}
		return $this->Nick;
	}
	
	/**
	 * 
	 * Die ID bestimmen
	 */
	public function getID() {
		if (!$this->is_valid) return DUMMYID;
		elseif ($this->ID == null)
			$this->ID = MySQL::single("SELECT ID FROM general_users WHERE Nick = '".$this->Nick."'");
		return $this->ID;
	}
	
	/**
	 * 
	 * Überprüft ob die Eingabe eines Passwortes korrekt war
	 * @param String $PW (unverschlüsselt)
	 * @param String $abk (ABK)
	 */
	public function validateLogin($PW, $abk = ABK, $withoutPage = false) {
		return ($this->is_valid && 
			MySQL::single("SELECT COUNT(*) FROM general_users AS u
					".(!$withoutPage ? 'JOIN general_users_pages AS p ON (u.ID = p.ID)' : '')." 
				WHERE ".$this->condition()." AND u.ID != '".DUMMYID."' AND 
					u.PW = '".md5($PW)."' ".(!$withoutPage ? "AND p.abk = '".$abk."'" : "")));
	}
	
	public function validatePagePermission($abk = ABK) {
		return ($this->is_valid &&
			MySQL::single("SELECT COUNT(*) FROM general_users_pages
				WHERE ID = '".$this->getID()."' AND ID != '".DUMMYID."' AND abk = '".$abk."'"));
	}
	
	/**
	 * 
	 * Führt einen gültigen Login durch
	 */
	public function login($pw) {
		if (!$this->validateLogin($pw))
			Message::$errorType = 'login_unvalid';	
		elseif (Message::noError()) {
			$id = $this->getID();
			$currentSession = TIME*$id;
			MySQL::query("UPDATE general_users
				SET currentSession = '".md5($currentSession * ($id % 7))."'
				WHERE ID = '".$id."'");
			if (Settings::is_profilActivated())
				MySQL::query("UPDATE ".ABK."_account 
					SET Letzter_Login = '".TIME."', 
						Aktivitaet = '".TIME."' 
					WHERE ID = '".$id."'");
			Session::set('login', $id);
			Session::set('log', $currentSession);
			Session::set('log_pages', array(ABK));
		}
	}
	
	/**
	 * 
	 * Überprüft die Gültigkeit einer Session
	 */
	public static function validateSession($abk = ABK) {
		if (Session::exists('log', 'login', 'log_pages') && 
			is_numeric(Session::get('login'))) {
			$id = Session::get('login'); $session = Session::get('log');
		} else {
			$id = 0; $session = '';
		}
		$user = new User($id, null, $session);
		// Falls es eine ungültige Session war direkt löschen
		if (!$user->validate()) Session::del('log', 'login');
		// überprüfen ob man mit der aktuellen Session auch auf der Seite angemeldet ist
		elseif ($user->validatePagePermission($abk)) {
			if (in_array($abk, Session::get('log_pages'))) $temp = '';
			else {
				$temp = ", Letzter_Login = '".TIME."'";
				array_push(Session::get('log_pages'), $abk);
			}
			if (Settings::is_profilActivated())
				MySQL::query("UPDATE ".$abk."_account SET Aktivitaet = '".TIME."' ".$temp." WHERE ID = '".$user->getID()."'");
		} else $user->is_valid = 0;
		if (!$user->validate()) {
			$user->Nick = '';
			$user->ID = 0;
		}
		return $user;
	}
	
	/**
	 * 
	 * Loggt einen User aus
	 */
	public function logout() {
		$this->is_valid = 0;
		Session::del('log', 'login', 'log_pages');
		//unset($_SESSION[SESSION.'_log'], $_SESSION[SESSION.'_login'], $_SESSION[SESSION.'_log_pages']);
		MySQL::query("UPDATE general_users SET currentSession = 'nicht mehr eingeloggt' 
			WHERE ID != '".DUMMYID."' AND ID = '".NICKID."'");
	}
	
	/**
	 * 
	 * EMail bestimmen
	 */
	public function getEMail() {
		return MySQL::single("SELECT u.EMail FROM general_users AS u WHERE ".$this->condition());
	}
	
	/**
	 * 
	 * Überprüft ob eine EMail-Adresse schon verwendet wird
	 * @param String $mail (EMail)
	 */
	public static function checkMail($mail) {
		return (MySQL::single("SELECT COUNT(*) FROM general_users WHERE EMail = '".addslashes($mail)."'") ||
				MySQL::single("SELECT COUNT(*) FROM general_unvalid_accounts WHERE Mail = '".addslashes($mail)."'"));
	}
	
	/**
	 * 
	 * Generiert ein neues Passwort
	 */
	public static function getGeneratePW() {
		$pool = "qwertzupasdfghkyxcvbnm23456789WERTZUPLKJHGFDSAYXCVBNM";
		srand ((double)microtime()*1000000);
		$PW = '';
		for($index = 0; $index < 8; $index++) {
		    $PW .= substr($pool,(rand()%(strlen ($pool))), 1);
		}
		return $PW;
	}
	
	/**
	 * 
	 * Gibt die Anzahl an User zurück
	 * @param String $abk (ABK)
	 */
	public static function getNumberOfUsers($abk = ABK) {
		return MySQL::single("SELECT COUNT(*) FROM general_users AS u 
				JOIN general_users_pages AS p ON (p.ID = u.ID) 
			WHERE p.abk = '".$abk."' AND u.ID != '".DUMMYID."'");
	}
	
	/**
	 * 
	 * Gibt ein Array mit den Seiten zurück bei denen man angemeldet ist
	 */
	public function getPages() {
		return MySQL::assocs("SELECT abk FROM general_users_pages WHERE ID = '". $this->getID()."'", 'abk');
	}
}

?>