<?php

/**
 * 
 * Verwaltet einen Termin
 * @author Konstantin Grupp
 *
 */
class Termin {
	
	/**
	 * 
	 * Speichert, ob das Terminobjekt eine gültige enthält
	 * @var Boolean
	 */
	private $terminID_checked = null;
	
	/**
	 * 
	 * Speichert die verwendete ABK zwischen
	 * @var String (ABK)
	 */
	private $abk;
	
	/**
	 * 
	 * Speichert die Daten zum Termin
	 * @var Array
	 */
	private $data = array('TerminID' => 0, 'Datum' => 0, 'AutorID' => 0, 'Status' => 0, 'ThreadID' => 0);
	
	/**
	 * 
	 * Übernimmt einen Termin
	 * @param Integer $TerminID
	 * @param Array $data
	 * @param String $abk (abk)
	 */
	public function __construct($TerminID, $data = array(), $abk = GENERAL_ABK) {
		$this->abk = $abk;
		if ($data != array()) $this->data = $data;
		if (($TerminID != null) && ($TerminID != 0) && (Termin::is_TerminID($TerminID))) {
			$this->terminID_checked = 1;
			$this->data = MySQL::assoc("SELECT * FROM ".$abk."_kalender_termine WHERE TerminID = '".$TerminID."'");
		}
	}
	
	/**
	 * 
	 * Gibt einen Key zurück
	 * @param String $key (Spalte)
	 */
	public function get($key) {
		return $this->data[$key];
	}
	
	/**
	 * 
	 * Ändert einen Wert eines Termins
	 * @param String $key (key)
	 * @param %a $value (key => %a)
	 */
	public function set($key, $value) {
		$this->data[$key] = $value;
	}
	
	/**
	 * 
	 * Gibt das Termin-Array zurück
	 */
	public function getALL() {
		return $this->data;
	}
	
	/**
	 * 
	 * Überprüft ob es eine gültige TerminID
	 * @param %a $TerminID
	 */
	public function is_TerminID($TerminID = null, $new = false) {
		if ($this->terminID_checked != null && !$new)
			return $this->terminID_checked; 
		if ($TerminID == null) $TerminID = $this->data['TerminID'];
		if ($TerminID == 0) return false;
		return is_numeric($TerminID) && MySQL::single("SELECT COUNT(*) FROM ".$this->abk."_kalender_termine 
			WHERE TerminID = '".addslashes($TerminID)."' AND Status != 1");
	}
	
	/**
	 * 
	 * Löscht den Termin
	 */
	public function del() {
		MySQL::query("UPDATE ".$this->abk."_kalender_termine SET Status = '1' WHERE TerminID = '".$this->data['TerminID']."'");
	}
	
	/**
	 * 
	 * Fügt den neuen Termin hinzu
	 */
	public function add() {
		if ($this->data['TerminID'] == null) {
			MySQL::insert("INSERT INTO ".$this->abk."_kalender_termine 
				(Datum, Timestamp, AutorID, Autor, Titel, Beschreibung, Status)
				VALUES ('".$this->data['Datum']."', '".TIME."', '".NICKID."', '".NICK."', 
					'".$this->data['Titel']."', '".$this->data['Beschreibung']."', '".$this->data['Status']."')");
		} elseif ($this->terminID_checked) {
			MySQL::query("UPDATE ".$this->abk."_kalender_termine 
						SET Datum = '".$this->data['Datum']."', 
							Titel = '".$this->data['Titel']."', 
							Beschreibung = '".$this->data['Beschreibung']."',
							ThreadID = '".$this->data['ThreadID']."'
						WHERE TerminID = '".$this->data['TerminID']."'");
		}
	}
	
	/**
	 * 
	 * Überprüft ob Termin öffentlich (status)
	 * @param Integer $Status
	 */
	public function is_public() {
		return ($this->data['Status'] == 0);
	}
	
	/**
	 * 
	 * Überprüft ob es erlaubt diesen Termin zu editieren
	 * @param Integer $TerminID
	 */
	public function getEditPermission() {
		if ($this->data['TerminID'] == 0) return false;
		return (($this->data['Status'] == 0) || 
				(($this->data['Status'] == 2) && ($this->data['AutorID'] == NickID)));
	}
	
	/**
	 * 
	 * Überprüft ob es erlaubt ist diesen Termin zu l�schen
	 * @param Integer $TerminID
	 */
	public function getDelPermission() {
		if ($this->data['TerminID'] == 0) return false;
		return (($this->data['Status'] == 0) || 
				(($this->data['Status'] == 2) && ($this->data['AutorID'] == NickID)));
	}
	
	public function getDiskussionStartPermission() {
		return ($this->is_TerminID()) && (($this->data['Status'] != 2) AND (Settings::get($this->abk, 'KalenderBoardID')));
	}
	
	public static function getDiskussionStartPermissionS($Status, $abk = ABK) {
		global $settings;
		return (($Status != 2) AND (Settings::get($abk, 'KalenderBoardID')));
	}
	
	

}

?>