<?php

/**
 * 
 * Funktionen rund um das SpecialPages-Modul (Eigene Seiten)
 * @author Konstantin Grupp
 *
 */
class SpecialPage {

	/**
	 * 
	 */
	const TITLE_LENGTH = 100;
	/**
	 * 
	 * Linkname mit dem die Seite aufgerufen wird
	 * @var String
	 */
	private $section;
	/**
	 * 
	 * Gibt an zu welcher Rechteebene diese Seite gehören soll
	 * @var String
	 */
	private $abk;
	/**
	 * 
	 * erstellt ein eigene Seite Objekt
	 * @param String $section
	 * @param String $abk
	 */
	public function __construct($section, $abk = ABK) {
		$this->section = addslashes($section);
		$this->abk = $abk;
	}
	
	
	/**
	 * 
	 * Gibt zurück ob die Seite aufgerufen werden darf
	 */
	public function showPermission() {
		return MySQL::single("SELECT COUNT(*) FROM general_specialpages 
			WHERE (abk = '".$this->abk."' OR abk = 'general') AND section = '".$this->section."'");
	}
	
	/**
	 * 
	 * Generiert die Standardausgabe
	 */
	public function output() {
		
		if ($this->showPermission()) {
			global $cache;
			if (!$cache->isCached('content', 'all_specialpages.tpl', $this->abk.'|'.$_GET['section'], secondsToMidnight())) {
				
				$specialpage = MySQL::assoc("SELECT Titel, Time, Inhalt FROM general_specialpages 
					WHERE section = '".$this->section."'");
				global $BBC, $tpl;
				$tpl->assign('PAGE_TITEL', $BBC->ausgabe($specialpage['Titel'], false));
				$tpl->assign('PAGE_INHALT', $BBC->ausgabe($specialpage['Inhalt'], 'advanced'));
				$tpl->assign('PAGE_TIME', $specialpage['Time']);
			}
		}
		else {
			Message::$errorType = 'sp_NotExists';
			refresh(MAIN);
		}

	}
	
	/*
	 * Adminfunktionen
	 */
	
	/**
	 * 
	 * gibt alle SpecialPages zurück
	 * @param String $abk
	 */
	public static function getAllPages($abk = ABK) {
		global $BBC;
		$temp = MySQL::assocs("SELECT * FROM general_specialpages WHERE abk = '".$abk."'");
		$temp_output = array();
		foreach($temp as $vl) {
			$vl['Titel'] = $BBC->ausgabe($vl['Titel'], false);
			array_push($temp_output, $vl);
		}
		return $temp_output;
	}
	
	/**
	 * 
	 * überprüft ob eine Seite existiert
	 */
	public function pageExists() {
		return MySQL::single("SELECT COUNT(*) FROM general_specialpages 
			WHERE abk = '".$this->abk."' AND section = '".$this->section."'");
	}
	
	/**
	 * 
	 * gibt eine SpecialPage zurück
	 */
	public function getPage() {
		global $BBC;
		$temp = MySQL::assoc("SELECT * FROM general_specialpages 
			WHERE abk = '".$this->abk."' AND section = '".$this->section."'");
		$temp['Titel'] = $BBC->ausgabe($temp['Titel'], false);
		$temp['Inhalt'] = $BBC->ausgabe($temp['Inhalt'], false);
		return $temp;
	}
	
	/**
	 * 
	 * Ändert/Erstellt eine SpecialPage
	 * @param String $type (new, edit)
	 * @param String $Titel
	 * @param String $Inhalt
	 */
	public function set($type, $Titel, $Inhalt) {
		global $BBC, $cache;
		onlyAdmin();
		$section = $this->section;
		
		$Titel = Admin::validate('title', $Titel, 'sp');
		$Inhalt = BBC::validate('BBC-advanced', $Inhalt, 'sp');
		if ($type == 'new') {
			// section
			$section = Admin::validate('section', $section, 'sp');
			if (Admin::validNavType($section))
				Message::$errorType = 'sp_section_Locked';
			if (Admin::validNavSectionSP($section, $this->abk))
				Message::$errorType = 'sp_section_AlreadyUsed';
			if (Message::noError()) {
				MySQL::insert("INSERT INTO general_specialpages
				(abk, section, Titel, Time, Inhalt)
				VALUES ('".$this->abk."', '".$this->section."', '".$Titel."', '".TIME."', '".$Inhalt."')");
				Message::$successType = 'sp_new';
			}
		} elseif ($type == 'edit') {
			if (Message::noError()) {
			if ($this->abk == 'general') {
					$cache->clearCache('all_specialpages.tpl');
				} else {
					$cache->clearCache('all_specialpages.tpl', $this->abk.'|'.$section);
				}
				
				MySQL::query("UPDATE general_specialpages SET
					Titel = '".$Titel."',
					Time = '".TIME."',
					Inhalt = '".$Inhalt."'
					WHERE abk =  '".$this->abk."' AND section = '".$this->section."'");
				Message::$successType = 'sp_edit';
			}
		}
		
	}
	
	/**
	 * 
	 * Löscht eine SpecialPage
	 */
	public function delete() {
		global $cache;
		onlyAdmin();
		if ($this->pageExists()) {
			$cache->clearCache('all_specialpages.tpl', $this->abk.'|'.$this->section);
			MySQL::query("DELETE FROM general_specialpages 
				WHERE abk = '".$this->abk."' AND section = '".$this->section."'");
			Message::$successType = 'sp_del';
		} else Message::$errorType = 'sp_deleteNotOwn';
	}

}


?>