<?php

onlyAdmin();

/**
 * 
 * Klasse mit Setupfunktionen
 * @author Konstantin Grupp
 *
 */
class Setup {
	
	private static $error_count = 0;
	
	/**
	 * 
	 * Generiert eine Datei für eine Seite
	 */
	public static function generateNewPageFile($abk, $publicPath = PUBLICPATH, $rootPath = ROOTPATH) {
		Setup::createFile($publicPath.$abk.'.php', "<?php \n".
		"define('ABK', '".$abk."');\n".
		"define('ROOTPATH', '".$rootPath."');\n" .
		"include ROOTPATH.'files/inc/general.php';
		?>");
	}
	
	public static function setupAll() {
		if (!is_file(ROOTPATH.'files/SETUP_IBKS')) {
			FatalError('setupInvalid'); die();
		}
		$abks = MySQL::assocs("SELECT abk FROM general_settings");
		
		foreach($abks as $vl) {
			Setup::generateNewPageFile($vl['abk'], PUBLICPATH, ROOTPATH);
		}
		
		$tools = array('getDesign', 'getFile', 'getIMG');
		foreach($tools as $tool) {
			$file = PUBLICPATH.'tools/'.$tool.'.php';
			
			Setup::createFile($file, "<?php \n".
			"define('TOOLTYPE', '".$tool."');\n".
			"define('ROOTPATH', '".ROOTPATH."');\n".
			"include ROOTPATH.'files/inc/general_tools.php';
			?>");
		}
		
		try {
    		rename(ROOTPATH.'files/SETUP_IBKS', ROOTPATH.'files/SETUP_IBKS_DONE');
		} catch (Exception $e) {
			Setup::$error_count++;
    		echo 'FEHLER: ',  $e->getMessage(), "<br>\n";
		}
		
		if (Setup::$error_count) {
			echo "Das Setup wurde mit ".Setup::$error_count." Fehlern abgeschlossen.";
		} else {
			echo "Setup erfolgreich ausgef&uuml;hrt!";
		}
	}
	
	private static function createFile($file, $content) {
		try {
    		if (is_file($file)) {
				unlink($file);
			}
			
			$fileHandler = fopen($file, 'w');
			fwrite($fileHandler, $content);
			fclose($fileHandler);
			unset($fileHandler);
		} catch (Exception $e) {
			Setup::$error_count++;
    		echo 'FEHLER: ',  $e->getMessage(), "<br>\n";
		}
		
	}
	
}

?>