<?php

/**
 * 
 * Diese Klasse verwaltet die Einstellungen einer Seite
 * @author Konstantin Grupp
 *
 */
class Settings {
	
	/**
	 * 
	 * Zwischenspeicher für die Einstellungen
	 * @var Array
	 */
	private static $data = array();
	
	/**
	 * 
	 * Speichert welche Tabellen existieren
	 * @var Boolean
	 */
	private static $exists = array();
	
	public static function add($abk = ABK, $directLoad = false) {
		Settings::$data[$abk] = array();
		if ($directLoad) {
			Settings::getData($abk);
			if (!Settings::$data) {
				FatalError('missingDefaultConfig');
			}
		}
	}
	
	private static function getData($abk) {
		Settings::$data[$abk] = MySQL::assoc("SELECT * FROM general_settings WHERE abk = '".$abk."'");
	}
	
	/**
	 * 
	 * Gibt anhand eines Keys den Wert zurück
	 * @param String $field (Key)
	 */
	public static function get($abk, $field) {
		if (!isset(Settings::$data[$abk]))
			Settings::getData($abk);
		return Settings::$data[$abk][$field];
	}
	
	public static function getALL($abk) {
		if (!isset(Settings::$data[$abk]))
			Settings::getData($abk);
		return Settings::$data[$abk];
	}
	
	/**
	 * 
	 * Ändert ein Feld anhand des Keys
	 * @param String $field (Key)
	 */
	public static function set($abk, $field, $type, $value) {
		onlyAdmin();
		Settings::$data[$abk][$field] = BBC::validate($type, $value);
	}
	
	/**
	 * 
	 * Gibt zurück ob das Profil aktiviert ist
	 */
	public static function is_profilActivated($abk = ABK) {
		if (!isset(Settings::$exists[$abk]['account'])) 
			Settings::$exists[$abk]['account'] = MySQL::tableExists($abk.'_account');  
		return Settings::$exists[$abk]['account'];
	}
	
	public static function is_KalenderActivated($abk = ABK) {
		if (!isset(Settings::$exists[$abk]['kalender_termine'])) 
			Settings::$exists[$abk]['kalender_termine'] = MySQL::tableExists($abk.'_kalender_termine');  
		return Settings::$exists[$abk]['kalender_termine'];
	}
	
	public static function is_ForumActivated($abk = ABK) {
		if (!isset(Settings::$exists[$abk]['forum_board'])) 
			Settings::$exists[$abk]['forum_board'] = MySQL::tableExists($abk.'_forum_board');  
		return Settings::$exists[$abk]['forum_board'];
	}
	
	public static function is_GaestebuchActivated($abk = ABK) {
		if (!isset(Settings::$exists[$abk]['gaestebuch'])) 
			Settings::$exists[$abk]['gaestebuch'] = MySQL::tableExists($abk.'_gaestebuch');  
		return Settings::$exists[$abk]['gaestebuch'];
	}
	
	/**
	 * 
	 * Gibt zurück ob die der Kalender mit dem Forum verknüpft ist
	 */
	public static function is_kalenderBoardConnected($abk) {
		return Settings::get($abk, 'KalenderBoardID');
	}
	
	/**
	 * 
	 * Überprüft ob eine Abkürzung bereits verwendet wird
	 * @param String $abk
	 */
	public static function is_abk($abk = ABK) {
		if (!isset(Settings::$exists[$abk]['abk'])) 
			Settings::$exists[$abk]['abk'] = 
				MySQL::single("SELECT COUNT(*) FROM general_settings WHERE abk = '".addslashes($abk)."'");
		return Settings::$exists[$abk]['abk'];
	}
	
}