<?php

class Session {
	
	public function __construct() {
		session_start();
	}
	
	public function __destruct() {
		session_write_close();
	}
	
	public static function exists() {
		if (func_num_args() > 0) {
			$toCheck = func_get_args();
		}
		foreach($toCheck as $vl) {
			if (!isset($_SESSION[SESSION.'_'.$vl])) return false;
		}
		return true;
	}
	
	public static function get($field) {
		return $_SESSION[SESSION.'_'.$field];
	}
	
	public static function set($field, $value) {
		$_SESSION[SESSION.'_'.$field] = $value;
	}
	
	public static function del($field) {
		if (func_num_args() > 0) {
			$toCheck = func_get_args();
		}
		foreach($toCheck as $vl) {
			$_SESSION[SESSION.'_'.$vl] = '';
			unset($_SESSION[SESSION.'_'.$vl]);
		}
	}
	
	public static function delALL() {
		foreach ($_SESSION as $ky => $vl) {
			$_SESSION[$ky] = '';
			unset($_SESSION[$ky]);
		}
		unset($_SESSION);
	}
	
}

?>