<?php 

/**
 * 
 * Zum Blättern durch längere Ausgaben
 * @author Konstantin Grupp
 *
 */
class Pages {
	
	/**
	 * 
	 * Speichert wie viel Einträge gespeichert werden
	 * @var Integer
	 */
	private $eintragProSeite;
	/**
	 * 
	 * Speichert die aktuelle Seite
	 * @var Integer
	 */
	private $page;
	
	/**
	 * 
	 * Erstellt ein Seiten-Objekt
	 * @param Integer $eintragProSeite
	 * @param Integer $page
	 */
	public function __construct($eintragProSeite = 10, $page = null) {
		if ($page == null) {
			if ((!isset($_GET['page'])) ||
				(!is_numeric($_GET['page'])) ||
				($_GET['page'] < 0)) 
				$this->page = 0;
			else $this->page = $_GET['page'];
		} else {
			$this->page = $page;
		}
		$this->eintragProSeite = $eintragProSeite;
	}
	
	/**
	 * 
	 * Gibt die aktuelle Seite zurück
	 */
	public function getPage() {
		return $this->page;
	}
	
	/**
	 * 
	 * Bestimmt die Limitierung für SQL-Queries
	 */
	public function limit() {
		$abeintrag = ($this->page * $this->eintragProSeite);
		return " LIMIT ".$abeintrag.", ".$this->eintragProSeite;
	}
	
	public function limitAry() {
		return ($this->page * $this->eintragProSeite);
	}
	
	/**
	 * 
	 * Für die Blatternausgabe
	 * @param String $link
	 * @param Integer $page
	 * @param Integer $name
	 */
	private function ausgabe_link($link, $page, $name = null) {
		if ($name == null) $name = $page;
		return array('link' => $link, 'page' => $page, 'name' => $name);
	}
	
	/**
	 * 
	 * Erstellt die Ausgabe aus
	 * @param String $link
	 * @param String $sql_limitless
	 * @param Integer $spalten
	 */
	public function ausgabe($link, $sql_limitless, $anzahl = null) {
		global $tpl; 
		$tpl->assign('BLAETTERN', false);
		// Blaettern
		$current = $this->page;
		if ($sql_limitless != '')
			$anzahl = MySQL::countRows($sql_limitless);
		// Prüfen ob die Seitenzahl nicht zu hoch ist
		if (($current * $this->eintragProSeite) > $anzahl) {
			Message::$errorType = 'blaettern_page_unvalid';
			refresh((defined(THIS) ? THIS : MAIN));
		} else {
			$first = 0;
			$last = ceil($anzahl / $this->eintragProSeite) -1;
			if ($this->eintragProSeite < $anzahl) {
				$tpl->assign('BLAETTERN', true);
				$arr = array();
				if ($first < $current -3) $arr[] = $this->ausgabe_link($link, $first, "erste ...");
				if ($first < $current -20) $arr[] = $this->ausgabe_link($link, $current - 20, ($current - 20)." ...");
				if ($first < $current -10) $arr[] = $this->ausgabe_link($link, $current - 10, ($current - 10)." ...");
				if ($first <= $current -3) $arr[] = $this->ausgabe_link($link, $current - 3);
				if ($first <= $current -2) $arr[] = $this->ausgabe_link($link, $current - 2);
				if ($first <= $current -1) $arr[] = $this->ausgabe_link($link, $current - 1, ($current - 1)." <small>vorherige</small>");
				array_push($arr, array('name' => $current, 'link' => ''));
				if ($current + 1 <= $last) $arr[] = $this->ausgabe_link($link, $current + 1, "<small>n&auml;chste</small> ".($current + 1));
				if ($current + 2 <= $last) $arr[] = $this->ausgabe_link($link, $current + 2);
				if ($current + 3 <= $last) $arr[] = $this->ausgabe_link($link, $current + 3);
				if ($current + 10 < $last) $arr[] = $this->ausgabe_link($link, $current + 10, " ...".($current + 10));
				if ($current + 20 < $last) $arr[] = $this->ausgabe_link($link, $current + 20, " ...".($current + 20));
				if ($current + 3 < $last) $arr[] = $this->ausgabe_link($link, $last, "... letzte");
				$tpl->assign('BLAETTERN_LINKS', $arr);
			}
		}	
	}
	
	/*
	 * spezifische Funktionen
	 */
	
	public function getPage_Threads($ThreadID, $PostID, $abk = GENERAL_ABK) {
		$count = MySQL::single("SELECT COUNT(*) FROM ".$abk."_forum_post WHERE ( ThreadID = '".$ThreadID."' AND PostID < '".$PostID."')");
		$this->page = floor($count / $this->eintragProSeite);
	}
	
	public function getPage_User($UserID, $abk = ABK) {
		$count = MySQL::single("SELECT COUNT(*) FROM ".$abk."_account WHERE (ID > '".$UserID."')");
		$this->page = floor($count / $this->eintragProSeite);
	}
	
	public function getPage_Gaestebuch($PostID, $abk = ABK) {
		$count = MySQL::single("SELECT COUNT(*) FROM ".$abk."_gaestebuch WHERE (PostID > '".$PostID."')");
		$this->page = floor($count / $this->eintragProSeite);
	}
	
	public function getPage_Kalender($TerminID, $abk = ABK) {
		$count = MySQL::single("SELECT COUNT(*) FROM ".$abk."_kalender_termine WHERE (TerminID > '".$TerminID."')");
		$this->page = floor($count / $this->eintragProSeite);
	}
	
}

?>