<?php

/**
 * 
 * Jegliche Ausgabe von Text vorallem Fehler und Erfolgmeldungen laufen über diese Klasse
 * @author Konstantin Grupp
 *
 */
class Message {

	/**
	 * 
	 * gibt die Sprache an
	 * @var String
	 */
	private $language;
	/**
	 * 
	 * Speichert den Fehlertyp
	 * @var String
	 */
	public static $errorType = '';
	/**
	 * 
	 * Speichert den Erfolgstyp
	 * @var String
	 */
	public static $successType = '';
	/**
	 * 
	 * gibt an welche Typen ausgelesen werden sollen
	 * @var Array
	 */
	private $types;
	/**
	 * 
	 * Speichert die Wochentage
	 * @param String
	 */
	private $weekday = array(0 => 'den Wochentag gibt es nicht',
		1 => 'Montag', 2 => 'Dienstag', 3 => 'Mittwoch', 4 => 'Donnerstag', 
		5 => 'Freitag', 6 => '<b>Samstag</b>', 7 => '<b>Sonntag</b>');
	/**
	 * 
	 * Speichert die Monatsnamen
	 * @var String
	 */
	private $monthname = array(0 => 'den Monat gibt es nicht',
		1 => 'Januar', 2 => 'Februar', 3 => 'M&auml;rz', 4 => 'April', 5 => 'Mai', 6 => 'Juni',
		7 => 'Juli', 8 => 'August', 9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Dezember');
		
	/**
	 * 
	 * Erstellt ein Message-Objekt
	 */
	public function __construct($language) {
		$this->types = array();
		$this->language = $language;
	}
	
	/**
	 * 
	 * überprüft ob ein Fehler aufgetreten ist
	 */
	public static function noError() {
		return Message::$errorType == '';
	}
	
	/**
	 * 
	 * Holt die Message aus der Datenbank
	 * @param String $message_type
	 * @param String $type
	 * @param String $section
	 */
	private function getMessage($message_type, $type) {
		$message = MySQL::single("SELECT message FROM general_message WHERE 
				lang = '".$this->language."' AND 
				message_type = '".$message_type."' AND 
				type = '".$type."'");
		if (!$message) {
			switch($message_type) {
				case 'error': return 'Fehlermeldung nicht spezifiziert. ('.$this->language.', error, '.$type.')';
				case 'success': return 'Erfolgsmeldung nicht spezifiziert. ('.$this->language.', success, '.$type.')';
				case 'info': return 'Infomeldung nicht spezifiziert. ('.$this->language.', info, '.$type.')';
				default: return 'Messagetyp nicht spezifiziert. ('.$message_type.', '.$type.')';
			}
		}
		else return $message.(DEV ? '('.$this->language.', '.$message_type.', '.$type.')' : '');
	}
	
	/**
	 * 
	 * Fehlermeldungen laufen hierrüber
	 * @param String $type: übergibt den Fehlertyp
	 * @param String $section: übergibt den Seitentyp
	 */
	public function error($type = null) {
		if ($type == null) $type = Message::$errorType; 
		return $this->getMessage('error', $type);
	}
	
	/**
	 * 
	 * Erfolgsmeldungen laufen hierrüber
	 * @param String $type: übergibt den Erfolgstyp
	 * @param String $section: übergibt den Seitentyp
	 */
	public function success($type = null) {
		if ($type == null) $type = Message::$successType;
		return $this->getMessage('success', $type);
	}
	
	/**
	 * 
	 * Infomeldungen laufen hierrüber
	 * @param String $type: übergibt den Infotyp
	 * @param String $section: übergibt den Seitentyp
	 */
	public function info($type, array $data) {
		global $BBC;
		$temp = $this->getMessage('info', $type);
		if (!isset($data['[br]'])) $data['[br]'] = "\n";
		foreach($data as $ky => $vl) {
			$temp = str_replace($ky, $vl, $temp);
		}
		return $temp;
	}
	
	/**
	 * 
	 * Fügt einen zusätzlichen Typ hinzu der ausgelesen wird
	 * @param String $type
	 */
	public function addTxt($type) {
		if (!in_array($type, $this->types))
			$this->types[] = $type;
	}
	
	/**
	 * 
	 * die zusützlichen Typen
	 */
	public function assignTxt() {
		global $tpl;
		/*
		$temp = '';
		foreach ($this->types as $vl) {
			$temp .= ($temp == '' ? '' : ', ').$vl; 
		} */
		
		// TODO
		
		$txt = MySQL::assocs("SELECT * FROM general_message_txt WHERE 
			lang = '".$this->language."' AND
			type IN '".implode(', ', $this->types)."'");
		
		$tpl->assign('TXT', $txt);
	}
	
	/**
	 * 
	 * Gibt den Wochentag aus
	 * @param $time
	 */
	function str_wochentage($time) {
		if ( ($time < 1) or (7 < $time) ) $wochentag = date('N',$time);
		else $wochentag = $time;
		return $this->weekday[$wochentag];
	}
	
	/**
	 * 
	 * Gibt den Monatstag aus
	 * @param $time
	 */
	function str_monat($time) {
		if ( ($time < 1) or (12 < $time) ) $monat = date('n',$time);
		else $monat = $time;
		return $this->monthname[$monat];
	}

}

?>