<?php

/**
 * 
 * Funktionen zum Mails verschicken
 * @author Konstantin Grupp
 *
 */
class Mail {
	
	/**
	 * 
	 * Der Footer der ans Ende jeder generierten EMail angefügt wird
	 */
	private static function getFooter() {
		global $message;
		return $message->info('mail_footer', 
			array('[br]' => "<br>\n", '[link]' => WWW.MAIN, '[currentPage]' => Settings::get(ABK, 'title')));
	}
	
	/**
	 * 
	 * Versendet einzelne EMails
	 * @param String $mail
	 * @param String $absender
	 * @param String $betreff
	 * @param String $text
	 */
	private static function email_verschicken_spezific($mail,$betreff,$text) {
		if (DEV) {
			echo $betreff.': '.$text."<br>\n";
		} else {
			$header  = 'from: '.Settings::get(ABK, 'title').' <'.Settings::get(ABK, 'absender').">\n";
			$header .= 'reply-to: koni-g@web.de'."\n";
			$header .= 'x-mailer: PHP/'.phpversion()."\n";
			//$header .= 'Bcc: konstantin.grupp@lai.de'."\n";
			$header .= 'Content-type: text/html; charset=utf-8'."\n";
			mail($mail, $betreff, $text, $header);
		}
	}

	/**
	 * 
	 * Versendet an einen einzelnen User eine EMail
	 * @param String $type (EMail-Typ)
	 * @param Array $data (für EMail-Text)
	 * @param Integer $UserID
	 * @param Array $newUser
	 */
	public static function email_verschicken($type, $data = array(), User $user, $newUser = array()) {
		global $message;
		$data['[br]'] = "<br>\n";
		$betreff = Settings::get(ABK, 'title')." - ".$message->info('mail_'.$type, $data);
		$text = $message->info('mail_'.$type.'_txt', $data).Mail::getFooter();
		if ($user->validate()) {
			$Nick = $user->getNick();
			$EMail = $user->getEMail();
		} else {
			$Nick = $newUser['nick'];
			$EMail = $newUser['mail'];
		}
  		Mail::email_verschicken_spezific($EMail, $betreff, "Hallo ".$Nick."<br>\n<br>\n".$text);
	}

	/**
	 * 
	 * Versendet an alle die die Benachrichtigung aktiviert haben eine EMail
	 * @param String $betreff
	 * @param String $text
	 */
	public static function email_verschicken_alle($type, array $data = array()) {
		if (Settings::is_profilActivated()) {
			global $message;
			$data['[br]'] = "<br>\n";
			$betreff = $message->info('mail_'.$type, $data);
			$text = $message->info('mail_'.$type.'_txt', $data).Mail::getFooter();
			$mailing = MySQL::assocs("SELECT p.ID, u.EMail, u.Nick FROM general_users_pages AS p 
					JOIN general_users AS u ON (u.ID = p.ID)
					JOIN ".ABK."_account AS a ON (a.ID = p.ID)
				WHERE p.abk = '".ABK."' AND a.Benachrichtigung = '1'");
			foreach($mailing as $vl) {
				if (($vl['ID'] != NICKID) OR ($vl['EMail'] == '')) // An einen selbst werden keine versendet
					Mail::email_verschicken_spezific($vl['EMail'], 
						$betreff, "Hallo ".$vl['Nick'].$data['[br]'].$data['[br]'].$text);
			}
		}
	}
	
}

?>