<?php

class Forum {
	
	private $abk;
	public $BoardID = 0;
	public $ThreadID = 0;
	public $PostID = 0;
	public $termin = null;
	
	/**
	 * 
	 * Der Konstruktor für ein Forumsobjekt
	 * @param String $abk (ABK)
	 * @param String $type (request, PostID, ThreadID, BoardID)
	 * @param Integer $data (abhänfig von $type)
	 */
	public function __construct($abk = GENERAL_ABK, $type = 'request', $data = null) {
		$this->abk = $abk;
		switch ($type) {
			case 'PostID': $this->PostID = $data; break;
			case 'ThreadID': $this->ThreadID = $data; break;
			case 'BoardID': $this->BoardID = $data; break;
		}
		
		// PostID überprüfen
		if (!$this->PostID && isset($_GET['PostID']) && is_numeric($_GET['PostID'])) 
			$this->PostID = $_GET['PostID'];
		
		// ThreadID überprüfen
		if (!$this->validatePostID(true)) {
			if (!$this->ThreadID && isset($_GET['ThreadID']) && is_numeric($_GET['ThreadID']))
				$this->ThreadID = $_GET['ThreadID'];
		}
		else $this->ThreadID = MySQL::single("SELECT ThreadID FROM ".$this->abk."_forum_post WHERE PostID = '".$this->PostID."'");
	
		// BoardID überprüfen
		if (!$this->validateThreadID(true)) {
			if (isset($_GET['BoardID']) && is_numeric($_GET['BoardID']))
				$this->BoardID = $_GET['BoardID'];
		}
		else $this->BoardID = MySQL::single("SELECT BoardID FROM ".$this->abk."_forum_thread WHERE ThreadID = '".$this->ThreadID."'");
		$this->validateBoardID(true);
		
		// Bei aktiviertem Kalender die richtige BoardID wählen
		if (isset($_GET['TerminID']) && is_numeric($_GET['TerminID'])) {
			$this->termin = new Termin($_GET['TerminID'], null, $this->abk);
			$this->BoardID = Settings::get($this->abk, 'KalenderBoardID');
			$this->validateBoardID(true);
		}
	}
		
	public function validatePostID($checkDB = false) {
		if ($checkDB && is_numeric($this->PostID) && ($this->PostID > 0) &&
			!MySQL::single("SELECT COUNT(*) FROM ".$this->abk."_forum_post WHERE PostID = '".$this->PostID."'"))
			$this->PostID = 0;
		return ($this->PostID != 0);
	}
	public function validateThreadID($checkDB = false) {
		if ($checkDB && is_numeric($this->ThreadID) && ($this->ThreadID > 0) &&
			!MySQL::single("SELECT COUNT(*) FROM ".$this->abk."_forum_thread WHERE ThreadID = '".$this->ThreadID."'"))
			$this->ThreadID = 0;
		return ($this->ThreadID != 0);
	}
	public function validateBoardID($checkDB = false) {
		if ($checkDB && is_numeric($this->BoardID) && ($this->BoardID > 0) && 
			!MySQL::single("SELECT COUNT(*) FROM ".$this->abk."_forum_board WHERE BoardID = '".$this->BoardID."'"))
			$this->BoardID = 0;
		return ($this->BoardID != 0);
	}
	
	public function addThread($thema, $beitrag, $nick = NICK, $nickID = NICKID) {
		$thema = BBC::validate('name', $thema, 'board_thread');
		if (Message::noError()) {
			// Thema einfügen	
			$this->ThreadID = MySQL::insert("INSERT INTO ".$this->abk."_forum_thread(BoardID, Thema, Autor, AutorID, LastPostID, Posts)
				VALUES ('".$this->BoardID."', '".$thema."', '".$nick."', '".$nickID."', '0', '0')");
			$this->BoardCounter(1, 0);
			$this->addPost($beitrag);
			if (!GENERAL_MOD && $this->is_Termin()) {
				if ($this->termin->is_TerminID()) {
					$this->termin->set('ThreadID', $this->ThreadID);
					$this->termin->add();
				}
			}
		}
	}
	
	public function addPost($beitrag, $nick = NICK, $nickID = NICKID) {
		$beitrag = BBC::validate('BBC', $beitrag, 'board_post');
		if (Message::noError()) {
			$this->PostID = MySQL::insert("INSERT INTO ".$this->abk."_forum_post(ThreadID, Autor, AutorID, Time, Inhalt)
				VALUES ('".$this->ThreadID."', '".$nick."', 
					'".$nickID."', '".TIME."', '".$beitrag."')");
			// PostID in Thread nachtragen
			MySQL::query("UPDATE ".$this->abk."_forum_thread SET LastPostID = '".$this->PostID."' WHERE ThreadID = '".$this->ThreadID."'");
			// Board-Tabelle + Thread-Tabelle Aktualisieren
			
			$this->BoardCounter(0, 1);
			$this->ThreadCounter(1);
			$this->userPostCounter(1); // Postcounter um 1 erhöhen
		}
	}
	
	public function editPost($beitrag, $nick = NICK) {
		global $message;
		$beitrag = BBC::validate('BBC', $beitrag."\n\n".
			$message->info('board_post_editMark', array('[nick]' => $nick, '[date]' => date('d. M Y H:i',TIME))), 'board_post');
		if (Message::noError()) {
			MySQL::query("UPDATE ".$this->abk."_forum_post SET Inhalt = '".$beitrag."' WHERE PostID = '".$this->PostID."'");
		}
	}
	
	public function editThread($thema) {
		$thema = BBC::validate('name', $thema, 'board_thread');
		if (Message::noError()) {
			MySQL::query("UPDATE ".$this->abk."_forum_thread SET Thema = '".$thema."' WHERE ThreadID = '".$this->ThreadID."'");
		}
	}
	
	public function delPost() {
		if ($this->countPostsInThread() <= 1) {
			$this->delThread();
		} else {
			// Eintrag löschen
			MySQL::query("DELETE FROM ".$this->abk."_forum_post WHERE PostID = '".$this->PostID."'");
			$this->PostID = $this->getNewLastPostThread();
			// PostID aktualisieren
			$this->ThreadCounter(-1, $this->PostID);
			$this->BoardCounter(0, -1, $this->getNewLastPostBoard());
			$this->userPostCounter(-1); // Postcounter um 1 veringern
		}
	}
	
	public function delThread() {
		$posts = $this->countPostsInThread();
		MySQL::query("DELETE FROM ".$this->abk."_forum_post WHERE ThreadID = '".$this->ThreadID."'");
		// Falls kein Eintrag mehr im Thema, auch das Thema löschen
		MySQL::query("DELETE FROM ".$this->abk."_forum_thread WHERE ThreadID = '".$this->ThreadID."'");
		// Board aktualisieren
		$this->BoardCounter(-1, -$posts, $this->getNewLastPostBoard());
		$this->ThreadID = 0; $this->PostID = 0;
		// TODO aktualisiere User Counter
	}
	
	public function is_Termin() {
		return $this->termin != null;
	}
	
	/**
	 * 
	 * Überprüft ob es erlaubt ist für den User einen Beitrag zu editieren
	 */
	public function validateEditPermission() {
		return $this->validatePostID() && MySQL::single("SELECT COUNT(*) FROM ".$this->abk."_forum_post 
			WHERE (PostID = '".$this->PostID."' AND AutorID = '".NICKID."')");
	}
	/**
	 * 
	 * Überprüft ob es erlaubt ist für den User einen Beitrag zu löschen
	 */
	public function validateDelPermission() {
		return $this->validatePostID() && MySQL::single("SELECT COUNT(*) FROM ".$this->abk."_forum_post 
			WHERE (PostID = '".$this->PostID."' AND AutorID = '".NICKID."' AND Time > '".(TIME-DAY)."')");
	}
	
	public function userPostCounter($number) {
		if (Settings::is_profilActivated($this->abk)) {
			$sql = ($number < 0 ? $number : '+ '.$number);
			MySQL::query("UPDATE ".$this->abk."_account SET ForumPostCounter = ForumPostCounter ".$sql." WHERE ID = '".NICKID."'");
		}
	}
	
	public function BoardCounter($threads, $posts) {
		$sql1 = ($threads < 0 ? '- '.(-1*$threads) : '+ '.$threads);
		$sql2 = ($posts < 0 ? '- '.(-1*$posts) : '+ '.$posts);
		MySQL::query("UPDATE ".$this->abk."_forum_board 
			SET Threads = Threads ".$sql1.",
				Posts = Posts ".$sql2.",
				LastPostID = '".$this->PostID."'
			WHERE BoardID = '".$this->BoardID."'");
	}
	public function ThreadCounter($posts) {
		$sql2 = ($posts < 0 ? '- '.(-1*$posts) : '+ '.$posts);
		MySQL::query("UPDATE ".$this->abk."_forum_thread 
			SET Posts = Posts ".$sql2.",
				LastPostID = '".$this->PostID."'
			WHERE ThreadID = '".$this->ThreadID."'");
	}
	
	public function getNewLastPostBoard() {
		$temp = MySQL::single("SELECT p.PostID 
			FROM ".$this->abk."_forum_post AS p
				JOIN ".$this->abk."_forum_thread AS t ON (t.ThreadID = p.ThreadID)  
			WHERE t.BoardID = '".$this->BoardID."' ORDER BY Time DESC LIMIT 1");
		if (!$temp) $temp = 0;
		return $temp;
	}
	
	public function getNewLastPostThread() {
		$temp = MySQL::single("SELECT PostID FROM ".$this->abk."_forum_post 
			WHERE ThreadID = '".$this->ThreadID."' ORDER BY Time DESC LIMIT 1");
		if (!$temp) $temp = 0;
		return $temp;
	}
	
	public function countPostsInThread() {
		return MySQL::single("SELECT COUNT(*) FROM ".$this->abk."_forum_post 
			WHERE ThreadID = '".$this->ThreadID."'");
	}
	
	/*
	 * Ausgabe
	 */
	
	public static function thema_config($title1, $title2, $height) {
		global $tpl;
		$tpl->assign('THEMA_STARTEN_TITLE1', $title1);
		$tpl->assign('THEMA_STARTEN_TITLE2', $title2);
		$tpl->assign('BEITRAG_ANZEIGEN_BEITRAG_HEIGHT', $height);
		$tpl->assign('BLAETTERN', false);
		$tpl->assign('BEITRAEGE', false);
		$tpl->assign('BEITRAG_ANZEIGEN_SHOW_INTERAKTIONEN', false);
	}
	public static function thema_interaktionen_aktivieren() {
		global $tpl;
		$tpl->assign('BEITRAG_ANZEIGEN_SHOW_INTERAKTIONEN', true);
	}
	
	public static function beitrag_anzeigen_spezific($PostID, $AutorID, $Autor, $Inhalt, $Time, $postCounter = 0) {
		global $BBC;
		$return = array();
		$return['ForumPostCounter'] = $postCounter;
		$return['PostID'] = $PostID;
		$return['AutorID'] = $AutorID;
		$return['Autor'] = $Autor;
		$return['Inhalt'] = $BBC->ausgabe($Inhalt);
		$return['Time'] = $Time;
		return $return; 
	}
	
	public static function beitrag_anzeigen(array $entry) {
		global $BBC;
		if (!isset($entry['ForumPostCounter'])) $entry['ForumPostCounter'] = 0;
		$entry['Inhalt'] = $BBC->ausgabe($entry['Inhalt']);
		return $entry; 
	}
	
	public static function beitrag_interaktion($return, $BoardID, $ThreadID) {
		$return['BoardID'] = $BoardID;
		$return['ThreadID'] = $ThreadID;
		return $return;
	}

	public static function thema_assign($beitraege) {
		global $tpl;
		$tpl->assign('BEITRAEGE', $beitraege);
	}
	
}

?>