<?php

include_once CLASSES.'class_settings.php';

/**
 * 
 * Funktionen zum Dateiupload
 * @author Konstantin Grupp
 *
 */
class Files {

	/**
	 * 
	 * Gibt an zu welcher Rechteebene die Datei gehören soll
	 * @var String
	 */
	private $abk;
	/**
	 * 
	 * Speichert das Design
	 * @var String
	 */
	private $design_type = null;
	/**
	 * 
	 * Gibt an in welchem Ordner die Dateien gespeichert werden/wurden
	 * (public_pics, public_files, declared_pics, declared_files)
	 * @var String
	 */
	private $type;
	/**
	 * 
	 * Speichert den Dateinamen (OHNE Pfad)
	 * @var String
	 */
	private $fileName;
	/**
	 * 
	 * Speichert welches Bild im Falle eines Fehlers ausgegeben werden soll
	 * @var String
	 */
	private $errorPicName = '';
	
	/**
	 * 
	 * erstellt Objekt zu einer Datei
	 * @param String $type
	 * @param String $fileName
	 * @param String $abk
	 */
	public function __construct($type, $fileName = null, $abk = ABK, $design = null) {
		$this->type = addslashes($type);
		$this->fileName = addslashes($fileName);
		$this->abk = $abk;
		$this->design_type = $design;
		$this->updateDesignType();
	}
	
	public function setErrorPicName($errorPicName) {
		$this->errorPicName = $errorPicName;
	}
	
	private function updateDesignType() {
		if ($this->design_type == null)
			$this->design_type = Settings::get($this->abk, 'design_type');
	}
	
	public static function checkType($type, $checkType = 'upload') {
		switch($checkType) {
			case 'upload': {
				return in_array($type, array('public_pics', 
					'declared_pics', 'public_files', 'declared_files'));
			}
		}
		return false;
	}
	
	/**
	 * 
	 * bestimmt zum Typ die passende public URL
	 * @param String $type
	 * @param String $abk
	 */
	public static function getUrl($type, $abk, $design) {
		if ($type == 'declared_files') {
			return TOOLS.'getFile.php?type=declared&abk='.$abk.'&file=';
		} else if ($type == 'public_files') {
			return TOOLS.'getFile.php?abk='.$abk.'&file=';
		} else if ($type == 'declared_pics') {
			return TOOLS.'getIMG.php?type=declared&abk='.$abk.'&file=';
		} else if ($type == 'public_pics') {
			return TOOLS.'getIMG.php?abk='.$abk.'&file=';
		} else if ($type == 'general') {
			return DATA.'pics_page/general/';
		// DESIGN
		} else if ($type == 'design_smiley') {
			return TOOLS.'getDesign.php?type=smiley&abk='.$abk.'&file=';
		} else if ($type == 'design_abk') {
			return TOOLS.'getDesign.php??type=abk&abk='.$abk.'&file=';
		} else if ($type == 'design') {
			return TOOLS.'getDesign.php?design='.$design.'&file=';
		} else {
			die(FatalError('missingDesignType'));
		}
	}
	
	/**
	 * 
	 * bestimmt zum Typ den passenden internen Ordner
	 * @param String $type
	 * @param String $abk
	 */
	public static function getFolder($type, $abk = null, $design = null) {
		if ($abk === null) $withAbk = false;
		else $withAbk = true;
		if ($type == 'declared_files') {
			return DATA.'declared_files/'.($withAbk ? $abk.'_' : '');
		} else if ($type == 'public_files') {
			return DATA.'public_files/'.($withAbk ? $abk.'_' : '');
		} else if ($type == 'declared_pics') {
			return DATA.'declared_pics/'.($withAbk ? $abk.'_' : '');
		} else if ($type == 'public_pics') {
			return DATA.'public_pics/'.($withAbk ? $abk.'_' : '');
		} else if ($type == 'general') {
			return DATA.'pics_page/general/';
		// DESIGN
		} else if ($type == 'design_smiley') {
			return DATA.'pics_page/smiley/';
		} else if ($type == 'design_abk') {
			return DATA.'pics_page/abk/'.($withAbk ? $abk.'_' : '');
		} else if ($type == 'design') {
			return DATA.'pics_page/design/'.$design.'/';
		} else {
			die(FatalError('missingDesignType'));
		}
	}
	
	/**
	 * 
	 * läd ein File auf den Server (falls valide)
	 * (in $_FILES['File'] muss die Datei hochgeladen worden sein)
	 * @param Boolean $isAdmin
	 */
	public function upload($isAdmin = false) {
		if ($isAdmin) onlyAdmin();
		global $_FILES;
		
		// Zielordner nach Typ wählen
		$folder = Files::getFolder($this->type, $this->abk, $this->design_type);
		
		// Behandlung von Bildern
		if ($this->type == 'public_pics' || $this->type == 'declared_pics') {
			if (($_FILES['File']['size'] < PICS_MIN_SIZE) ||
				(PICS_MAX_SIZE < $_FILES['File']['size']))
				Message::$errorType = 'upload_pic_unvalid_size';
				
			$datei = GetImageSize($_FILES['File']['tmp_name']);
			if($datei[2] != 1 && $datei[2] != 2 && $datei[2] != 3)
				Message::$errorType = 'upload_pic_type_unvalid';
		} else { // Behandlung von sonstigen Dateien
			if (($_FILES['File']['size'] < FILES_MIN_SIZE) ||
				(FILES_MAX_SIZE < $_FILES['File']['size']))
				Message::$errorType = 'upload_file_unvalid_size';
		}
		
		if (!preg_match(FILE_REGEX, $_FILES['File']['name']))
			Message::$errorType = 'upload_filename_unvalid';
		
		if (Message::noError()) {
			$name = $folder;
			if (!$isAdmin) $name .= 'User'.NICKID.'_';
			$name .= $_FILES['File']['name'];
			move_uploaded_file($_FILES['File']['tmp_name'], $name);
		}
	}
	
	/**
	 * 
	 * speichert Bilder aus Foren/Gästebucheinträgen lokal ab
	 * @param String $url
	 */
	public function loadPicture($url) {
		// Zielordner nach Typ wählen
		$folder = Files::getFolder($this->type, $this->abk, $this->design_type);
		
		$result = array('url' => $url);#
		// Bilder die bereits hochgeladen sind nicht neu hochladen
		if (preg_match('/^(http:\/\/)?(www.)?konstantin-grupp\.de\/.*$/', $url)) {
			$fileName = urldecode(preg_replace('/^.+&file=(.+)&?#?.*$/', '\\1', $url));
			$abk = preg_replace('/^.+&abk=('.ABK_REGEX_RAW.')&?#?.*$/', '\\1', $url);
			$result['local'] = Files::getFolder($this->type, $abk, $this->design_type).$fileName;			
			return $result;
		}
		
		// Behandlung von Bildern
		$fileEnding = strtolower(preg_replace('/.*\.([A-Za-z0-9]+)$/', '\\1', $url));
		$fileSize = Files::urlfilesize($url);
		if ($this->type == 'public_pics' || $this->type == 'declared_pics') {
			if (($fileSize < PICS_MIN_SIZE) ||
				(PICS_MAX_SIZE < $fileSize))
				return $result;
			
			if($fileEnding != 'gif' && $fileEnding != 'png' && $fileEnding != 'jpg' && $fileEnding != 'jpeg')
				return $result;
		} else { // Behandlung von sonstigen Dateien
			if (($fileSize < FILES_MIN_SIZE) ||
				(FILES_MAX_SIZE < $fileSize))
				return $result;
		}
		
		$fileName = 'User'.NICKID.strftime("_autoUpload_%Y-%m-%d_%H-%M-%S").'.'.$fileEnding;
		$contents= file_get_contents($url);
		setlocale(LC_TIME, 'de_DE');
		$savefile = fopen($folder.$fileName, "w");
		fwrite($savefile, $contents);
		fclose($savefile);
		
		return array('url' => Files::getUrl($this->type, $this->abk, $this->design_type).$fileName, 
			'local' => $folder.$fileName);
	}
	
	/**
	 * 
	 * Löscht ein File (falls valide)
	 * @param Boolean $isAdmin
	 */
	public function delete($isAdmin = false) {
		if ($isAdmin) onlyAdmin();
		
		
		$fileName = Files::getFolder($this->type, $this->abk, $this->design_type).$this->fileName;
		if ((!preg_match(FILE_REGEX, $this->fileName)) ||
			(!is_file($fileName))) {
			Message::$errorType = 'upload_del';
		} else {
			if (!$isAdmin) {
				if (!preg_match('/^User[0-9]+_.+$/', $this->fileName)) {
					Message::$errorType = 'upload_del';
				} else if (NICKID != preg_replace('/^User([0-9]+)_.*$/', '\\1', $this->fileName)) {
					Message::$errorType = 'upload_del';	
				}
			}
			
			if (Message::noError()) {
				unlink($fileName);
			}
		}
	}
	
	/**
	 * 
	 * Generiert die Dateiübersicht
	 * @param Boolean $isAdmin
	 */
	public function output($ab, $anzahl, $isAdmin = false) {
		if ($isAdmin) onlyAdmin();
		global $tpl;
		
		$tpl->assign('FOLDER_TYPE', $this->type);
		$handle=opendir(Files::getFolder($this->type, null, $this->design_type));
		$upload_output = array();
		$file_count = 0;
		while ($datei = readdir($handle)) {
			if ($datei == '.' || $datei == '..') continue;
			$temp = array();
			if ($this->type == 'design' || preg_match('/^'.$this->abk.'_.*$/', $datei)) {
				if ($this->type == 'design') $temp['filename'] = $datei;
				else $temp['filename'] = substr($datei, strlen($this->abk) + 1);
				if (preg_match('/^User[0-9]+_.*$/', $temp['filename'])) {
					$temp['UserID'] = preg_replace('/^User([0-9]+)_.*$/', '\\1', $temp['filename']);
					$user = new User($temp['UserID']);
					$temp['User'] = $user->getNick();
				} else $temp['UserID'] = 0;
				if ($isAdmin || NICKID == $temp['UserID']) {
					$file_count++;
					if ($ab < $file_count && 0 < $anzahl) {
						array_push($upload_output, $temp);
						$anzahl--;
					}
				}
			}
		}
		closedir($handle);
		$tpl->assign('UPLOADS', $upload_output);
		return $file_count;
	}
	
	/**
	 * 
	 * Checks if the File exists
	 */
	public function fileExists() {
		return (is_file(Files::getFolder($this->type, $this->abk, $this->design_type).$this->fileName));
	}
	
	/**
	 * 
	 * Gibt eine Datei/Bild aus
	 */
	public function outputFile() {
		$fileName = Files::getFolder($this->type, $this->abk, $this->design_type).$this->fileName;
		if ((!preg_match(FILE_REGEX, $this->fileName)) || 
			(!is_file($fileName))) {
			if ($this->fileName == $this->errorPicName) FatalError('missingErrorPicture');
			$this->fileName = $this->errorPicName;
			$this->type = 'general';
			$this->outputFile();
			return;
		}

		// Dateityp bestimmen
		$finfo = finfo_open(FILEINFO_MIME_TYPE);
		$fileType = finfo_file($finfo, $fileName);
		if (preg_match('/^.*.css$/',$fileName)) {
			$fileType = 'text/css';
		}
		finfo_close($finfo);			
		// Zeitpunkt der letzten Bearbeitung bestimmen	
		$fileModTime = filemtime($fileName);
		// Request das der Client mitgesendet hat
		$headers = Files::getRequestHeaders();
			
		$headers = isset($headers['If-Modified-Since']) ? 
		$headers['If-Modified-Since'] : -1;
		
		// Überprüft ob die Clientversion die aktuelle ist
		if (strtotime($headers) == $fileModTime) {
			// Client's cache ist der aktuelle, dann antworten wir nur '304 Not Modified'.
			header('Last-Modified: '.gmdate('D, d M Y H:i:s', $fileModTime).' GMT', true, 304);
			header('Cache-Control: must-revalidate');
		} else {
			// Bilder, nicht gechached oder abgelaufen, dann antworten wir '200 OK'
			header('Last-Modified: '.gmdate('D, d M Y H:i:s', $fileModTime).' GMT', true, 200);
			header('Cache-Control: must-revalidate');
			header('Content-type: '.$fileType);
			header('Content-transfer-encoding: binary');
			header('Content-length: '.filesize($fileName));
			header('Content-disposition: filename="'.$this->fileName.'"');
			readfile($fileName);
		}
	}

	/**
	 * 
	 * Gibt den Request des Clients zurück
	 */
	private static function getRequestHeaders() {
		if (function_exists("apache_request_headers")) {
			if($headers = apache_request_headers()) {
				return $headers;
			}
		}
		$headers = array();
		// Grab the IF_MODIFIED_SINCE header
		if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']))  {
			$headers['If-Modified-Since'] = $_SERVER['HTTP_IF_MODIFIED_SINCE'];
		}
		return $headers;
	}

	private static function urlfilesize($url) {
		if (substr($url,0,4)=='http') {
			$x = array_change_key_case(get_headers($url, 1),CASE_LOWER);
			$x = $x['content-length'];
		}
		else { $x = @filesize($url); }
		return $x;
	}

}

define('TOOL_GETPIC', TOOLS.'getIMG.php?abk='.ABK.'&file=');
define('TOOL_GETPIC_DEC', TOOLS.'getIMG.php?type=declared&abk='.ABK.'&file=');
define('TOOL_GETFILE', TOOLS.'getFile.php?abk='.ABK.'&file=');
define('TOOL_GETFILE_DEC', TOOLS.'getFile.php?type=declared&abk='.ABK.'&file=');
define('TOOL_GETPIC_GENERAL', TOOLS.'getIMG.php?abk=general&file=');
define('TOOL_GETDESIGN', TOOLS.'getDesign.php?design='.Settings::get(ABK, 'design_type').'&file=');

?>