<?php

/**
 * 
 * Die Klasse zum Caching der Templates
 * @author Konstantin Grupp
 *
 */
class Cache {
	
	/**
	 *  
	 * Gibt an welcher Cachingtyp standardmäßig verwendet wird
	 * @var Integer
	 */
	private $caching;
	
	/**
	 * 
	 * Speichert die CacheIDs zu den Templates
	 * @var assoziatives Array
	 */
	private $cacheIDs;
	
	private $tpl;
	private $allTPL;
	
	/**
	 * 
	 * Der Konstruktor für den Cache
	 */
	public function __construct($caching, $ABKtemplate, $allTemplates) {
		$this->caching = $caching;
		$this->cacheIDs = array();
		$this->allTPL = array();
		foreach ($allTemplates as $vl) {
			$tpl = new Smarty;
			$templateFolder = TEMPLATES.$vl.'/';
			$this->allTPL[$vl] = $tpl;
			$tpl->config_dir = $templateFolder.'configs/';
			//$tpl->configLoad('my.conf');
			$tpl->template_dir = $templateFolder.'template/';
			$tpl->compile_dir = $templateFolder.'compile/';
			$tpl->cache_dir = $templateFolder.'cache/';
			$tpl->addPluginsDir($templateFolder.'plugins/');
			//$tpl->debugging = true;
		}
		$this->tpl = $this->allTPL[$ABKtemplate];
		$this->tpl->caching = $caching;
	}
	
	public function getABKtemplate() {
		return $this->tpl;
	}
	
	public function getTemplate($template) {
		return $this->allTPL[$template];
	}
	
	/**
	 * 
	 * Der Destuktor für den Cache (normal nicht benötigt)
	 */
	public function __destruct() {
		
	}
	
	/**
	 * 
	 * überprüft ob das Template bereits gültig gecached ist
	 * @param String $type (header, menu, content, footer, ...)
	 * @param String $filename
	 * @param String $cacheID
	 * @param Integer $lifetime (Standard -1 steht für unendlich lange)
	 */
	public function isCached($type, $filename, $cacheID, $lifetime = -1) {
		global $tpl;
		$tpl->cache_lifetime = $lifetime;
		$this->cacheIDs[$type] = array('filename' => $filename, 'cacheID' => $cacheID, 'lifetime' => $lifetime);
		$temp_cache = $tpl->caching;
		$tpl->caching = $this->caching;
		$temp = $tpl->isCached($filename, $cacheID);
		$this->tester($type, $temp, $cacheID);
		$tpl->caching = $temp_cache;
		return $temp;
	}
	
	/**
	 * 
	 * Diese Seite nicht gecachen
	 * @param String $type (header, menu, content, footer, ...)
	 * @param String $filename
	 */
	public function noCache($type, $filename) {
		global $tpl;
		$this->cacheIDs[$type] = array('filename' => $filename);
		$this->tester($type, false, '__ no cache __');
	}
	
	public function isTypeSet($type) {
		return isset($this->cacheIDs[$type]);
	}
	
	/**
	 * 
	 * Gibt einen Typ aus (wird ausschließlich in general.php am Ende verwendet)
	 * @param String $type (header, menu, content, footer, ...)
	 */
	public function display($type) {
		global $tpl;
		if (isset($this->cacheIDs[$type])) {
			$temp = $this->cacheIDs[$type];
			if (isset($temp['cacheID'])) { // caching
				$tpl->cache_lifetime = $temp['lifetime'];
				$tpl->display($temp['filename'], $temp['cacheID']);
			} else { // no caching
				$temp1 = $tpl->caching;
				$tpl->caching = false;
				$tpl->display($temp['filename']);
				$tpl->caching = $temp1;
			}
		} else {
			Message::$errorType = 'unvalidMissingTemplate';
			refresh(MAIN);
			$this->display('content');
		}
	}
	
	/**
	 * 
	 * Löscht den gesamten Cache nach einem angegebenen Muster
	 * @param String $filename
	 * @param String $cacheID
	 */
	public function clearCache($filename, $cacheID = null) {
		foreach($this->allTPL as $tpl) {
			$tpl->clearCache($filename, $cacheID);
		}
	}
	
	private function tester($type, $inCache, $cacheID) {
		global $tpl;
		//echo $type.($inCache ? " true" : " false")." ".$tpl->caching." ".$cacheID."\n<br>";
	}
		
}

?>