<?php

include_once CLASSES.'class_session.php';

/**
 * 
 * Schützt die Seiten vor Spaming von unangemeldeten Usern
 * @author Konstantin Grupp
 *
 */
class Block {
	
	const CAPTCHA_LENGTH = 5;
	
	/**
	 * 
	 * Sperrt für einen User (IP-abhängig) für bestimmte Aktionen für einen beliebig langen Zeitraum
	 * @param Integer $time
	 */
	public static function tempBlockSet($time) {
		MySQL::insert("INSERT INTO general_temp_block (abk, Time, IP) 
			VALUES ('".ABK."', '".(TIME + $time)."', '".$_SERVER['REMOTE_ADDR']."')");
	}
	
	/**
	 * 
	 * überprüft ob der aktuelle User (IP-abhängig) derzeit temporär gesperrt wurde 
	 * @param Boolean $global
	 */
	public static function tempBlockCheck($global = true) {
		return MySQL::single("SELECT COUNT(*) FROM general_temp_block 
			WHERE (IP = '".$_SERVER['REMOTE_ADDR']."') AND (Time > '".TIME."')
				".($global ? "" : " AND (abk = '".ABK."')"));
	}
	
	/**
	 * 
	 * Löscht alte Blocks aus der Datenbank
	 * @param Integer $time
	 */
	public static function tempBlockDeleteOldBlocks($time) {
		$temp = TIME - $time;
		MySQL::query("DELETE FROM general_temp_block WHERE (TIME < '".$temp."')");
	}
	
	public static function timeBlockSet($type) {
		Session::set('spam_'.$type, TIME);
	}
	
	public static function timeBlockCheck($type, $min = BLOCK_TIME_STD_MIN, $max = BLOCK_TIME_STD_MAX) {
		return (!Session::exists('spam_'.$type)) ||
			(TIME <= (Session::get('spam_'.$type) + $min)) ||
			((Session::get('spam_'.$type) + $max) <= TIME);
	}
	
	public static function captchaCheck() {
		$temp = Session::get('spam_captcha');
		Session::del('spam_captcha');
		return (!isset($_POST['captcha'])) || strlen($_POST['captcha']) !== Block::CAPTCHA_LENGTH || ($_POST['captcha'] != $temp);
	}
	
	public static function captchaGenerateIMG() {
		$text = Block::randomString(Block::CAPTCHA_LENGTH);  //Die Zahl bestimmt die Anzahl stellen
		Session::set('spam_captcha', $text);
		header('Content-type: image/png');
		$img = ImageCreateFromPNG(DATA.'public_pics/general_captcha.png'); //Backgroundimage
		$color = ImageColorAllocate($img, 0, 0, 0); //Farbe
		$ttf = DATA."fonts/CHILLER.TTF"; //Schriftart
		$ttfsize = 25; //Schriftgrösse
		$angle = rand(0,5);
		$t_x = rand(8,30);
		$t_y = 35;
		imagettftext($img, $ttfsize, $angle, $t_x, $t_y, $color, $ttf, $text);
		imagepng($img);
		imagedestroy($img);
	}
	
	private static function randomString($len) {
		srand(Block::make_seed());  
		//Der String $possible enthält alle Zeichen, die verwendet werden sollen
		$possible="ABCDEFGHJKLMNPRSTUVWXYabcdefghijkmnpqrstuvwxy3456789";
		$str="";
		while(strlen($str)<$len) {
			$str.=substr($possible,(rand()%(strlen($possible))),1);
		}
		return($str);
   }
   
   private static function make_seed(){
		list($usec , $sec) = explode (' ', microtime());
		return (float) $sec + ((float) $usec * 100000);
	}

}

?>