<?php

onlyAdmin();

/**
 * 
 * Klasse mit Adminfunktionen
 * @author Konstantin Grupp
 *
 */
class Admin {
	
	/**
	 * 
	 * Speichert ob der aktuelle User ein MainAdmin ist
	 * @var Boolean
	 */
	private static $MainAdmin = null;
	
	/**
	 * 
	 * Speichert die Seiten auf denen der User Adminrechte hat
	 * @var Array
	 */
	private static $pages = null;
	
	/**
	 * 
	 * Überprüft ob der User auf irgendeiner Seite Adminrechte hat
	 */
	public static function isAdmin($abk = null, $UserID = null) {
		if ($abk == null || $UserID == null)
			return MySQL::single("SELECT COUNT(*) FROM admin_rights 
				WHERE AdminID = '".NICKID."' LIMIT 1");
		else
			return MySQL::single("SELECT COUNT(*) FROM admin_rights 
				WHERE AdminID = '".addslashes($UserID)."' AND abk = '".$abk."'");
	}
	
	public static function isFounder($abk = ABK, $id = NICKID){
		return MySQL::single("SELECT COUNT(*) FROM general_settings WHERE abk = '".addslashes($abk)."' AND FounderID = '".$id."'");
	}
	
	/**
	 * 
	 * Überprüft ob die übergebene 'abk' gültig ist, heißt ob man Adminrechte dafür hat
	 * @param String $section_dest (admin, settings)
	 */
	public static function checkABK($section_dest = 'admin') {
		global $tpl;
		if (Admin::$pages == null) Admin::nav4($section_dest);
		if (isset($_GET['abk'])) $abk = $_GET['abk'];
		else $abk = null;
		if (!array_key_exists($abk, Admin::$pages)) {
			$temp = array_keys(Admin::$pages);
			if (isset($temp[0]))
				$abk = Admin::$pages[$temp[0]]['abk'];
		}
		$tpl->assign('_ABK', $abk);
		return $abk;
	}
	
	/**
	 * 
	 * Überprüft ob der User ein MainAdmin ist (globale Adminrechte)
	 */
	public static function isMainAdmin($id = NICKID) {
		if ($id != NICKID || Admin::$MainAdmin === null) {
			if ($id == NICKID && Admin::$pages != null)
				Admin::$MainAdmin = isset(Admin::$pages['general']);
			else 
				Admin::$MainAdmin = MySQL::single("SELECT COUNT(*) FROM admin_rights WHERE AdminID = '".$id."' AND abk = 'general'");
		}
		return Admin::$MainAdmin;
	}
	
	/**
	 * 
	 * Sucht die Seiten raus auf denen der aktuelle User Adminrechte hat für die Auswahl der Nav4
	 * @param String $section_dest (admin, settings)
	 */
	public static function nav4($section_dest = 'admin') {
		global $tpl;
		Admin::$pages = MySQL::assocs("SELECT adm.ID, adm.abk, gset.title FROM admin_rights AS adm 
			JOIN general_settings AS gset ON (gset.abk = adm.abk) WHERE adm.AdminID = ".NICKID, 'abk');
		$tpl->assign('PAGES', Admin::$pages);
		$tpl->assign('PAGES_COUNT', count(Admin::$pages));
		$tpl->assign('SECTION_DEST', $section_dest);
	}
	
	/**
	 * 
	 * Gibt aus für wie viele Seiten man Adminrechte hat
	 */
	public static function getPages($section_dest = 'admin') {
		if (Admin::$pages == null) Admin::nav4($section_dest);
		return Admin::$pages;
	}
	
	/**
	 * 
	 * Überprüfungen für Standardpage (ausgeloggt)
	 */
	public static function validStdPage0_WHERE() {
		global $edit_abk;
		return "(abk = '".$edit_abk."' OR 
				(abk = 'general' AND section = 'impressum')) AND 
					declared = '0' AND (section != 'redirect')";
	}
	
	/**
	 * 
	 * Überprüfungen für Standardpage (eingeloggt)
	 */
	public static function validStdPage1_WHERE() {
		global $edit_abk;
		return "(abk = '".$edit_abk."' OR 
				(abk = 'general' AND section = 'impressum' AND declared = '0')) AND 
					(section != 'redirect' AND section != 'logout' AND section != 'login')";
	}
	
	/**
	 * 
	 * Überprüfen ob es ein gültiger Typ ist (navigation hinzufügen)
	 * @param String $type (einer der Seitentypen)
	 */
	public static function validNavType($type) {
		return in_array($type,
			array("specialpages", "redirect", "redirect_int", "login", "news", "logout", 
				"start", "forum", "kalender", "gaestebuch", "userDefined", "upload"));
	}
	
	/**
	 * 
	 * Überprüfen ob eine Specialpages Section schon vergeben wurde
	 * @param String $section
	 * @param String $edit_abk (abk)
	 * @param String $declared
	 */
	public static function validNavSectionUsed($section, $edit_abk, $declared) {
		return MySQL::single("SELECT COUNT(*) FROM general_navigation
				WHERE (abk = 'general' OR abk = '".$edit_abk."') AND 
					declared = '".$declared."' AND section ='".addslashes($section)."'");
	}
	
	/**
	 * 
	 * Überprüfen ob eine Specialpages Section schon vergeben wurde
	 * @param String $section
	 * @param String $edit_abk (abk)
	 */
	public static function validNavSectionSP($section, $edit_abk) {
		return MySQL::single("SELECT COUNT(*) FROM general_specialpages 
				WHERE (abk = 'general' OR abk = '".$edit_abk."') AND section ='".addslashes($section)."'");
	}
	
	/**
	 * 
	 * Überprüft die Gültigkeit von Variablen
	 * @param String $type (%a)
	 * @param %a $value
	 * @param String $errorPrefix
	 */
	public static function validate($type, $value, $errorPrefix = '') {
		global $BBC;
		//pvar($type.': '.$value);
		if (preg_match('/[\w\-_]+/', $type, $temp1) &&
			preg_match('/\d+/', $type, $temp2)) {
			$type = $temp1[0];
			if (strlen($value) > $temp2[0])
				Message::$errorType = $errorPrefix.'_'.$type.'_unvalidLength';
			unset($temp1, $temp2);
		}
		switch ($type) {
			case 'title': {
				$value = $BBC->eingabe($value, false);
				if (!preg_match(STRING_REGEX, $value))
					Message::$errorType = $errorPrefix.'_title_unvalidRegex';
				if (strlen($value) > ADMIN_TITLE_MAX_LENGTH || strlen($value) < ADMIN_TITLE_MIN_LENGTH)
					Message::$errorType = $errorPrefix.'_title_unvalidLength';
				break;
			}
			case 'href': {
				$value = addslashes($value);
				break;
			}
			case 'section': {
				if (preg_match(SECTION_REGEX, $value))
					Message::$errorType = $errorPrefix.'_section_unvalidName';
				if (strlen($value) > SECTION_MAX_LENGTH || strlen($value) < SECTION_MIN_LENGTH)
					Message::$errorType = $errorPrefix.'_section_unvalidLength';
				$value = addslashes($value);
				break;
			}
			case 'type': {
				if (!Admin::validNavType($value))
					Message::$errorType = $errorPrefix.'_type_unvalid';
			}
			case 'keywords': {
				if (preg_match(KEYWORDS_REGEX, $value))
					Message::$errorType = $errorPrefix.'_keywords_unvalid';
				$value = addslashes(trim($value));
				break;
			}
			case 'design': {
				$value = addslashes($value);
				if (!MySQL::single("SELECT COUNT(*) FROM general_designs WHERE type = '".$value."'"))
					Message::$errorType = $errorPrefix.'_design_unvalid';
				break;
			}
			case 'design_create': {
				if (MySQL::single("SELECT COUNT(*) FROM general_designs WHERE type = '".$value."'"))
					Message::$errorType = $errorPrefix.'_designAlreadyInUse';
				if (!preg_match(DESIGN_REGEX, $value))
					Message::$errorType = $errorPrefix.'_unvalid';
				$value = addslashes($value);
				break;
			}
			case 'abk_create': {
				if (Settings::is_abk($value))
					Message::$errorType = $errorPrefix.'_abk_seiteAlreadyInUse';
				if (!preg_match(ABK_REGEX, $value))
					Message::$errorType = $errorPrefix.'_abk_unvalid';
				$value = addslashes($value);
				break;
			}
			case 'abk': {
				if (!Settings::is_abk($value))
					Message::$errorType = $errorPrefix.'_abk_notExists';
				if (!preg_match(ABK_REGEX, $value))
					Message::$errorType = $errorPrefix.'_abk_unvalid';
				$value = addslashes($value);
				break;
			}
			default: {
				$value = BBC::validate($type, $value, $errorPrefix);
			}	
		}
		return $value;
	}
	
	
}

?>