<?
/**
* Stellt erweiterte Datenbankfunktionen zur Verfügung
* @author Konstantin Grupp
* 
*/
class MySQL {

	private static $PRINT_STATEMENTS = 0;
	private static $PRINT_ERRORS = 0;
	private static $LOG_STATEMENTS = 0;
	private static $LOG_ERRORS = 0;
	
	/**
	 * 
	 * Verbindet mit der Datenbank
	 */
	public function __construct() {
		$DB_HOST = MySQL_DB_HOST;
		$DB_USER = MySQL_DB_USER;
		$DB_PASSWORD = MySQL_DB_PASSWORD;
		$DATABASE = MySQL_DATABASE;
		

		$dbh = mysql_connect($DB_HOST,$DB_USER,$DB_PASSWORD) or FatalError("keine Verbindung m&ouml;glich");
		mysql_select_db($DATABASE,$dbh);
		mysql_query("SET NAMES 'utf8'");
		mysql_query("SET CHARACTER SET 'utf8'");
		unset($DB_HOST, $DB_USER, $DB_PASSWORD, $DATABASE);
	}
	
	public function __destruct() {
		mysql_close();
	}
	
	/**
	 * 
	 * Gibt ausführliche Fehlermeldungen, wenn Request nicht funktioniert
	 * @param String $action (SQL - INSERT/UPDATE/CREATE/DROP)
	 * @return SqlResult
	 */
	public static function query($action) {
		if (MySQL::$PRINT_STATEMENTS) {
			$before = MySQL::getmicrotime();    	
    	}
    	$txt = '';
    	$result = @mysql_query($action);
    	if (MySQL::$PRINT_STATEMENTS) {
	    	$after = MySQL::getmicrotime();
    		$duration = $after-$before;
    		$txt = 'DAUER: '.$duration.' QUERY: '.$action;
    	}
	    
	    $error = mysql_error();
	    if ($error) {
    		if (MySQL::$PRINT_ERRORS) {
				$txt = '<b><font color="orange">FEHLER:</font></b> '.
					($txt ? $txt : ' QUERY: '.$action).'<br>'.$error;
    		}
			
    		if (MySQL::$LOG_ERRORS) {
				if (defined(NICK)) $id = ABK.' - '.NICKID.' - '.NICK;
				else $id = ABK.' - vor logincheck';
				if (!$_GET) {
					$page = "externes Script";
				} else {
					$page = MAIN.(isset($_GET['section']) ? 'section='.$_GET['section'].
						(isset($_GET['action']) ? '&action='.$_GET['action'] : '') : '');
				}
	        	$page .= "\n=>\$_REQUEST: ".print_r($_REQUEST,1);
	        	$page .= "\n=>\$_SERVER: ".print_r($_SERVER,1);
	        	$page = addslashes($page);
	        	$sql = "INSERT INTO mysql_errors (time,error,statement,user,page) 
	        		VALUES ('".TIME."','".addslashes($error)."','".addslashes($action)."', '$id', '".$page."')";
            	@mysql_query($sql);
            	if (mysql_errno()) {
	            	@mysql_query("CREATE TABLE mysql_errors (
	            		time INT,
	            		error VARCHAR(255), 
	            		user VARCHAR(255), 
	            		statement VARCHAR(255),
	            		page TEXT)");
	            	@mysql_query($sql);
            	}
    		}
    	} 
		
		if (MySQL::$LOG_STATEMENTS)	{
			if (preg_match('/insert into/', $action))	{	}
			else	{
				$temp = preg_replace('/([^(=| )]+) ?= ?((\')[^\']+\',?|[^(,| )]+)/',"\\1", $action);
				mysql_query("insert into mysql_statements (statement) values ('$temp')");
			}	
		}
		if ($txt) pvar($txt);
    	return $result;
	}
	
	/**
	 * 
	 * Für Insert gibt dies die ID zurück
	 * @param String $query (SQL - INSERT)
	 */
	public static function insert($query) {
		MySQL::query($query);
		$temp = mysql_insert_id();
		return $temp;
	}
	
	/**
	 * Gibt ein eindimensionales array einer ZEILE zurück
	 * @param String $query (SQL - SELECT)
	 * @return Array
	 */
	public static function row($query) {
    	$result = MySQL::query($query);
    	$return = mysql_fetch_row($result);
    	return $return;
	}
	
	/**
	 * Gibt ein zweidimensionales array mehrer Zeilen zur�ck
	 * @param String $query (SQL - SELECT)
	 * @return Array
	 */
	public static function rows($query) {
	    $return = array();
	    $result = MySQL::query($query);
	    while ($returnstatus = mysql_fetch_row($result)) {
        	array_push($return,$returnstatus);
    	}
    	return $return;
	}
	
	/**
	 * 
	 * Gibt die Anzahl der Zeilen zurück
	 * @param String $query (SQL - SELECT)
	 * @return Integer
	 */
	public static function countRows($query) {
		$result = MySQL::query($query);
		return mysql_num_rows($result); 
	}
	
	/**
	 * Gibt ein eindimensionales assoziatives array einer ZEILE zurück
	 * @param String $query (SQL - SELECT)
	 * @return Array
	 */
	public static function assoc($query) {
    	$result = MySQL::query($query);
    	$return = mysql_fetch_assoc($result);
    	return $return;
	}
	
	/**
	 * Gibt ein zweidimensionales assoziatives array mehrer Zeilen zurück
	 * @param String $query (SQL - SELECT)
	 * @param String $opt
	 * @return Array
	 */
	public static function assocs($query, $opt = '') {
    	$return = array();
		$result = MySQL::query($query);
		if (!$opt) {
			while ($returnstatus = mysql_fetch_assoc($result)) {
				array_push($return,$returnstatus);
			}
		}
		else {
			while ($returnstatus = mysql_fetch_assoc($result)) {
				$return[$returnstatus[$opt]] = $returnstatus;
			}
		}
    	return $return;
	}
	
	/**
	 * Gibt den Wert einer einzelnen Zelle zurück
	 * @param String $query (SQL - SELECT)
	 * @return String
	 */
	public static function single($query) {
	    $result = MySQL::query($query);
	    $return = mysql_fetch_row($result);
	    $return = $return[0];
	    return $return;
	}
	
	/**
	 * Gibt ein Array einer SPALTE zurück
	 * @param String $query (SQL - SELECT)
	 * @return Array
	 */
	public static function singles($query) {
    	$return = array();
    	$result = MySQL::query($query);
    	while ($returnstatus = mysql_fetch_row($result)) {
	        array_push($return,$returnstatus[0]);
	    }
	    return $return;
	}
	
	/**
	 * 
	 * überprüft ob eine Tabelle existiert
	 * @param String $tablename
	 */
	public static function tableExists($tablename) {
		mysql_query("SELECT COUNT(*) FROM ".$tablename." limit 1");
    	if (mysql_errno()) return false;
    	else return true;
	}
	
	/**
	 * 
	 * Gibt die Zeit in Microsekunden zurück
	 */
	private static function getmicrotime() {
    	list($usec,$sec) = explode(" ",microtime());
	    return ((float)$usec + (float)$sec);
	}
}


?>