<?php

include_once CLASSES.'class_files.php';

/**
 * 
 * Klasse die den BBCode verarbeitet
 * @author Konstantin Grupp
 *
 */
class BBC {
	
	const QUOTE_DEPTH = 3;
	
	/**
	 * 
	 * Speichert die Smileys um mehrmaliges abfragen von der Datenbank zu verhindern
	 * @var Array
	 */
	private $smiley = array();
	
	/**
	 * 
	 * Erstellt ein BBC-Objekt
	 */
	public function __construct() {
		
	}
	
	/**
	 * 
	 * Überprüft die Gültigkeit von Variablen
	 * @param String $type (%a)
	 * @param %a $value
	 * @param String $errorPrefix
	 */
	public static function validate($type, $value, $errorPrefix = '') {
		global $BBC;
		if (preg_match('/[\w\-_]+/', $type, $temp1) &&
			preg_match('/\d+/', $type, $temp2)) {
			$type = $temp1[0];
			if (strlen($value) > $temp2[0])
				Message::$errorType = $errorPrefix.'_'.$type.'_unvalidLength';
			unset($temp1, $temp2);
		}
		switch ($type) {
			case 'int': {
				if (!is_numeric($value))
					Message::$errorType = $errorPrefix.'_int_unvalid';
				break;
			}
			case 'int+': {
				if (!is_numeric($value))
					Message::$errorType = $errorPrefix.'_int_unvalid';
				if ($value < 0)
					Message::$errorType = $errorPrefix.'_int_unvalid';
				break;
			}
			case 'string': {
				if (!preg_match(STRING_REGEX, $value))
					Message::$errorType = $errorPrefix.'_string_unvalidRegex';
				$value = addslashes($value);
				break;
			}
			case 'mail': {
				if (!preg_match(EMAIL_REGEX, $value))
					Message::$errorType = $errorPrefix.'_mail_unvalidRegex'; 
				if (strlen($value) > EMAIL_MAX_LENGTH)
					Message::$errorType = $errorPrefix.'_mail_unvalidLength';
				$value = addslashes($value);
				break;
			}
			case 'BBC': {
				$value = $BBC->eingabe($value);
				break;
			}
			case 'BBC-advanced': {
				$value = $BBC->eingabe($value, 'advanced');
				break;
			}
			case 'name': {
				if (strlen($value) < 3 || strlen($value) > 100)
					Message::$errorType = $errorPrefix.'_name_unvalidLength';
				$value = $BBC->eingabe($value, false);
				break;
			}
			case 'year': {
				if (!is_numeric($value) || $value < YEAR_MIN || $value > (CURRENT_YEAR + 10 ))
					Message::$errorType = $errorPrefix.'_date_year_unvalid';
				break;
			}
			case 'month': {
				if (!is_numeric($value) || $value < 1 || $value > 12)
					Message::$errorType = $errorPrefix.'_date_month_unvalid';
				break;
			}
			case 'day': {
				if (!is_numeric($value) || $value < 1 || $value > 31)
					Message::$errorType = $errorPrefix.'_date_day_unvalid';			
				break;
			}
			case 'icq': {
				if (($value != '') && !is_numeric($value))
					Message::$errorType = 'profil_icq_number_unvalid';
				if (strlen($value) > ICQ_MAX_LENGTH)
					Message::$errorType = 'profil_icq_unvalidLength';
				break;
			}
			case 'skype': {
				$value = $BBC->eingabe(trim($value), false);
				if (strlen($value) > SKYPE_MAX_LENGTH)
					Message::$errorType = 'profil_skype_unvalidLength';
				break;
			}
			case 'nick': {
				$value = addslashes($value);
				if (NICK_MIN_LENGTH > strlen($value))
					Message::$errorType = 'profil_nick_unvalidLengthMin';
				if (strlen($value) > NICK_MAX_LENGTH)
					Message::$errorType = 'profil_nick_unvalidLengthMax';
				if (preg_match(NICK_REGEX, $value))
					Message::$errorType = 'profil_nick_unvalidName';
				break;
			}
			case 'pw': {
				$user = new User(NICKID, NICK, null, true);
				if (!$user->validateLogin($value))
					Message::$errorType = $errorPrefix.'_pw_incorrect';
			}
			case 'pw_create': { 
				if (strlen($value) < PW_MIN_LENGTH || strlen($value) > PW_MAX_LENGTH)
					Message::$errorType = $errorPrefix.'_pw_unvalidLength';
				break;
			}
			default: {
				Message::$errorType = $errorPrefix.'_unvalidType';
			}	
		}
		return $value;
	}
	
	/**
	 * 
	 * holt die verfügbaren Smilys aus der Datenbank falls nötig
	 */
	public function assignSmiley() {
		if (!$this->smiley) {
			$this->smiley = MySQL::assocs("SELECT * FROM forum_smiley");
			global $tpl;
			$tpl->assign('BBC_SMILEY', $this->smiley); 
		}
	} 
	
	private static function eingabe_quote($treffer) {
		$return = '[quote]'.$treffer[1]."\n".$treffer[3].'[/quote]';
		return $return;
	}
	
	/**
	 * 
	 * BBCode Input überprüfen
	 * z.B. Bilder über 450px werden gekennzeichnet als [imgg]
	 * @param String $inhalt
	 * @param Integer $BBC
	 */
	public function eingabe($inhalt, $BBC = 1) {
		$inhalt = addslashes($inhalt);
		
		if ($BBC) {
			// TODO maximale zeichen auf 50 beschränken, außer in Links für Bilder und Links
			$inhalt = preg_replace_callback("/\[imgg\](.*)\[\/imgg\]/Usi", 'BBC::eingabe_picSize', $inhalt);
			$inhalt = preg_replace_callback("/\[img\](.*)\[\/img\]/Usi", 'BBC::eingabe_picSize', $inhalt);
			$inhalt = preg_replace_callback("/\[quote\](.*)\[quote\](.*)\[\/quote\](.*)\[\/quote\]/Usi", 'BBC::eingabe_quote', $inhalt);
			$inhalt = preg_replace('~([^\[\] ]{199})([^\[\] ]{1})~', '\1 \2', $inhalt);
		}
		else {
			$inhalt = preg_replace('~(\S{30})(\S{1})~', '\1 \2', $inhalt);
		}
		return $inhalt;
	}
	
	/**
	 * 
	 * BBCode Ausgabe in html umwandeln
	 * @param String $inhalt
	 * @param String $BBC (0, 1, advanced)
	 */
	public function ausgabe($inhalt, $BBC = 1) {
		if ($BBC == 'advanced') {
			global $settings;
			// Verwendbare Konstanten
			$inhalt = str_replace("[TOOLS]", TOOLS, $inhalt);
			$inhalt = str_replace("[TOOL_GETPIC]", TOOL_GETPIC, $inhalt);
			$inhalt = str_replace("[TOOL_GETPIC_DEC]", TOOL_GETPIC_DEC, $inhalt);
			$inhalt = str_replace("[TOOL_GETPIC_GENERAL]", TOOL_GETPIC_GENERAL, $inhalt);
			$inhalt = str_replace("[TOOL_GETFILE]", TOOL_GETFILE, $inhalt);
			$inhalt = str_replace("[TOOL_GETFILE_DEC]", TOOL_GETFILE_DEC, $inhalt);
			$inhalt = str_replace("[WWW]", WWW, $inhalt);
			$inhalt = str_replace("{RESPONSIBLEPERSON}", Settings::get(ABK, 'responsiblePerson'), $inhalt);
			$inhalt = str_replace("{RESPONSIBLEPERSON_GENERAL}", Settings::get('general', 'responsiblePerson'), $inhalt);
		}
		
		$inhalt = htmlspecialchars(stripslashes($inhalt));
		
		/*
		 * BBCode 1
		 */
		if ($BBC) {
			if ($BBC != 'advanced') $inhalt = nl2br($inhalt);
			$inhalt = preg_replace("/\[b\](.*)\[\/b\]/Usi", "<b>\\1</b>", $inhalt);
			$inhalt = preg_replace("/\[i\](.*)\[\/i\]/Usi", "<i>\\1</i>", $inhalt);
			$inhalt = preg_replace("/\[u\](.*)\[\/u\]/Usi", "<u>\\1</u>", $inhalt);
			$inhalt = preg_replace("/\[center\](.*)\[\/center\]/Usi", "<center>\\1</center>", $inhalt);
			
			/*
			 * Zitate (bis Stufe 3)
			 */
			for ($i = 0; $i < BBC::QUOTE_DEPTH; $i++) {
				$inhalt = preg_replace("/\[quote\](.*)\[\/quote\]/Usi", 
					"<div class=\"quoteRand\">Zitat:<div class=\"quoteInner\">\\1</div></div>", $inhalt);
			}
						
			/*
			 * Bilder
			 */
			$img_html = "alt=\"\\1\" title=\"\\1\"";
			$inhalt = preg_replace("/\[imgg\](.*)\[\/imgg\]/Usi", "<img ".$img_html." src=\"\\1\" width=\"450px\">", $inhalt);
			$inhalt = preg_replace("/\[img\](.*)\[\/img\]/Usi", "<img ".$img_html." src=\"\\1\">", $inhalt);
			
			/*
			 * Links
			 */
			$inhalt = preg_replace_callback("/\[url=(.*)\](.*)\[\/url\]/Usi", 'BBC::link_einbinden', $inhalt);
			$inhalt = preg_replace_callback("/\[url\](.*)\[\/url\]/Usi", 'BBC::link_einbinden', $inhalt);
			
			/*
			 * Youtube
			 */
			$inhalt = preg_replace_callback("/\[youtube\](.*)\[\/youtube\]/Usi", 'BBC::youtube_einbinden', $inhalt);
			
			/*
			 * Smileys 
			 */
			$this->assignSmiley();
			foreach($this->smiley as $vl) {
				$inhalt = str_replace($vl['Alias'],
					"<img title=\"".$vl['Alias']."\" alt=\"".$vl['Alias']."\" ".
					"src=\"".TOOL_GETDESIGN.$vl['Bildlink'].'&amp;type=smiley'."\">",
					$inhalt);
			}
			
			/*
			 * Erweiterter BBCode für Specialpages
			 */
			if ($BBC == 'advanced') {
				global $settings;
				$inhalt = preg_replace("/\[small\](.*)\[\/small\]/Usi", "<small>\\1</small>", $inhalt);
				$inhalt = preg_replace("/\[big\](.*)\[\/big\]/Usi", "<big>\\1</big>", $inhalt);
				$inhalt = preg_replace("/\[h3\](.*)\[\/h3\]/Usi", "<h3>\\1</h3>", $inhalt);
				$inhalt = preg_replace("/\[h4\](.*)\[\/h4\]/Usi", "<h4>\\1</h4>", $inhalt);
				$inhalt = str_replace("[hr]", "<hr>", $inhalt);
				$inhalt = str_replace("[br]", "<br>", $inhalt);
				$inhalt = str_replace("[ul]", "<ul>", $inhalt); $inhalt = str_replace("[/ul]", "</ul>", $inhalt);
				$inhalt = str_replace("[ol]", "<ol>", $inhalt); $inhalt = str_replace("[/ol]", "</ol>", $inhalt);
				$inhalt = str_replace("[li]", "<li>", $inhalt); $inhalt = str_replace("[/li]", "</li>", $inhalt);
				$inhalt = preg_replace("/\[p\](.*)\[\/p\]/Usi", "<p>\\1</p>", $inhalt);
				$inhalt = preg_replace("/\[table\](.*)\[\/table\]/Usi", "<table class=\"normal\">\\1</table>", $inhalt);
				$inhalt = preg_replace("/\[tr\](.*)\[\/tr\]/Usi", "<tr>\\1</tr>", $inhalt);
				$inhalt = preg_replace("/\[th\](.*)\[\/th\]/Usi", "<th>\\1</th>", $inhalt);
				$inhalt = preg_replace("/\[td\](.*)\[\/td\]/Usi", "<td>\\1</td>", $inhalt);
				$inhalt = preg_replace("/\[floatleft\](.*)\[\/floatleft\]/Usi",
					"<div align=\"left\" style=\"float:left; padding-right:20px;\">\\1</div>", $inhalt);
				$inhalt = preg_replace("/\[floatright\](.*)\[\/floatright\]/Usi",
					"<div align=\"right\" style=\"float:right; padding-left:20px;\">\\1</div>", $inhalt);
				
				
				// Bei Bildern die Breite selbst bestimmen
				$inhalt = preg_replace_callback("/\[img=(.*)\](.*)\[\/img\]/Usi", 'BBC::img_einbinden', $inhalt);
			}
		}
		//Text zurückgeben zur Anzeige
		return $inhalt; 
	}
	
	/*
	 * preg_callback Funktionen
	 */

	/**
	 * 
	 * BBCode Urllänge
	 * @param String $treffer
	 */
	private static function link_einbinden($treffer) {
		// $treffer[1] ist die URL
		$url = trim($treffer[1]);
		// $treffer[2] ist der Ausgabename
		// wurde kein Name angegeben, wird die URL als Name gewählt
		if(strlen(trim($treffer[2]))!=0)
			$linkname = $treffer[2];
		else
			//wenn Link als Linkname länger als 50 Zeichen wird er gekürzt
			if (strlen($treffer[1]) > 50)
				$linkname = substr($treffer[1], 0, 45-3)."...".substr($treffer[1], -5);
			else
				$linkname = $treffer[1];
		// Rückgabelink
		$ergebnis = "<a class=\"normal\" href=\"".$url."\" target=\"_blank\">".$linkname."</a>";
		return $ergebnis;
	}
	
	private static function youtube_einbinden($treffer) {
		// Wenn es ein normaler Link ist, ohne Zusatzparamter wie "&feature=related#"
		if(!preg_match('#youtube.com\/watch\?.*v=(.*)&#', $treffer[1], $bbcode_new)){
			// Wenn der Link Zusatzparamter wie "&feature=related#" besitzt
			preg_match('#youtube.com\/watch\?.*v=(.*)#', $treffer[1], $bbcode_new);
		}
		// Da die Funktion "preg_match" oben den Schlüssel des Videos von Youtube ausliest wird er hier nun zwischengespeichert.
		$key = $bbcode_new[1];
		// Und hier dann schließlich in das fertige Youtube-Gerippe eingesetzt :o)
		return '<object width="480" height="385">'.
			'<param name="movie" value="http://www.youtube.com/v/'.$key.'&hl=de&fs=1&"></param>'.
			'<param name="allowFullScreen" value="true"></param>'.
			'<param name="allowscriptaccess" value="always"></param>'.
			'<embed src="http://www.youtube.com/v/'.$key.'&hl=de&fs=1&" type="application/x-shockwave-flash" '.
			'allowscriptaccess="always" allowfullscreen="true" width="480" height="385"></embed></object>';
	}

	/**
	 * 
	 * BBCode img mit width
	 * @param String $treffer
	 */
	private static function img_einbinden($treffer) {
		$ergebnis = "<img src=\"".trim($treffer[2])."\" width=\"".trim($treffer[1])."\">";
		return $ergebnis;
	}
	
	

	/**
	 * 
	 * BBCode Bildergrößencheck bei der Eingabe
	 * @param String $treffer
	 */
	private static function eingabe_picSize($treffer) {
		if (DECLARED) {
			// Wenn Bild lokal abspeichern, damit es später auch noch sicher vorhanden ist
			$file = new Files('declared_pics', null);
			$new = $file->loadPicture($treffer[1]);
		} else {
			$new = array('url' => $treffer[1]);
		}
			
		$size = @getimagesize(isset($new['local']) ? $new['local'] : $new['url']);
		
		// Bilder die breiter als 450 Pixel sind, werden entsprechend markiert
		if ($size[0] > 450)
			return " [imgg]".$new['url']."[/imgg] ";
		else
			return " [img]".$new['url']."[/img] ";
	}

}

?>