<?php 

if (!isset($_GET['type'])) $type = 'public';
else $type = $_GET['type'];

include_once CLASSES.'class_block.php';
$session = new Session();
include_once CLASSES.'class_files.php';

if (($type != 'captcha' && $type != 'impressumMail') &&
	((!isset($_GET['abk'], $_GET['file'])) ||
	 (!preg_match(ABK_REGEX, $_GET['abk'])) ||
	 (!preg_match(FILE_REGEX, $_GET['file']))))
	FatalError('paramError');

$sessionCheck = (!Session::exists('lastRequest')) ||
	((Session::get('lastRequest') + PIC_LOAD_TIME) < TIME);

switch ($type) {
	case 'captcha': {
		// Gibt ein Captchabild aus
		Block::captchaGenerateIMG();
		break;
	}
	case 'impressumMail': {
		//		Einstellungen
		include_once CLASSES.'class_settings.php';
		$text = Settings::get('general', 'absender');
		header('Content-type: image/png');
		$img = ImageCreateFromPNG(DATA.'public_pics/general_email.png'); //Backgroundimage
		$color = ImageColorAllocate($img, 0, 0, 0); //Farbe
		$ttf = DATA."fonts/PTC55F.ttf"; //Schriftart
		$ttfsize = 12; //Schriftgrösse
		$angle = 0; //rand(0,5);
		$t_x = 4; //rand(8,30);
		$t_y = 20;
		imagettftext($img, $ttfsize, $angle, $t_x, $t_y, $color, $ttf, $text);
		imagepng($img);
		imagedestroy($img);
		break;
	}
	case 'declared': {
		// 		User
		include_once CLASSES.'class_user.php';
		//		Einstellungen
		include_once CLASSES.'class_settings.php';
		
		if (($sessionCheck) ||
			(!Settings::is_abk(addslashes($_GET['abk']))) ||
			(($user = User::validateSession(addslashes($_GET['abk']))) &&
		 	(!$user->validate()))) {
			$file = new Files('general', 'error_onlyDeclared.png', 'general');
			break;
		} else {
			$file = new Files('declared_pics', $_GET['file'], $_GET['abk']);
		}
		$file->setErrorPicName('error_onlyDeclared.png');
		$file->outputFile();
		break;
	}
	case 'public': {
		if ((!Session::exists('lastRequest')) ||
			((Session::get('lastRequest') + PIC_LOAD_TIME) < TIME) ||
			(!isset($_GET['abk'], $_GET['file'])) ||
			(!preg_match(ABK_REGEX, $_GET['abk']))) {
			$file = new Files('general', 'error_notAvailable.png', 'general');
		} else {
			$file = new Files('public_pics', $_GET['file'], $_GET['abk']);
		}
		$file->setErrorPicName('error_notAvailable.png');
		$file->outputFile();
		break;
	}
}

unset($session);

?>