<?php 

if (!isset($_GET['type'])) $type = 'design';
else $type = $_GET['type'];

include_once CLASSES.'class_block.php';
$session = new Session();

include_once CLASSES.'class_files.php';


if ((($type != 'abk') && 
	 ((!isset($_GET['file'], $_GET['design'])) ||
	  (!preg_match(FILE_REGEX, $_GET['file'])) ||
	  (!preg_match(ABK_REGEX, $_GET['design'])))) ||
	(($type == 'abk') &&
	 ((!isset($_GET['abk'], $_GET['file'])) ||
	  (!preg_match(ABK_REGEX, $_GET['abk'])) ||
	  (!preg_match(FILE_REGEX, $_GET['file'])))))
	FatalError('paramError');

$sessionCheck = (!Session::exists('lastRequest')) ||
	((Session::get('lastRequest') + PIC_LOAD_TIME) < TIME);

switch ($type) {
	case 'abk': {
		$file = new Files('design_abk', $_GET['file'], $_GET['abk']);
		if ($sessionCheck || 
			(!$file->fileExists())) {
			if (isset($_GET['file']) && substr_count($_GET['file'],"favicon"))
				$_GET['file'] = 'favicon.ico';
			else $_GET['file'] = 'header.png';
			$file = new Files('general', $_GET['file'], 'general');
		}
		$file->setErrorPicName('error_notAvailable.png');
		$file->outputFile();
		break;
	}
	case 'smiley': {
		$file = new Files('design_smiley', $_GET['file'], null);
		if ($sessionCheck) {
			$file = new Files('general', 'error_missing_smiley.png', 'general');
		}
		$file->setErrorPicName('error_missing_smiley.png');
		$file->outputFile();
		break;
	}
	case 'design': {
		$file = new Files('design', $_GET['file'], null, $_GET['design']);
		if (($sessionCheck) || 
			(!$file->fileExists())) {
			$fileName = preg_replace('/^([A-Za-z0-9_ ()-.]+)\.[A-Za-z0-9]{2,4}$/', '\\1', $_GET['file']);
			$file = new Files('general', $fileName.'.png', 'general');
		}
		if ($sessionCheck) {
			$file = new Files('general', 'error_missing_design.png', 'general');
		}
		$file->setErrorPicName('error_missing_design.png');
		$file->outputFile();
		break;
	}
}

unset($session);

?>