<?php

include_once CLASSES.'class_mail.php';
include_once CLASSES.'class_block.php';

// Action überprüfen
if (!isset($_GET['action'])) $_GET['action'] = 'index';
$tpl->assign('_ACTION', $_GET['action']);
define('THIS', MAIN.'?section=login');
$tpl->assign('THIS', THIS);

// Display setzen
$cache->noCache('content', 'all_login.tpl');

switch ($_GET['action']) {
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'index': {
		unset($uebertragenfehler);
		if ('POST' != $_SERVER['REQUEST_METHOD']) {
			$tpl->assign('ACTIVATE_REGISTRATION', Settings::get(ABK, 'ActivateRegistration'));
		}
		elseif (!isset($_POST['Login'], $_POST['PW']))
			Message::$errorType = 'unvalidForm';
		elseif (('' == $nick = $_POST['Login']) ||
				('' == $pw = $_POST['PW']))
			Message::$errorType = 'unfilledForm';
		elseif (Block::timeBlockCheck('login', BLOCK_TIME_LOGIN_MIN))
			Message::$errorType = 'login_spamBlock';
		else {
			unset($_POST);
			// Loginname
			$nick = BBC::validate('nick', $nick);
			$user = new User(null, $nick);
			$user->login($pw);
			unset($pw, $nick);
			if (Message::noError()) {
				Message::$successType = 'login_valid';
				refresh(MAIN.'?section='.Settings::get(ABK, 'std_page1'));
				break;
			}
		}
		if (!Message::noError())
			refresh(THIS);
		unset($nick, $pw);
		Block::timeBlockSet('login');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'erweitern': {
		// Freischaltung da bereits registiert
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'registrieren': {
		Block::timeBlockSet('registration');
		if (Settings::get(ABK, 'ActivateRegistration')) {
			$tpl->assign('REGKEY_SHOW', (Settings::get(ABK, 'RegistrationKey') ? true : false));
		}
		else  {
			Message::$errorType = 'login_reg_notActivated';
			refresh(THIS);
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'reg_indb': {
		if (!Settings::get(ABK, 'ActivateRegistration'))
			Message::$errorType = 'login_reg_notActivated';
		elseif ($_SERVER['REQUEST_METHOD'] != 'POST')
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['Mail'], $_POST['Nickname'], $_POST['PW1'], $_POST['PW2'], $_POST['RegKey'])) &&
				(!isset($_POST['freischalten'], $_POST['Nickname'], $_POST['PW1'], $_POST['PW2'], $_POST['RegKey'])))
			Message::$errorType = 'unvalidForm';
		elseif (!(isset($_POST['acceptAGB']) && ($_POST['acceptAGB'] == 1)))
			Message::$errorType = 'login_haveToAcceptAGB';
		elseif (('' == $nick = trim($_POST['Nickname'])) ||
				('' == $PW1 = trim($_POST['PW1'])) ||
				('' == $PW2 = trim($_POST['PW2'])))
			Message::$errorType = 'unfilledForm';
		elseif (Block::timeBlockCheck('registration'))
			Message::$errorType = 'reg_spamBlock';
		else {
			// RegistierungsKey
			$RegKey = BBC::validate('string 30', trim($_POST['RegKey']), 'login_RegKey');
			if (Settings::get(ABK, 'RegistrationKey') != $RegKey)
				Message::$errorType = 'login_RegKey_unvalid';
			
			// Passwort
			if (($PW1 != $PW2) || (md5($PW1) != md5($PW2))) 
				Message::$errorType = 'login_pw_different';
			
			if (isset($_POST['freischalten']) && $_POST['freischalten'] == '1') {
				// FREISCHALTUNG
				$user = new User(null, $nick);
				if (!$user->validateLogin($PW1, ABK, true))
					Message::$errorType = 'login_unvalid';
				if ($user->validatePagePermission())
					Message::$errorType = 'login_alreadyReleased';
			}
			else {
				// REGISTIERUNG
				
				if (Block::captchaCheck())
					Message::$errorType = 'reg_spamBlock';
				
				// Nick
				$nick = BBC::validate('nick', $nick);
				$user = new User(null, $nick);
				if ($user->validateALL($nick))
					Message::$errorType = 'login_nick_alreadyUsed';
				$PW1 = BBC::validate('pw_create', $PW1, 'profil');
				
				// Mail
				if ('' == $mail = trim($_POST['Mail']))
					Message::$errorType = 'unfilledForm';
				if (Message::noError()) {
					$mail = BBC::validate('mail', $mail);
					if (User::checkMail($mail))
						Message::$errorType = 'login_mail_AlreadyUsed';
				}
			}
				
			// Falls vorherige Checks keinen Fehler ergaben
			if (Message::noError()) {
				if (isset($_POST['freischalten']) && $_POST['freischalten'] == '1') {
					MySQL::insert("INSERT INTO general_users_pages(ID, abk) VALUES ('".$user->getID()."', '".ABK."')");
					if (Settings::is_profilActivated())
						MySQL::insert("INSERT INTO ".ABK."_account(ID) VALUES ('".$user->getID()."')");
					Message::$successType = 'login_release_valid';
					refresh(THIS);
					break;
				} else {
					$key = '';
					for($i = 0; $i < 100; $i++) {
						$key .= rand(0,10);
					}
					$verificationKey = md5($key);
					MySQL::insert("INSERT INTO general_unvalid_accounts(abk, Nick, PW, Mail, VerificationKey) 
						VALUES ('".ABK."', '".$nick."', '".addslashes(md5($PW1))."', '".addslashes($mail)."', '".$verificationKey."')");
					Mail::email_verschicken('activation', 
						array('[link]' => WWW.THIS."&action=reg_verification&nick=".$nick."&key=".$verificationKey, 
							'[title]' => Settings::get(ABK, 'title')), 
						$user, array('mail' => $mail, 'nick' => $nick));
					Message::$successType = 'login_reg_valid';
					refresh(THIS, REF_SUCCESS*5);
					break;
				}
			}
		}
		refresh(THIS);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'reg_verification': {
		if (!Settings::get(ABK, 'ActivateRegistration'))
			Message::$errorType = 'registrationNotActivated';
		elseif (!isset($_GET['nick'], $_GET['key']))
			Message::$errorType = 'unvalidForm';
		elseif (('' == $nick = trim($_GET['nick'])) ||
				('' == $verificationKey = trim($_GET['key'])) ||
				(NICK_MIN_LENGTH >= strlen($nick)) ||
				(strlen($nick) > NICK_MAX_LENGTH) ||
				(preg_match(NICK_REGEX, $nick)))
			Message::$errorType = 'login_link_unvalid';
		elseif (!MySQL::single("SELECT COUNT(*) FROM general_unvalid_accounts WHERE abk = '".ABK."' 
				AND Nick = '".addslashes($nick)."' AND VerificationKey = '".addslashes($verificationKey)."'"))
			Message::$errorType = 'login_keyNickCombination_unvalid';
		else {
			// Account in _account eintragen und aus general_unvalid_accounts l�schen
			$new_user = MySQL::assoc("SELECT Nick, PW, Mail FROM general_unvalid_accounts WHERE abk = '".ABK."' 
				AND Nick = '".addslashes($nick)."' AND VerificationKey = '".addslashes($verificationKey)."'");
			$id = MySQL::insert("INSERT INTO general_users(Nick, PW, EMail)
				VALUES ('".$new_user['Nick']."', '".$new_user['PW']."', '".$new_user['Mail']."')");
			MySQL::insert("INSERT INTO general_users_pages(ID, abk) VALUES ('".$id."', '".ABK."')");
			if (Settings::is_profilActivated())
				MySQL::insert("INSERT INTO ".ABK."_account(ID) VALUES ('".$id."')");
			MySQL::query("DELETE FROM general_unvalid_accounts WHERE abk = '".ABK."' 
				AND Nick = '".addslashes($nick)."' AND VerificationKey = '".addslashes($verificationKey)."'");
			Message::$successType = 'login_regVerify_valid';
			refresh(THIS);
			break;
		}
		refresh(THIS);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'setPW': {
		break;
		/*
		$nick = 'Koni';
		$user = new User(null, $nick);
		$verificationKey = 'lksdfjlawefjlsdkjf';
		$mail = 'koni-g@web.de';
		
		Mail::email_verschicken('activation', 
			array('[link]' => WWW.THIS."&action=reg_verification&nick=".$nick."&key=".$verificationKey, 
				'[title]' => Settings::get(ABK, 'title')), 
			$user, array('mail' => $mail, 'nick' => $nick));
		*/
		/*$all = assocs("SELECT * FROM general_settings");
		foreach($all as $page) {
			$abk = $page['abk'];
			
			
			
			if (tableExists_spezific($abk.'_account')) {
				select("UPDATE ".$abk."_account SET ID = ID + 100");
				if (tableExists_spezific($abk.'_kalender_termine')) 
					select("UPDATE ".$abk."_kalender_termine SET AutorID = AutorID + 100");
				if (tableExists_spezific($abk.'_forum_thread')) 
					select("UPDATE ".$abk."_forum_thread SET AutorID = AutorID + 100");
				if (tableExists_spezific($abk.'_forum_post')) 
					select("UPDATE ".$abk."_forum_post SET AutorID = AutorID + 100");
				if (tableExists_spezific($abk.'_gaestebuch')) 
					select("UPDATE ".$abk."_gaestebuch SET AutorID = AutorID + 100");
				$users = assocs("SELECT * FROM ".$abk."_account");
				foreach($users as $user) {
					if (!single("SELECT COUNT(*) FROM general_users WHERE Nick = '".$user['Nick']."'"))
						select("INSERT INTO general_users(Nick, PW, EMail) 
							VALUES ('".$user['Nick']."', '".$user['PW']."', '".$user['EMail']."')");
					$id = single("SELECT ID FROM general_users WHERE Nick = '".$user['Nick']."'");
					select("INSERT INTO general_users_pages(ID, abk) VALUES ('".$id."', '".$abk."')");
					select("UPDATE ".$abk."_account SET ID = '".$id."' WHERE Nick = '".$user['Nick']."'");
					if (tableExists_spezific($abk.'_kalender_termine'))
						select("UPDATE ".$abk."_kalender_termine SET AutorID = '".$id."' WHERE Autor = '".$user['Nick']."'");
					if (tableExists_spezific($abk.'_forum_thread')) 
						select("UPDATE ".$abk."_forum_thread SET AutorID = '".$id."' WHERE Autor = '".$user['Nick']."'");
					if (tableExists_spezific($abk.'_forum_post')) 
						select("UPDATE ".$abk."_forum_post SET AutorID = '".$id."' WHERE Autor = '".$user['Nick']."'");
					if (tableExists_spezific($abk.'_gaestebuch')) 
						select("UPDATE ".$abk."_gaestebuch SET AutorID = '".$id."' WHERE Autor = '".$user['Nick']."'");
				}
			} 
			if (tableExists_spezific($abk.'_account'))
				select("ALTER TABLE `".$abk."_account`
				 	DROP `Nick`, DROP `PW`, DROP `EMail`, DROP `currentSession`");
			
		} */
		
	}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

?>