<?php

include CLASSES.'class_mail.php';
include CLASSES.'class_termin.php';

// Überprüfen ob die Kalender-Tabelle existiert
if (!Settings::is_KalenderActivated()) {
	Message::$errorType = 'kal_noKalender';
	refresh(MAIN);
} else {
	
	// Action überprüfen
	if (!isset($_GET['action'])) $_GET['action'] = 'index';
	$tpl->assign('_ACTION', $_GET['action']);
	define('THIS', MAIN.'?section=kalender');
	$tpl->assign('THIS', THIS);
	
	// TerminID überprüfen
	if (!isset($_GET['TerminID'])) $_GET['TerminID'] = 0;
	$cur_termin = new Termin(addslashes($_GET['TerminID']));
	if (!$cur_termin->is_TerminID()) $TerminID = 0;
	else {
		$TerminID = $cur_termin->get('TerminID');
		$Datum = $cur_termin->get('Datum');
	}
	
	if (isset($_GET['Datum'])) {
		$Datum = addslashes($_GET['Datum']);
		$Year = date('Y', $Datum);
		$Month = date('n', $Datum);
		$Day = date('j', $Datum);
	} else {
		// Datum überprüfen
		if (!isset($Datum)) $Datum = TIME;
		
		// Jahr überprüfen
		if (!isset($_GET['Year'])) $Year = date('Y', $Datum);
		else $Year = addslashes($_GET['Year']);
		
		// Monat überprüfen
		if (!isset($_GET['Month'])) $Month = date('n', $Datum);
		else $Month = addslashes($_GET['Month']);
		
		// Tag überprüfen
		if (!isset($_GET['Day'])) $Day = date('j', $Datum);
		else $Day = addslashes($_GET['Day']);
		
		// Datum nachkorrigieren
		$Datum = strtotime($Year."-".$Month."-".$Day." 12:00");
	}
	// Auf sinnige Eingaben prüfen
	$Year = BBC::validate('year', $Year, 'kal');
	$Month = BBC::validate('month', $Month, 'kal');
	$Day = BBC::validate('day', $Day, 'kal');
	
	if (!Message::noError()) {
		refresh(THIS);
	}
	
	// _GET assigns
	$tpl->assign('_TERMINID', $TerminID);
	$tpl->assign('_DATUM', $Datum);
	$tpl->assign('_YEAR', $Year);
	$tpl->assign('_MONTH', $Month);
	$tpl->assign('_DAY', $Day);
	
}
if (Message::noError()) {
	// Display setzen
	$cache->noCache('content', 'all_kalender.tpl');
	switch ($_GET['action']) {
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'index': {
			if (!$cache->isCached('content', 'all_kalender.tpl', ABK.'|'.$Year.'|'.$Month.'|'.NICKID, -1)) {
				$tpl->assign('o_MONTH', $message->str_monat($Month));
				$back_Monat = $Month -1;
				if ($back_Monat == 0) {
					$back_Jahr = $Year -1;
					$back_Monat = 12;
				}
				else $back_Jahr = $Year;
				$next_Monat = $Month +1;
				if ($next_Monat == 13) {
					$next_Jahr = $Year +1;
					$next_Monat = 1;
				}
				else $next_Jahr = $Year;
				$tpl->assign('BACK_MONTH', $back_Monat);
				$tpl->assign('BACK_MONTH_NAME', $message->str_monat($back_Monat));
				$tpl->assign('BACK_YEAR', $back_Jahr);
				$tpl->assign('NEXT_MONTH', $next_Monat);
				$tpl->assign('NEXT_MONTH_NAME', $message->str_monat($next_Monat));
				$tpl->assign('NEXT_YEAR', $next_Jahr);
				
				// Übersicht des ausgewählten Monats
				$days = array(); $vl = array();
				For ( $i = 1; $i <= date('t', $Datum); $i++ ) {
					$vl['time'] = $time = strtotime($Year."-".$Month."-".$i." 12:00");
					$vl['o_wochentag'] = $message->str_wochentage($time);
					$vl['Day'] = $i;
					$termine = MySQL::assocs("SELECT Titel, Status, Datum FROM ".ABK."_kalender_termine 
						WHERE ((Datum = '".$time."' AND Status = '0') 
							OR (Datum = '".$time."' AND Status = '2' AND AutorID = '".NICKID."' )) ORDER BY Titel");
					$termine_output = array();
					foreach($termine as $temp) {
						$temp['Titel'] = $BBC->ausgabe($temp['Titel'], false);
						array_push($termine_output, $temp);
					}
					$vl['Termine'] = $termine_output;
					array_push($days, $vl);
					unset($vl);
				}
				$tpl->assign('DAYS', $days);
			}
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'neueste_Termine': {
			$termine = MySQL::assocs("SELECT * FROM ".ABK."_kalender_termine
				WHERE ( Status = '0' OR (Status = '2' AND AutorID = '".NICKID."') ) ORDER BY Timestamp DESC Limit 20");
			$termine_output = array();
			if (count($termine)) {
				foreach($termine as $vl) {
					$vl['o_markiert'] = ((TIME - DAY*2) < $vl['Timestamp']);
					$vl['Titel'] = $BBC->ausgabe($vl['Titel'], false);
					array_push($termine_output, $vl);
				}
			}
			$tpl->assign('NEW_TERMINE', $termine_output);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'Termin_eintragen': {
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'Termin_indb': {
			if ('POST' != $_SERVER['REQUEST_METHOD'])
				Message::$errorType = 'unvalidRequest';
			elseif (!isset($_GET['Titel'], $_GET['Beschreibung'], $_GET['Status'] )) 
				Message::$errorType = 'unvalidForm';
			else{
				$status = addslashes($_GET['Status']);
				if (('' == $beschreibung = trim($_GET['Beschreibung'])) or
					('' == $titel = trim($_GET['Titel'])) or
					(($_GET['Status'] != 0 AND $_GET['Status'] != 2)))
					Message::$errorType = 'unfilledForm';
				else {
					$titel = BBC::validate('name', $titel, 'kal');
					$beschreibung = BBC::validate('BBC', $beschreibung, 'kal');
					if (Message::noError()) {
						$new_termin = new Termin(null, 
							array('TerminID' => null, 'Datum' => $Datum, 
								'Titel' => $titel, 'Beschreibung' => $beschreibung, 'Status' => $status));
						$new_termin->add();
						$cache->clearCache('all_kalender.tpl', ABK.'|'.$Year.'|'.$Month.($new_termin->is_public() ? '' : '|'.NICKID));
						Message::$successType = 'kal_entry_new';
						refresh(THIS.'&amp;action=index&amp;Datum='.$Datum);
						if ($status == 0) {
							Mail::email_verschicken_alle('newTermin', 
								array('[nick]' => NICK, '[titel]' => $titel, '[datum]' => date('d. M Y',$Datum)));
						}
						break;
					}
				}
			}
			refresh(THIS);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'Termin_anzeigen': {
			// Datum überprüfen
			$tpl->assign('_MONTH_NAME', $message->str_monat($Datum));
			$termine = MySQL::assocs("SELECT * FROM ".ABK."_kalender_termine 
				WHERE ((Datum = '".$Datum."' AND Status = '0') 
					OR (Datum = '".$Datum."' AND Status = '2' AND AutorID = '".NICKID."' )) ORDER BY Titel");
			$termine_output = array();
			if (count($termine)) {
				foreach($termine as $vl) {
					$vl['Titel'] = $BBC->ausgabe($vl['Titel'], false);
					$vl['Beschreibung'] = $BBC->ausgabe($vl['Beschreibung']);
					$vl['Timestamp_Month'] = $message->str_monat($vl['Timestamp']);
					$vl['show_diskussion'] = Termin::getDiskussionStartPermissionS($vl['Status']);
					array_push($termine_output, $vl);
				}
			}
			$tpl->assign('TERMINE', $termine_output);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'edit': {
			if ($cur_termin->getEditPermission()) {
				$termin = $cur_termin->getALL();
				$termin['Titel'] = $BBC->ausgabe($termin['Titel'], false);
				$termin['Beschreibung'] = $BBC->ausgabe($termin['Beschreibung'], false);
				$tpl->assign('OLD', $termin);
				break;
			}
			Message::$errorType = 'kal_edit_noPermisson';
			refresh(THIS);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    case 'edit_indb': {
			if (!$cur_termin->getEditPermission())
				Message::$errorType = 'kal_edit_noPermisson';
			elseif ('POST' != $_SERVER['REQUEST_METHOD'])
				Message::$errorType = 'unvalidRequest';
			elseif (!isset($_GET['Titel'], $_GET['Beschreibung'])) 
				Message::$errorType = 'unvalidForm';
			elseif (('' == $beschreibung = trim($_GET['Beschreibung'])) or
					('' == $titel = trim($_GET['Titel'])) )
				Message::$errorType = 'unfilledForm';
			else {
				$titel = BBC::validate('name', $titel, 'kal');
				$beschreibung = BBC::validate('BBC', 
					$beschreibung."\n\n".$message->info('kal_edit_TerminMark', 
						array('[nick]' => NICK, '[date]' => date('d. M Y H:i',TIME))), 'kal');
				if (Message::noError()) {
					$cur_termin->set('Datum', $Datum);
					$cur_termin->set('Titel', $titel);
					$cur_termin->set('Beschreibung', $beschreibung);
					$cur_termin->add();
					$cache->clearCache('all_kalender.tpl', ABK.'|'.$Year.'|'.$Month.($cur_termin->is_public() ? '' : '|'.NICKID));
					Message::$successType = 'kal_entry_edit';
					refresh(THIS.'&amp;action=Termin_anzeigen&amp;Datum='.$Datum);
				}
				break;
			}
			refresh(THIS);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'delete': {
			if (!$cur_termin->getDelPermission())
				Message::$errorType = 'kal_del_noPermisson';
			else {
				$cache->clearCache('all_kalender.tpl', ABK.'|'.$Year.'|'.$Month.($cur_termin->is_public() ? '' : '|'.NICKID));
				$cur_termin->del();
				Message::$successType = 'kal_entry_del';
				refresh(THIS.'&amp;action=Termin_anzeigen&amp;Datum='.$Datum);
				break;
			}
			refresh(THIS);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}

}
?>
